/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.google.common.base.Predicate;
import com.swdteam.common.tileentity.DMTileEntityBase;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDMTileEntityBase
extends BlockContainer {
    public Class<? extends TileEntity> TestEntityClass;
    public AxisAlignedBB bounds;
    private boolean noCollision = false;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockDMTileEntityBase(Class<? extends TileEntity> tClass) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.TestEntityClass = tClass;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        try {
            return this.TestEntityClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_111206_d((String)"air");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (placer.func_70093_af() && (te = worldIn.func_175625_s(pos)) instanceof DMTileEntityBase) {
            int i = MathHelper.func_76128_c((double)((double)placer.field_70177_z + 180.0));
            if ((i = 45 * Math.round(i / 45)) < 0) {
                i = 360 + i;
            }
            ((DMTileEntityBase)te).rotation = i;
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public TileEntity func_149915_a(World world, int i) {
        try {
            return this.TestEntityClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public Block setNoCollision(boolean noCollision) {
        this.noCollision = noCollision;
        return this;
    }

    public boolean noCollision() {
        return this.noCollision;
    }

    public void setBlockBounds(AxisAlignedBB bounds) {
        this.bounds = bounds;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.bounds != null) {
            return this.bounds;
        }
        return super.func_185496_a(state, source, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (this.noCollision) {
            return field_185506_k;
        }
        if (this.bounds != null) {
            return this.bounds;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }
}

