/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen;

import com.swdteam.common.entity.EntityAuton;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.world.gen.structures.WorldGenClassicTree;
import com.swdteam.main.config.DMConfig;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DMOreGeneration
implements IWorldGenerator {
    private void runGenerator(IBlockState s, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        boolean prevLogging = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Ore generation occuring too high");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int z;
            int y;
            int x = chunk_X * 16 + rand.nextInt(16);
            BlockPos bs = new BlockPos(x, y = minHeight + rand.nextInt(heightDiff), z = chunk_Z * 16 + rand.nextInt(16));
            if (world.func_180495_p(bs.func_177982_a(0, 1, 0)).func_177230_c().func_149688_o(s) != Material.field_151576_e) continue;
            for (int j = 0; j < chancesToSpawn; ++j) {
                world.func_175656_a(bs, s);
                world.func_175656_a(bs.func_177982_a(-j, 0, -j), s);
                world.func_175656_a(bs.func_177982_a(j, 0, j), s);
                world.func_175656_a(bs.func_177982_a(0, 0, -j), s);
                world.func_175656_a(bs.func_177982_a(-j, 0, 0), s);
                world.func_175656_a(bs.func_177982_a(0, -j, -j), s);
                world.func_175656_a(bs.func_177982_a(-j, -j, 0), s);
            }
        }
        ForgeModContainer.logCascadingWorldGeneration = prevLogging;
    }

    private void spawnDaleks(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 5; ++i) {
            int randPosZ;
            int randPosX = chunkX + 8;
            int randPosY = rand.nextInt(96);
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ = chunkZ + 8);
            if (world.func_175623_d(pos) || !world.func_175623_d(pos.func_177982_a(0, 1, 0))) continue;
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150391_bh) {
                return;
            }
            if (rand.nextInt(2) != 1 || world.field_73011_w.getDimension() == DMConfig.DimensionIDs.Skaro_Dimension_ID) continue;
            EntityAuton dalek = new EntityAuton(world);
            dalek.func_70107_b(randPosX, randPosY + 1, randPosZ);
            world.func_72838_d((Entity)dalek);
        }
    }

    private void generateClassicTrees(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 90; ++i) {
            int randPosZ;
            int randPosX = chunkX + 8;
            int randPosY = rand.nextInt(96);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ = chunkZ + 8)) != DMBlocks.classic_grass) continue;
            new WorldGenClassicTree().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimID = world.field_73011_w.getDimension();
        WorldGenMinable genTitaniumOre = new WorldGenMinable(DMBlocks.bTitaniumOre.func_176223_P(), 8);
        WorldGenMinable genZeitonOre = new WorldGenMinable(DMBlocks.zeitonore.func_176223_P(), 17);
        WorldGenMinable genSilicateOre = new WorldGenMinable(DMBlocks.silicate.func_176223_P(), 8);
        WorldGenMinable genSonicCrystalOre = new WorldGenMinable(DMBlocks.SonicCrystalOre.func_176223_P(), 8);
        if (dimID == DMConfig.DimensionIDs.Moon_Dimension_ID) {
            this.runGenerator(DMBlocks.bTitaniumOre.func_176223_P(), world, random, chunkX, chunkZ, 2, 0, 96);
        }
        if (dimID == 0) {
            this.runGenerator(DMBlocks.silicate.func_176223_P(), world, random, chunkX, chunkZ, 2, 0, 64);
            this.runGenerator(DMBlocks.SonicCrystalOre.func_176223_P(), world, random, chunkX, chunkZ, 2, 0, 64);
        }
        if (dimID == DMConfig.DimensionIDs.Varos_Dimension_ID) {
            this.runGenerator(DMBlocks.zeitonore.func_176223_P(), world, random, chunkX, chunkZ, 2, 0, 64);
        }
        if (dimID == DMConfig.DimensionIDs.Minecraft_Classic_Dimension_ID) {
            this.generateClassicTrees(world, random, chunkX * 16, chunkZ * 16);
        }
        if ((dimID == DMConfig.DimensionIDs.Skaro_Dimension_ID || dimID == 0) && DMConfig.ServerSide.SPAWN_DALEKS) {
            this.spawnDaleks(world, random, chunkX * 16, chunkZ * 16);
        }
    }
}

