/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.model.ModelBiped18;
import com.swdteam.client.model.ModelClockworkDroid;
import com.swdteam.client.model.ModelK9;
import com.swdteam.client.model.ModelK9Australia;
import com.swdteam.client.model.auton.ModelAuton;
import com.swdteam.client.model.cybermen.ModelCybermanNew;
import com.swdteam.client.model.daleks.ModelDalek;
import com.swdteam.client.model.daleks.ModelMovieDalek;
import com.swdteam.client.model.daleks.ModelPadDalek;
import com.swdteam.client.model.daleks.ModelSpecialWeaponsDalek;
import com.swdteam.client.model.daleks.ModelSuicideDalek;
import com.swdteam.client.model.gasmask_zombies.ModelEmptyNPC;
import com.swdteam.client.model.gasmask_zombies.ModelVilGm;
import com.swdteam.client.model.snowmen.ModelSnowman;
import com.swdteam.client.skinpack.ModelSkinpackBase;
import com.swdteam.client.skinpack.Skin;
import com.swdteam.client.skinpack.SkinSession;
import com.swdteam.client.skinpack.Skinpack;
import com.swdteam.utils.DataManager;
import com.swdteam.utils.IOUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class DMSkinpacks {
    public static HashMap<String, ModelBase> internalModels = new HashMap();
    public static HashMap<String, ModelBase> externalModels = new HashMap();
    public static HashMap<String, BufferedImage> externalTextures = new HashMap();
    public static HashMap<Integer, Skinpack> skinPacks = new HashMap();
    public static HashMap<String, SkinSession> skinSessions = new HashMap();

    public static int clearCache() {
        int i = 0;
        i += internalModels.size();
        i += externalModels.size();
        i += externalTextures.size();
        i += skinPacks.size();
        i += skinSessions.size();
        internalModels.clear();
        externalModels.clear();
        externalTextures.clear();
        skinPacks.clear();
        skinSessions.clear();
        DMSkinpacks.init();
        return i;
    }

    public static void addSession(String username, int pack, int skin) {
        SkinSession skinSession = new SkinSession(username, pack, skin);
        skinSessions.put(username, skinSession);
    }

    public static void deleteSession(String username) {
        skinSessions.remove(username);
    }

    public static SkinSession getSession(String username) {
        return skinSessions.get(username);
    }

    public static boolean sessionExists(String user) {
        return skinSessions.containsKey(user);
    }

    public static void init() {
        internalModels.put("MovieDalek", new ModelMovieDalek());
        internalModels.put("60sDalek", new ModelDalek());
        internalModels.put("ParadigmDalek", new ModelPadDalek());
        internalModels.put("Cyberman", new ModelCybermanNew());
        internalModels.put("EmptyNPC", new ModelEmptyNPC());
        internalModels.put("Auton", new ModelAuton());
        internalModels.put("GMVillager", new ModelVilGm(0.0f));
        internalModels.put("ClockworkDroid", new ModelClockworkDroid());
        internalModels.put("K9", new ModelK9());
        internalModels.put("K9Regen", new ModelK9Australia());
        internalModels.put("Snowman", new ModelSnowman());
        internalModels.put("SpecialWeaponsDalek", new ModelSpecialWeaponsDalek());
        internalModels.put("SuicideDalek", new ModelSuicideDalek());
        ModelBiped biped = new ModelBiped();
        biped.field_78091_s = false;
        internalModels.put("ModelBiped", (ModelBase)biped);
        internalModels.put("ModelBipedChild", (ModelBase)new ModelBiped());
        internalModels.put("ModelBiped18", new ModelBiped18(0.0f, 0.0f, 64, 64));
        DMSkinpacks.searchForSkinPacks();
    }

    private static void searchForSkinPacks() {
        String downloadData;
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath();
        File f = new File(fileDir + "/mods/Dalek Mod/data/skinpacks/");
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((downloadData = DataManager.getPage("http://swdteam.com/scripts/snpkData.php")) != null && downloadData.length() > 0 && !downloadData.startsWith("<")) {
            String[] packsToDownload = downloadData.split(",");
            for (int i = 0; i < packsToDownload.length; ++i) {
                if (!new File(f.getAbsolutePath() + "/" + packsToDownload[i] + ".skn").exists()) {
                    IOUtils.tryDownloadFile("http://files.swdteam.com/skinpacks/" + packsToDownload[i] + ".skn", f.getAbsolutePath() + "/" + packsToDownload[i] + ".skn");
                    continue;
                }
                URL skinUrl = null;
                try {
                    skinUrl = new URL("http://files.swdteam.com/skinpacks/" + packsToDownload[i] + ".skn");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                File skinPath = new File(f.getAbsolutePath() + "/" + packsToDownload[i] + ".skn");
                if (skinUrl == null || (long)IOUtils.getFileSizeURL(skinUrl) == skinPath.length()) continue;
                System.out.println("Skinpack " + packsToDownload[i] + " corrupted.");
                try {
                    IOUtils.tryDownloadFile("http://files.swdteam.com/skinpacks/" + packsToDownload[i] + ".skn", f.getAbsolutePath() + "/" + packsToDownload[i] + ".skn");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        for (File dirFile : f.listFiles()) {
            if (!dirFile.getName().endsWith(".skn")) continue;
            ZipFile fis1 = null;
            try {
                fis1 = new ZipFile(dirFile.getAbsoluteFile());
                if (fis1.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis1.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entryZip = e.nextElement();
                        if (!entryZip.getName().endsWith(".png")) continue;
                        InputStream input = fis1.getInputStream(entryZip);
                        externalTextures.put(entryZip.getName().substring(0, entryZip.getName().length() - 4), ImageIO.read(input));
                        input.close();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ZipFile fis2 = null;
            try {
                fis2 = new ZipFile(dirFile.getAbsoluteFile());
                if (fis2.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis2.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entryZip = e.nextElement();
                        if (!entryZip.getName().endsWith(".scn")) continue;
                        InputStream input = fis2.getInputStream(entryZip);
                        externalModels.put(entryZip.getName().substring(0, entryZip.getName().length() - 4), new ModelSkinpackBase(input));
                        input.close();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ZipFile fis = null;
            try {
                fis = new ZipFile(dirFile.getAbsoluteFile());
                if (fis.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (!entry.getName().equals(".pkdta")) continue;
                        InputStream in = fis.getInputStream(entry);
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        Skinpack pack = new Skinpack(Integer.parseInt(DMSkinpacks.getValue(r.readLine())));
                        pack.setSkinpackName(DMSkinpacks.getValue(r.readLine()));
                        pack.setSkinpackCreator(DMSkinpacks.getValue(r.readLine()));
                        pack.setSkinpackDate(DMSkinpacks.getValue(r.readLine()));
                        ArrayList<Skin> skins = new ArrayList<Skin>();
                        String line = r.readLine();
                        if (line.contains("PackContents")) {
                            String lineData;
                            while (!(lineData = r.readLine()).endsWith("}")) {
                                Skin skin = new Skin();
                                String data = lineData.substring(2, lineData.length() - 2);
                                String[] skinData = data.split("\\.");
                                skin.setSkinName(skinData[0]);
                                skin.setModelName(skinData[1]);
                                skin.setModelLocation(skinData[2].toLowerCase().startsWith("i") ? Skin.FileLocation.INTERNAL : Skin.FileLocation.EXTERNAL);
                                skin.setTextureDir(skinData[3]);
                                skin.setTextureLocation(skinData[4].toLowerCase().startsWith("i") ? Skin.FileLocation.INTERNAL : Skin.FileLocation.EXTERNAL);
                                skin.setup();
                                skins.add(skin);
                            }
                        }
                        r.close();
                        Skin[] skinArray = new Skin[skins.size()];
                        skinArray = skins.toArray(skinArray);
                        pack.setSkins(skinArray);
                        skinPacks.put(pack.getSkinPackID(), pack);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fis == null) continue;
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getValue(String s) {
        return s.substring(s.indexOf(":") + 1);
    }
}

