/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMDownload;
import com.swdteam.client.model.obj.ModelOBJ;
import com.swdteam.common.data.OBJBlockData;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.IOUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.AxisAlignedBB;

public class DMObjViewer {
    public static LinkedHashMap<String, OBJBlockData> models = new LinkedHashMap();

    public static void init() throws Exception {
        File folder = new File(Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/data/swdj");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        List<String> data = Arrays.asList(DMDownload.swdModelList);
        for (String d : data) {
            File file = new File(folder.getAbsolutePath() + "/" + d + ".swdj");
            if (!file.exists()) {
                IOUtils.tryDownloadFile("http://api.swdteam.com/files/dm/swdj/" + d + ".swdj", file.getAbsolutePath());
                continue;
            }
            if ((long)IOUtils.getFileSizeURL(new URL("http://api.swdteam.com/files/dm/swdj/" + d + ".swdj")) == file.length()) continue;
            IOUtils.tryDownloadFile("http://api.swdteam.com/files/dm/swdj/" + d + ".swdj", file.getAbsolutePath());
        }
        for (File f : folder.listFiles()) {
            DMObjViewer.loadModel(f);
        }
    }

    public static ModelOBJ loadModel(File f) {
        if (!f.exists()) {
            IOUtils.tryDownloadFile("http://api.swdteam.com/files/dm/swdj/" + f.getName(), f.getAbsolutePath());
        }
        BufferedImage image = null;
        ModelOBJ model = null;
        SWDJInfo modelData = null;
        if (f.getAbsolutePath().endsWith(".swdj")) {
            try {
                ZipFile fis1 = new ZipFile(f.getAbsoluteFile());
                if (fis1.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis1.entries();
                    while (e.hasMoreElements()) {
                        String line;
                        InputStream input;
                        ZipEntry entryZip = e.nextElement();
                        if (entryZip.getName().endsWith(".png")) {
                            input = fis1.getInputStream(entryZip);
                            image = ImageIO.read(input);
                        }
                        if (entryZip.getName().endsWith(".obj")) {
                            input = fis1.getInputStream(entryZip);
                            model = new ModelOBJ(input, entryZip.getName());
                        }
                        if (!entryZip.getName().equals("info.json")) continue;
                        input = fis1.getInputStream(entryZip);
                        BufferedReader r = new BufferedReader(new InputStreamReader(input));
                        StringBuilder sb = new StringBuilder();
                        while ((line = r.readLine()) != null) {
                            sb.append(line);
                        }
                        modelData = (SWDJInfo)TheDalekMod.GSON.fromJson(sb.toString(), SWDJInfo.class);
                    }
                    if (image != null && modelData != null && modelData.block_render_bounds != null) {
                        model.textureBI = image;
                        OBJBlockData data = new OBJBlockData(f.getName(), modelData);
                        data.setModel(model);
                        models.put(f.getName(), data);
                    }
                }
                fis1.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return model;
    }

    public static class SWDJInfo {
        public String model_display_name;
        public AxisAlignedBB block_render_bounds;
    }
}

