/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui;

import com.swdteam.client.data.ServerDataHub;
import com.swdteam.client.gui.title.backgrounds.GuiPanoramaDMUHub;
import com.swdteam.client.init.DMTextures;
import com.swdteam.client.overlay.OverlaySonicShades;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.IOUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiDMUHubWorld
extends GuiScreen {
    private boolean isLoading = true;
    private boolean serverOffline = false;
    private ServerDataHub serverData;
    private static final GuiPanoramaDMUHub BG = new GuiPanoramaDMUHub();
    private ScheduledExecutorService exec;
    private GuiScreen previousScreen;
    List<String> l = new ArrayList<String>();
    private static final String HOST = "dmu.swdteam.co.uk";
    private static final int PORT = 25587;

    public GuiDMUHubWorld(GuiScreen previousScreen) {
        this.previousScreen = previousScreen;
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.exec.scheduleAtFixedRate(() -> {
            try {
                String url = "http://dmu.swdteam.co.uk/api/scripts/getAllPlayers.php";
                String response = IOUtils.getJsonFromURL(url);
                this.serverData = (ServerDataHub)TheDalekMod.GSON.fromJson(response, ServerDataHub.class);
                this.isLoading = false;
                if (this.serverData == null) {
                    this.serverOffline = true;
                }
            }
            catch (Exception e) {
                this.serverOffline = true;
                this.isLoading = false;
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 145, this.field_146295_m / 2 + 40, 38, 20, "Back"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 105, this.field_146295_m / 2 + 40, 82, 20, "DMU Public"));
        GuiButton btnPrivate18 = new GuiButton(3, this.field_146294_l / 2 - 21, this.field_146295_m / 2 + 40, 82, 20, "DMU Beta");
        this.field_146292_n.add(btnPrivate18);
        GuiButton btnCreative18 = new GuiButton(4, this.field_146294_l / 2 + 63, this.field_146295_m / 2 + 40, 82, 20, "DMU Creative");
        this.field_146292_n.add(btnCreative18);
        GuiButton joinServerBtn = new GuiButton(1, this.field_146294_l / 2 - 144, this.field_146295_m / 2 + 62, 144, 20, "DMU Store");
        this.field_146292_n.add(joinServerBtn);
        joinServerBtn = new GuiButton(5, this.field_146294_l / 2 + 1, this.field_146295_m / 2 + 62, 144, 20, "Buy Ranks");
        this.field_146292_n.add(joinServerBtn);
        joinServerBtn.field_146124_l = true;
        btnPrivate18.field_146124_l = true;
    }

    public void func_146281_b() {
        this.exec.shutdownNow();
        super.func_146281_b();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.l.clear();
        BG.render(this.field_146294_l, this.field_146295_m, mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        Graphics.draw(OverlaySonicShades.OVERLAY, 0.0f, 0.0f, this.field_146294_l, this.field_146295_m, 0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        Graphics.FillRect((double)(this.field_146294_l / 2 - 160), (double)(this.field_146295_m / 2 - 100), 320.0, 200.0, 0.0, -872415232);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 161), (double)(this.field_146295_m / 2 - 101), 322.0, 1.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 161), (double)(this.field_146295_m / 2 - 100), 1.0, 200.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 + 160), (double)(this.field_146295_m / 2 - 100), 1.0, 200.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 161), (double)(this.field_146295_m / 2 + 100), 322.0, 1.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 80), (double)(this.field_146295_m / 2 - 80), 160.0, 1.0, 0.0, -1);
        this.func_73732_a(this.field_146289_q, "Dalek Mod Universe", this.field_146294_l / 2, this.field_146295_m / 2 - 92, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Select a server from below", this.field_146294_l / 2, this.field_146295_m / 2 - 74, -5592406);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 160), (double)(this.field_146295_m / 2 - 50), 320.0, 1.0, 0.0, -1);
        Graphics.FillRect((double)(this.field_146294_l / 2 - 160), (double)(this.field_146295_m / 2 + 32), 320.0, 1.0, 0.0, -1);
        this.func_73732_a(this.field_146289_q, "(Any issues please visit SWDTeam.com/forums)", this.field_146294_l / 2, this.field_146295_m / 2 + 87, 0x555555);
        if (this.isLoading) {
            this.func_73732_a(this.field_146289_q, "Loading...", this.field_146294_l / 2, this.field_146295_m / 2 - 10, 0xFFFF00);
        } else if (this.serverOffline || this.serverData == null || this.serverData != null && this.serverData.getPlayers() == null) {
            this.func_73732_a(this.field_146289_q, "Server Offline", this.field_146294_l / 2, this.field_146295_m / 2 - 10, 0xFF0000);
        } else {
            this.field_146289_q.func_175065_a("Players Online: (" + this.serverData.getPlayers().length + "/" + this.serverData.getMaximumPlayers() + ")", (float)(this.field_146294_l / 2 - 142), (float)(this.field_146295_m / 2 - 62), 0xFFFFFF, true);
            for (int i = 0; i < 64; ++i) {
                float rowMax = 16.0f;
                int xPos = this.field_146294_l / 2 - 142 + 18 * (i % (int)rowMax);
                float in = (float)i / rowMax;
                int yPos = this.field_146295_m / 2 - 44 + 18 * MathHelper.func_76141_d((float)in);
                if (i < this.serverData.getPlayers().length) {
                    ServerDataHub.Player player = this.serverData.getPlayers()[i];
                    Graphics.bindTexture(Graphics.getTextureForPlayer(player.getUsername()));
                    GuiDMUHubWorld.func_146110_a((int)xPos, (int)yPos, (float)16.0f, (float)16.0f, (int)16, (int)16, (float)128.0f, (float)128.0f);
                    GuiDMUHubWorld.func_146110_a((int)xPos, (int)yPos, (float)80.0f, (float)16.0f, (int)16, (int)16, (float)128.0f, (float)128.0f);
                    if (mouseX <= xPos || mouseX >= xPos + 16 || mouseY <= yPos || mouseY >= yPos + 16) continue;
                    this.l.add(TextFormatting.YELLOW + "" + TextFormatting.BOLD + player.getUsername());
                    this.l.add("Server: " + player.getServerName());
                    continue;
                }
                Graphics.draw(DMTextures.grey_head.getResourceLocation(), xPos, yPos, 16.0f, 16.0f, 0);
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146283_a(this.l, mouseX, mouseY);
    }

    public void func_73876_c() {
        BG.update(this.field_146294_l, this.field_146295_m, 0, 0);
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            Minecraft.func_71410_x().func_147108_a(this.previousScreen);
        }
        if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25587));
        }
        if (button.field_146127_k == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25565));
        }
        if (button.field_146127_k == 4) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, HOST, 25569));
        }
        if (button.field_146127_k == 1) {
            try {
                Desktop.getDesktop().browse(new URI("https://swdteam.com/DMUStore"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if (button.field_146127_k == 5) {
            try {
                Desktop.getDesktop().browse(new URI("https://swdteam.com/store?q=rank"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        super.func_146284_a(button);
    }
}

