/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.event;

import com.swdteam.common.custom_events.TardisEnterExitModeEvent;
import com.swdteam.common.custom_events.TardisTranslocationEvent;
import com.swdteam.common.data.PersistantDataManager;
import com.swdteam.common.dimensions.DMDimensions;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.entity.EntityTardis;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_EnterFlightMode;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TARDISEvents {
    @SubscribeEvent
    public void TransLocation(TardisTranslocationEvent e) {
    }

    @SubscribeEvent
    public void FlightEvent(TardisEnterExitModeEvent e) {
        EntityPlayer p = e.getPlayer();
        if (e.getEnteringFlight().booleanValue()) {
            TheDalekMod.LOG.info(p.func_70005_c_().toUpperCase() + " ENTERED FLIGHT");
            p.field_71075_bZ.field_75100_b = true;
            p.field_71075_bZ.field_75099_e = false;
            p.field_71075_bZ.field_75101_c = true;
            p.field_71075_bZ.field_75102_a = true;
        }
        if (!e.getEnteringFlight().booleanValue()) {
            TheDalekMod.LOG.info(p.func_70005_c_().toUpperCase() + " HAS EXITED FLIGHT");
            PlayerUtils.TARDIS.resetPlayer(p);
        }
    }

    @SubscribeEvent
    public void LivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (entity instanceof EntityTardis) {
                EntityTardis tardis = (EntityTardis)entity;
                if (tardis.field_70173_aa > 20 && !tardis.func_184218_aH()) {
                    tardis.func_70106_y();
                }
                if (tardis.field_70170_p.field_73011_w instanceof WorldProviderTardis && tardis.func_184187_bx() != null && tardis.func_184187_bx() instanceof EntityPlayer) {
                    player = (EntityPlayer)tardis.func_184187_bx();
                    PlayerUtils.TARDIS.resetPlayer(player);
                }
            }
            if (entity instanceof EntityPlayer) {
                int TicksOnGround = 0;
                player = (EntityPlayer)entity;
                if (player.field_70170_p.field_73011_w instanceof WorldProviderTardis && player.field_71075_bZ.field_75101_c && !player.func_184812_l_()) {
                    PlayerUtils.TARDIS.resetPlayer(player);
                    TheDalekMod.LOG.debug("Reset " + player.func_70005_c_() + "'s state of mind....");
                }
                if (player.func_184207_aI() && player.func_184188_bt().get(0) instanceof EntityTardis) {
                    EntityTardis tardis = (EntityTardis)((Object)player.func_184188_bt().get(0));
                    if (player.field_70122_E) {
                        if (++TicksOnGround > 32 && player.func_70093_af()) {
                            ((Entity)player.func_184188_bt().get(0)).func_70106_y();
                            PlayerUtils.TARDIS.resetPlayer(player);
                        }
                    } else {
                        boolean bl = false;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void EntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)entity;
            if (PersistantDataManager.getBoolean((Entity)((EntityPlayer)entity), "flight_mode")) {
                EntityTardis tardis;
                boolean isInFlight;
                int tardisID = PersistantDataManager.getInt((Entity)((EntityPlayer)entity), "flight_mode_tid");
                boolean bl = isInFlight = playerIn.func_184188_bt().size() > 0 && playerIn.func_184188_bt().get(0) instanceof EntityTardis;
                if (isInFlight && playerIn.field_70170_p.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                    playerIn.func_184226_ay();
                    PlayerUtils.TARDIS.resetPlayer(playerIn);
                    return;
                }
                if (!playerIn.field_70170_p.field_72995_K && !isInFlight) {
                    tardis = new EntityTardis(playerIn.func_130014_f_());
                    tardis.func_82149_j((Entity)playerIn);
                    tardis.setTardisID(tardisID);
                    tardis.setPlayerUUID(playerIn.func_110124_au());
                    playerIn.func_130014_f_().func_72838_d((Entity)tardis);
                    tardis.func_184205_a((Entity)playerIn, true);
                    playerIn.func_184189_br();
                    playerIn.func_184102_h().func_71218_a(playerIn.field_71093_bK).func_72866_a((Entity)playerIn, true);
                }
                playerIn.field_71075_bZ.field_75100_b = true;
                playerIn.func_70095_a(false);
                if (!playerIn.field_71075_bZ.field_75101_c) {
                    playerIn.field_71075_bZ.field_75101_c = true;
                }
                playerIn.field_70160_al = false;
                playerIn.func_70637_d(false);
                playerIn.field_71075_bZ.field_75102_a = true;
                playerIn.field_70181_x += 8.0;
                playerIn.eyeHeight = 2.0f;
                playerIn.func_71016_p();
                try {
                    tardis = (EntityTardis)((Object)playerIn.func_184188_bt().get(0));
                    NBTTagCompound tag = new NBTTagCompound();
                    tardis.func_189511_e(tag);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new Packet_EnterFlightMode(tag, playerIn.func_110124_au()), new NetworkRegistry.TargetPoint(playerIn.func_130014_f_().field_73011_w.getDimension(), playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 40.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void deathEvent(LivingDeathEvent e) {
        EntityTardis t;
        EntityPlayerMP player;
        if (e.getEntity() != null && e.getEntity() instanceof EntityPlayerMP && (player = (EntityPlayerMP)e.getEntity()).func_184188_bt() != null && player.func_184188_bt().size() > 0 && player.func_184188_bt().get(0) instanceof EntityTardis) {
            e.setCanceled(true);
            player.field_70128_L = false;
            player.func_70606_j(20.0f);
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Cannot die whilst flying the Tardis");
        }
        if (e.getEntityLiving() != null && e.getEntityLiving() instanceof EntityTardis && (t = (EntityTardis)e.getEntityLiving()).func_184218_aH()) {
            e.setCanceled(true);
            t.field_70128_L = false;
            t.func_70606_j(2000.0f);
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (e.getEntityLiving().func_184188_bt() != null && e.getEntityLiving().func_184188_bt().size() > 0 && e.getEntityLiving().func_184188_bt().get(0) instanceof EntityTardis) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void hurtEvent(LivingHurtEvent e) {
        EntityPlayerMP player;
        Entity entity = e.getEntity();
        if (e.getSource().func_76346_g() instanceof EntityPlayerMP && (player = (EntityPlayerMP)e.getSource().func_76346_g()).func_184188_bt() != null && player.func_184188_bt().size() > 0 && player.func_184188_bt().get(0) instanceof EntityTardis) {
            e.setCanceled(true);
        }
    }

    public static boolean isInFlightMode(EntityPlayer player) {
        return player.func_184188_bt() != null && player.func_184188_bt().size() > 0 && player.func_184188_bt().get(0) instanceof EntityTardis;
    }

    @SubscribeEvent
    public void commandEvent(CommandEvent c) {
        EntityPlayerMP player;
        if (c.getSender() instanceof EntityPlayerMP && TARDISEvents.isInFlightMode((EntityPlayer)(player = (EntityPlayerMP)c.getSender()))) {
            c.setCanceled(true);
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "You cannot use commands whilst in flight mode.");
        }
    }

    @SubscribeEvent
    public void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent e) {
        System.out.println("In Flight: " + TARDISEvents.isInFlightMode(e.player));
        if (PersistantDataManager.getBoolean((Entity)e.player, "flight_mode")) {
            PersistantDataManager.saveBoolean((Entity)e.player, "reset_tardis_login", true);
            PersistantDataManager.saveBoolean((Entity)e.player, "flight_mode", false);
            System.out.println("RESET LOGIN");
        }
    }

    @SubscribeEvent
    public void playerConnect(PlayerEvent.PlayerLoggedInEvent e) {
        boolean b = PersistantDataManager.getBoolean((Entity)e.player, "reset_tardis_login");
        System.out.println("B: " + b);
        if (e.player instanceof EntityPlayerMP && b) {
            PlayerUtils.TARDIS.resetPlayer(e.player);
            PersistantDataManager.saveBoolean((Entity)e.player, "reset_tardis_login", false);
            double xPos = PersistantDataManager.getDouble((Entity)e.player, "TFPX");
            double yPos = PersistantDataManager.getDouble((Entity)e.player, "TFPY");
            double zPos = PersistantDataManager.getDouble((Entity)e.player, "TFPZ");
            float pitch = PersistantDataManager.getFloat((Entity)e.player, "TFP");
            float yaw = PersistantDataManager.getFloat((Entity)e.player, "TFY");
            TeleportUtils.teleportToDimension((EntityPlayerMP)e.player, DMDimensions.DIM_TARDIS_ID, xPos, yPos, zPos, yaw, pitch);
        }
    }
}

