/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mojang.authlib.GameProfile;
import com.swdteam.common.data.PersistantDataManager;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class PlayerUtils {
    public static List<EntityChicken> getChickens(EntityPlayer player) {
        return player.field_70170_p.func_72872_a(EntityChicken.class, player.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0));
    }

    public static Vec3d getLook(float pitch, float yawHead) {
        float f = MathHelper.func_76134_b((float)(-yawHead * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yawHead * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static RayTraceResult getMouseOverEntity(EntityLivingBase shooter, int distance, boolean friendly) {
        return PlayerUtils.getMouseOverEntity(shooter, distance, friendly, shooter.field_70125_A, shooter.field_70759_as);
    }

    public static RayTraceResult getMouseOverEntity(EntityLivingBase shooter, int distance, boolean friendly, float pitch, float yawHead) {
        RayTraceResult result = null;
        if (shooter != null) {
            double d0 = distance - 1;
            Vec3d vec3d = shooter.func_70040_Z();
            double d1 = d0;
            Vec3d vec3d1 = PlayerUtils.getLook(pitch, yawHead);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            List list = shooter.field_70170_p.func_175674_a((Entity)shooter, shooter.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72321_a(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

                public boolean apply(@Nullable Entity entity) {
                    return entity != null && entity.func_70067_L();
                }
            }));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)entity1.func_70111_Y(), (double)entity1.func_70111_Y(), (double)entity1.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == shooter.func_184208_bv() && !shooter.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    result = new RayTraceResult(entity1, raytraceresult.field_72307_f);
                    continue;
                }
                result = new RayTraceResult(entity1, raytraceresult.field_72307_f);
                d2 = d3;
            }
        }
        if (result != null && result.field_72308_g instanceof EntityLivingBase) {
            return result;
        }
        return null;
    }

    public static class TARDIS {
        public static void resetPlayer(EntityPlayer player) {
            PersistantDataManager.saveBoolean((Entity)player, "flight_mode", false);
            if (player.func_184812_l_()) {
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75098_d = true;
                player.field_71075_bZ.field_75102_a = true;
                player.field_71075_bZ.field_75099_e = true;
                player.func_71016_p();
                player.func_184226_ay();
            }
            if (player.func_175149_v()) {
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75098_d = false;
                player.field_71075_bZ.field_75102_a = true;
                player.field_71075_bZ.field_75100_b = true;
                player.field_71075_bZ.field_75099_e = true;
                player.func_71016_p();
                player.func_184226_ay();
            }
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75098_d = false;
                player.field_71075_bZ.field_75102_a = false;
                player.field_71075_bZ.field_75100_b = false;
                player.field_71075_bZ.field_75099_e = true;
                player.field_70160_al = false;
                player.func_71016_p();
                player.func_184226_ay();
            }
            player.eyeHeight = 1.62f;
            player.func_82142_c(false);
        }
    }

    public static class Auth {
        public static boolean isOp(String name) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152700_a(name) != null;
        }

        public static boolean isOp(EntityPlayer player) {
            String name = player.func_70005_c_();
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152700_a(name) != null;
        }

        public static boolean doUUIDsMatch(EntityPlayer player, String ... uuid) {
            String playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
            for (String s : uuid) {
                if (!playerUUID.contains(s)) continue;
                return playerUUID.contains(s);
            }
            return false;
        }

        public static String getName(UUID uuid) {
            return DMUtils.getName(uuid.toString());
        }

        public static String getPlayerUUID(EntityPlayer player) {
            return player.func_146103_bH().getId().toString();
        }

        public static String getUUID(String player) {
            String strUUID = DMUtils.getUUIDs(player);
            return strUUID;
        }
    }

    public static class Messaging {
        public static void sendMessageToPlayer(EntityPlayer p, String s) {
            TextComponentString textComponent = new TextComponentString(s);
            p.func_145747_a((ITextComponent)textComponent);
        }

        public static void sendMessageToPlayer(EntityPlayer p, EnumDefaultResponse s) {
            TextComponentTranslation textComponent = new TextComponentTranslation(s.name, new Object[0]);
            p.func_145747_a((ITextComponent)textComponent);
        }

        public static void sendStatusMessageToPlayer(EntityPlayer p, String s, boolean actionBar) {
            TextComponentString textComponent = new TextComponentString(s);
            p.func_146105_b((ITextComponent)textComponent, actionBar);
        }
    }

    public static class Movement {
        public static void setWalkSpeed(EntityPlayerMP p, float speed) {
            ReflectionHelper.setPrivateValue(PlayerCapabilities.class, (Object)p.field_71075_bZ, (Object)Float.valueOf(speed), (int)6);
        }

        public static void setFlySpeed(EntityPlayerMP p, float speed) {
            ReflectionHelper.setPrivateValue(PlayerCapabilities.class, (Object)p.field_71075_bZ, (Object)Float.valueOf(speed), (int)5);
        }
    }

    public static class Hands {
        public static boolean isInHand(EnumHand hand, EntityPlayer holder, ItemStack item) {
            if (holder.func_184586_b(hand) != null) {
                ItemStack heldItem = holder.func_184586_b(hand);
                return heldItem.func_77969_a(item);
            }
            return false;
        }

        public static boolean isInMainHand(EntityPlayer holder, Item item) {
            return Hands.isInHand(EnumHand.MAIN_HAND, holder, new ItemStack(item));
        }

        public static boolean isInOffHand(EntityPlayer holder, Item item) {
            return Hands.isInHand(EnumHand.OFF_HAND, holder, new ItemStack(item));
        }

        public static boolean isInEitherHand(EntityPlayer holder, Item item) {
            return Hands.isInMainHand(holder, item) || Hands.isInOffHand(holder, item);
        }

        public static boolean isInOneHand(EntityPlayer holder, Item item) {
            boolean mainHand = Hands.isInMainHand(holder, item) && !Hands.isInOffHand(holder, item);
            boolean offHand = Hands.isInOffHand(holder, item) && !Hands.isInMainHand(holder, item);
            return mainHand || offHand;
        }

        public static Vec3d getShootingPos(EntityLivingBase shooter, float pitch, float yaw, @Nullable EnumHand hand, float verticalAdjust, float horizontalAdjust) {
            if (hand == EnumHand.OFF_HAND) {
                horizontalAdjust *= -1.0f;
            }
            Vec3d lookVec = PlayerUtils.getLook(pitch + verticalAdjust, yaw);
            Vec3d horizontalVec = new Vec3d(-lookVec.field_72449_c, 0.0, lookVec.field_72450_a).func_72432_b().func_186678_a((double)horizontalAdjust);
            if (pitch + verticalAdjust > 90.0f) {
                horizontalVec = horizontalVec.func_186678_a(-1.0);
            }
            Vec3d posVec = new Vec3d(shooter.field_70142_S + (shooter.field_70165_t - shooter.field_70142_S) * 1.0, shooter.field_70137_T + (shooter.field_70163_u - shooter.field_70137_T) * 1.0, shooter.field_70136_U + (shooter.field_70161_v - shooter.field_70136_U) * 1.0);
            return posVec.func_178787_e(lookVec).func_178787_e(horizontalVec).func_72441_c(0.0, (double)shooter.func_70047_e(), 0.0);
        }
    }
}

