/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.FancyMissingModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public final class ModelLoader
extends cgb {
    private final Map<cgd, IModel> stateModels = Maps.newHashMap();
    private final Set<cgd> missingVariants = Sets.newHashSet();
    private final Map<nf, Exception> loadingExceptions = Maps.newHashMap();
    private IModel missingModel = null;
    private boolean isLoading = false;
    private final boolean enableVerboseMissingInfo = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false || Boolean.parseBoolean(System.getProperty("forge.verboseMissingModelLogging", "false"));
    private final int verboseMissingInfoCount = Integer.parseInt(System.getProperty("forge.verboseMissingModelLoggingCount", "5"));
    private static final Map<IRegistryDelegate<aow>, bws> customStateMappers = Maps.newHashMap();
    private static final Map<IRegistryDelegate<ain>, buw> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<IRegistryDelegate<ain>, Integer>, cgd> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(cep manager, cdp map, bvl shapes) {
        super(manager, map, shapes);
        VanillaLoader.INSTANCE.setLoader(this);
        VariantLoader.INSTANCE.setLoader(this);
        ModelLoaderRegistry.clearModelCache(manager);
    }

    @Nonnull
    public fm<cgd, cfy> a() {
        if (FMLClientHandler.instance().hasError()) {
            return this.p;
        }
        this.isLoading = true;
        this.b();
        this.c();
        this.missingModel = ModelLoaderRegistry.getMissingModel();
        this.stateModels.put(a, this.missingModel);
        HashSet textures = Sets.newHashSet(ModelLoaderRegistry.getTextures());
        textures.remove(cdp.f);
        textures.addAll(b);
        this.l.a(this.g, map -> textures.forEach(arg_0 -> ((cdp)map).a(arg_0)));
        cfy missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), cdy.b, DefaultTextureGetter.INSTANCE);
        HashMap bakedModels = Maps.newHashMap();
        HashMultimap models = HashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(this.stateModels), (Multimap)models);
        ProgressManager.ProgressBar bakeBar = ProgressManager.push("ModelLoader: baking", models.keySet().size());
        for (IModel iModel : models.keySet()) {
            bakeBar.step("[" + Joiner.on((String)", ").join((Iterable)models.get((Object)iModel)) + "]");
            if (iModel == this.getMissingModel()) {
                bakedModels.put(iModel, missingBaked);
                continue;
            }
            bakedModels.put(iModel, iModel.bake(iModel.getDefaultState(), cdy.b, DefaultTextureGetter.INSTANCE));
        }
        ProgressManager.pop(bakeBar);
        for (Map.Entry entry : this.stateModels.entrySet()) {
            this.p.a(entry.getKey(), bakedModels.get(entry.getValue()));
        }
        return this.p;
    }

    protected void e() {
    }

    protected void f() {
    }

    protected void b() {
        ArrayList blocks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)aow.h, block -> block.getRegistryName() != null));
        blocks.sort(Comparator.comparing(b2 -> b2.getRegistryName().toString()));
        ProgressManager.ProgressBar blockBar = ProgressManager.push("ModelLoader: blocks", blocks.size());
        bwp mapper = this.m.a();
        for (aow block2 : blocks) {
            blockBar.step(block2.getRegistryName().toString());
            for (nf location : mapper.a(block2)) {
                this.loadBlock(mapper, block2, location);
            }
        }
        ProgressManager.pop(blockBar);
    }

    protected void a(@Nullable bvv definition, cgd location) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel((nf)location);
        }
        catch (Exception e) {
            this.storeException((nf)location, e);
            model = ModelLoaderRegistry.getMissingModel((nf)location, e);
        }
        this.stateModels.put(location, model);
    }

    protected void registerMultipartVariant(bvv definition, Collection<cgd> locations) {
        for (cgd location : locations) {
            this.a(null, location);
        }
    }

    private void storeException(nf location, Exception exception) {
        this.loadingExceptions.put(location, exception);
    }

    protected bvv a(nf location) {
        try {
            return super.a(location);
        }
        catch (Exception exception) {
            this.storeException(location, new Exception("Could not load model definition for variant " + location, exception));
            return new bvv(new ArrayList());
        }
    }

    protected void g() {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition(ForgeModContainer.getInstance().universalBucket);
        }
        this.h();
        ArrayList items = Lists.newArrayList((Iterable)Iterables.filter((Iterable)ain.g, item -> item.getRegistryName() != null));
        Collections.sort(items, (i1, i2) -> i1.getRegistryName().toString().compareTo(i2.getRegistryName().toString()));
        ProgressManager.ProgressBar itemBar = ProgressManager.push("ModelLoader: items", items.size());
        for (ain item2 : items) {
            itemBar.step(item2.getRegistryName().toString());
            for (String s : this.a(item2)) {
                nf file = this.a(s);
                cgd memory = ModelLoader.getInventoryVariant(s);
                IModel model = ModelLoaderRegistry.getMissingModel();
                ItemLoadingException exception = null;
                try {
                    model = ModelLoaderRegistry.getModel(file);
                }
                catch (Exception normalException) {
                    FMLLog.log.debug("Item json isn't found for '{}', trying to load the variant from the blockstate json", (Object)memory);
                    try {
                        model = ModelLoaderRegistry.getModel((nf)memory);
                    }
                    catch (Exception blockstateException) {
                        exception = new ItemLoadingException("Could not load item model either from the normal location " + file + " or from the blockstate", normalException, blockstateException);
                    }
                }
                if (exception != null) {
                    this.storeException((nf)memory, exception);
                    model = ModelLoaderRegistry.getMissingModel((nf)memory, exception);
                }
                this.stateModels.put(memory, model);
            }
        }
        ProgressManager.pop(itemBar);
    }

    public static cgd getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new cgd(s);
        }
        return new cgd(s, "inventory");
    }

    protected nf d(nf model) {
        return new nf(model.b(), model.a() + ".json");
    }

    protected IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = VanillaLoader.INSTANCE.loadModel(new nf(a.b(), a.a()));
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public void onPostBakeEvent(fm<cgd, cfy> modelRegistry) {
        cfy missingModel = (cfy)modelRegistry.c((Object)a);
        HashMap modelErrors = Maps.newHashMap();
        HashSet printedBlockStateErrors = Sets.newHashSet();
        HashMultimap reverseBlockMap = null;
        HashMultimap reverseItemMap = HashMultimap.create();
        if (this.enableVerboseMissingInfo) {
            reverseBlockMap = HashMultimap.create();
            for (Map.Entry<Object, Exception> entry : this.m.a().a().entrySet()) {
                reverseBlockMap.put((Object)entry.getValue(), entry.getKey());
            }
            ForgeRegistries.ITEMS.forEach(arg_0 -> this.lambda$onPostBakeEvent$5((Multimap)reverseItemMap, arg_0));
        }
        for (Map.Entry<Object, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof cgd)) continue;
            cgd location = (cgd)entry.getKey();
            cfy model = (cfy)modelRegistry.c((Object)location);
            if (model == null || model == missingModel || model instanceof FancyMissingModel.BakedModel) {
                int errorCount;
                String domain = ((nf)entry.getKey()).b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    String errorMsg = "Exception loading model for variant " + entry.getKey();
                    if (this.enableVerboseMissingInfo) {
                        Collection items;
                        Collection blocks = reverseBlockMap.get((Object)location);
                        if (!blocks.isEmpty()) {
                            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + blocks.iterator().next() + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
                        }
                        if (!(items = reverseItemMap.get((Object)location)).isEmpty()) {
                            if (!blocks.isEmpty()) {
                                errorMsg = errorMsg + " and";
                            }
                            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
                        }
                    }
                    if (entry.getValue() instanceof ItemLoadingException) {
                        ItemLoadingException ex = (ItemLoadingException)entry.getValue();
                        FMLLog.log.error("{}, normal location exception: ", (Object)errorMsg, (Object)ex.normalException);
                        FMLLog.log.error("{}, blockstate location exception: ", (Object)errorMsg, (Object)ex.blockstateException);
                    } else {
                        FMLLog.log.error(errorMsg, (Throwable)entry.getValue());
                    }
                    nf blockstateLocation = new nf(location.b(), location.a());
                    if (this.loadingExceptions.containsKey(blockstateLocation) && !printedBlockStateErrors.contains(blockstateLocation)) {
                        FMLLog.log.error("Exception loading blockstate for the variant {}: ", (Object)location, (Object)this.loadingExceptions.get(blockstateLocation));
                        printedBlockStateErrors.add(blockstateLocation);
                    }
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)location, (Object)missingModel);
        }
        for (cgd cgd2 : this.missingVariants) {
            cfy model = (cfy)modelRegistry.c((Object)cgd2);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = cgd2.b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    FMLLog.log.fatal("Model definition for location {} not found", (Object)cgd2);
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)cgd2, (Object)missingModel);
        }
        for (Map.Entry<Object, Exception> entry : modelErrors.entrySet()) {
            if ((Integer)((Object)entry.getValue()) < this.verboseMissingInfoCount) continue;
            FMLLog.log.fatal("Suppressed additional {} model loading errors for domain {}", (Object)((Integer)((Object)entry.getValue()) - this.verboseMissingInfoCount), entry.getKey());
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(aow block, bws mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(bvl shapes) {
        for (Map.Entry<IRegistryDelegate<aow>, bws> e : customStateMappers.entrySet()) {
            shapes.a(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(ain item, int metadata, cgd model) {
        customModels.put((Pair<IRegistryDelegate<ain>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        cgb.registerItemVariants((ain)item, (nf[])new nf[]{model});
    }

    public static void setCustomMeshDefinition(ain item, buw meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(ain item) {
        ModelLoader.setCustomMeshDefinition(item, stack -> ModelDynBucket.LOCATION);
        cgb.registerItemVariants((ain)item, (nf[])new nf[]{ModelDynBucket.LOCATION});
    }

    public static void onRegisterItems(buv mesher) {
        for (Map.Entry<IRegistryDelegate<ain>, buw> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<IRegistryDelegate<ain>, buw> entry : customModels.entrySet()) {
            mesher.a((ain)((IRegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), ((Integer)((Pair)entry.getKey()).getRight()).intValue(), (cgd)entry.getValue());
        }
    }

    public static Function<nf, cdq> defaultTextureGetter() {
        return DefaultTextureGetter.INSTANCE;
    }

    private /* synthetic */ void lambda$onPostBakeEvent$5(Multimap reverseItemMap, ain item) {
        for (String s : this.a(item)) {
            cgd memory = ModelLoader.getInventoryVariant(s);
            reverseItemMap.put((Object)memory, (Object)item.getRegistryName().toString());
        }
    }

    private static class MultipartModel
    implements IModel {
        private final nf location;
        private final bwi multipart;
        private final ImmutableMap<bwk, IModel> partModels;

        public MultipartModel(nf location, bwi multipart) throws Exception {
            this.location = location;
            this.multipart = multipart;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bwk selector : multipart.a()) {
                builder.put((Object)selector, (Object)new WeightedRandomModel(location, selector.a()));
            }
            this.partModels = builder.build();
        }

        private MultipartModel(nf location, bwi multipart, ImmutableMap<bwk, IModel> partModels) {
            this.location = location;
            this.multipart = multipart;
            this.partModels = partModels;
        }

        @Override
        public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
            cge.a builder = new cge.a();
            for (bwk selector : this.multipart.a()) {
                builder.a(selector.a(this.multipart.c()), ((IModel)this.partModels.get((Object)selector)).bake(((IModel)this.partModels.get((Object)selector)).getDefaultState(), format, bakedTextureGetter));
            }
            cfy bakedModel = builder.a();
            return bakedModel;
        }

        @Override
        public IModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry partModel : this.partModels.entrySet()) {
                builder.put(partModel.getKey(), (Object)((IModel)partModel.getValue()).retexture(textures));
            }
            return new MultipartModel(this.location, this.multipart, (ImmutableMap<bwk, IModel>)builder.build());
        }
    }

    protected static enum VariantLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        public void a(cep resourceManager) {
        }

        @Override
        public boolean accepts(nf modelLocation) {
            return modelLocation instanceof cgd;
        }

        @Override
        public IModel loadModel(nf modelLocation) throws Exception {
            cgd variant = (cgd)modelLocation;
            bvv definition = this.loader.a((nf)variant);
            try {
                bwd variants = definition.c(variant.c());
                return new WeightedRandomModel((nf)variant, variants);
            }
            catch (bvv.b e) {
                if (definition.b()) {
                    return new MultipartModel(new nf(variant.b(), variant.a()), definition.c());
                }
                throw e;
            }
        }

        public String toString() {
            return "VariantLoader.INSTANCE";
        }
    }

    private static enum DefaultTextureGetter implements Function<nf, cdq>
    {
        INSTANCE;


        @Override
        public cdq apply(nf location) {
            return bib.z().R().a(location.toString());
        }
    }

    private static class ItemLoadingException
    extends ModelLoaderRegistry.LoaderException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    public static final class White
    extends cdq {
        public static final nf LOCATION = new nf("white");
        public static final White INSTANCE = new White();

        private White() {
            super(LOCATION.toString());
            this.g = 16;
            this.f = 16;
        }

        public boolean hasCustomLoader(cep manager, nf location) {
            return true;
        }

        public boolean load(cep manager, nf location, Function<nf, cdq> textureGetter) {
            BufferedImage image = new BufferedImage(this.c(), this.d(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, this.c(), this.d());
            int[][] pixels = new int[bib.z().t.K + 1][];
            pixels[0] = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
            this.l();
            this.a.add(pixels);
            return false;
        }

        public void register(cdp map) {
            map.setTextureEntry((cdq)INSTANCE);
        }
    }

    protected static enum VanillaLoader implements ICustomModelLoader
    {
        INSTANCE;

        @Nullable
        private ModelLoader loader;
        private LoadingCache<BakedModelCacheKey, cfy> modelCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(100L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<BakedModelCacheKey, cfy>(){

            public cfy load(BakedModelCacheKey key) throws Exception {
                return key.model.bakeImpl(key.state, key.format, key.bakedTextureGetter);
            }
        });

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        @Nullable
        ModelLoader getLoader() {
            return this.loader;
        }

        public void a(cep resourceManager) {
        }

        @Override
        public boolean accepts(nf modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(nf modelLocation) throws Exception {
            if (modelLocation.equals((Object)a) && this.loader.missingModel != null) {
                return this.loader.getMissingModel();
            }
            String modelPath = modelLocation.a();
            if (modelLocation.a().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            nf armatureLocation = new nf(modelLocation.b(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation(this.loader.g, armatureLocation);
            bvu model = this.loader.c(modelLocation);
            ModelLoader modelLoader = this.loader;
            ((Object)((Object)modelLoader)).getClass();
            VanillaModelWrapper iModel = modelLoader.new VanillaModelWrapper(modelLocation, model, false, animation);
            if (this.loader.missingModel == null && modelLocation.equals((Object)a)) {
                this.loader.missingModel = iModel;
            }
            return iModel;
        }

        public String toString() {
            return "VanillaLoader.INSTANCE";
        }
    }

    protected final class BakedModelCacheKey {
        private final VanillaModelWrapper model;
        private final IModelState state;
        private final cea format;
        private final Function<nf, cdq> bakedTextureGetter;

        public BakedModelCacheKey(VanillaModelWrapper model, IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
            this.model = model;
            this.state = state;
            this.format = format;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BakedModelCacheKey that = (BakedModelCacheKey)o;
            return Objects.equal((Object)this.model, (Object)that.model) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.format, (Object)that.format) && Objects.equal(this.bakedTextureGetter, that.bakedTextureGetter);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.model, this.state, this.format, this.bakedTextureGetter});
        }
    }

    private static final class WeightedRandomModel
    implements IModel {
        private final List<bwe> variants;
        private final List<nf> locations;
        private final Set<nf> textures;
        private final List<IModel> models;
        private final IModelState defaultState;

        public WeightedRandomModel(nf parent, bwd variants) throws Exception {
            this.variants = variants.a();
            this.locations = new ArrayList<nf>();
            this.textures = Sets.newHashSet();
            this.models = new ArrayList<IModel>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (bwe v : this.variants) {
                nf loc = v.a();
                this.locations.add(loc);
                IModel model = loc.equals((Object)a) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel(loc);
                model = v.process(model);
                for (nf location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing(location);
                }
                this.textures.addAll(model.getTextures());
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)new ModelStateComposition(v.getState(), model.getDefaultState())));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        private WeightedRandomModel(List<bwe> variants, List<nf> locations, Set<nf> textures, List<IModel> models, IModelState defaultState) {
            this.variants = variants;
            this.locations = locations;
            this.textures = textures;
            this.models = models;
            this.defaultState = defaultState;
        }

        @Override
        public Collection<nf> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<nf> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        @Override
        public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState(state, model, 0), format, bakedTextureGetter);
            }
            cgg.a builder = new cgg.a();
            for (int i2 = 0; i2 < this.variants.size(); ++i2) {
                IModel model = this.models.get(i2);
                builder.a(model.bake(MultiModelState.getPartState(state, model, i2), format, bakedTextureGetter), this.variants.get(i2).d());
            }
            return builder.a();
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }

        @Override
        public WeightedRandomModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            HashSet modelTextures = Sets.newHashSet();
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList retexturedModels = Lists.newArrayList();
            for (int i2 = 0; i2 < this.variants.size(); ++i2) {
                IModel retextured = this.models.get(i2).retexture(textures);
                modelTextures.addAll(retextured.getTextures());
                retexturedModels.add(retextured);
                builder.add((Object)Pair.of((Object)retextured, (Object)this.variants.get(i2).getState()));
            }
            return new WeightedRandomModel(this.variants, this.locations, modelTextures, retexturedModels, new MultiModelState(builder.build()));
        }
    }

    private final class VanillaModelWrapper
    implements IModel {
        private final nf location;
        private final bvu model;
        private final boolean uvlock;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(nf location, bvu model, boolean uvlock, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.uvlock = uvlock;
            this.animation = animation;
        }

        @Override
        public Collection<nf> getDependencies() {
            HashSet set = Sets.newHashSet();
            for (nf dep : this.model.e()) {
                if (this.location.equals((Object)dep)) continue;
                set.add(dep);
                ModelLoader.this.stateModels.put(ModelLoader.getInventoryVariant(dep.toString()), ModelLoaderRegistry.getModelOrLogError(dep, "Could not load override model " + dep + " for model " + this.location));
            }
            if (this.model.h() != null && !this.model.h().a().startsWith("builtin/")) {
                set.add(this.model.h());
            }
            return ImmutableSet.copyOf((Collection)set);
        }

        @Override
        public Collection<nf> getTextures() {
            if (this.model.h() != null) {
                if (this.model.h().a().equals("builtin/generated")) {
                    this.model.d = r;
                } else {
                    IModel parent = ModelLoaderRegistry.getModelOrLogError(this.model.h(), "Could not load vanilla model parent '" + this.model.h() + "' for '" + this.model);
                    if (parent instanceof VanillaModelWrapper) {
                        this.model.d = ((VanillaModelWrapper)parent).model;
                    } else {
                        throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s : bvy.a) {
                    String r2 = this.model.c(s);
                    nf loc = new nf(r2);
                    if (r2.equals(s)) continue;
                    builder.add((Object)loc);
                }
            }
            for (String s : this.model.c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new nf(s));
            }
            return builder.build();
        }

        @Override
        public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
            return (cfy)VanillaLoader.INSTANCE.modelCache.getUnchecked((Object)new BakedModelCacheKey(this, state, format, bakedTextureGetter));
        }

        public cfy bakeImpl(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            bvu model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i2 = 0; i2 < model.a().size(); ++i2) {
                bvq part = (bvq)model.a().get(i2);
                newTransforms.add(this.animation.getPartTransform(state, part, i2));
            }
            bwc transforms = model.j();
            HashMap tMap = Maps.newHashMap();
            tMap.putAll(PerspectiveMapWrapper.getTransforms(transforms));
            tMap.putAll(PerspectiveMapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap));
            if (ModelLoader.this.b(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.c(model)) {
                return new cga(transforms, model.g());
            }
            return this.bakeNormal(model, perState, state, newTransforms, format, bakedTextureGetter, this.uvlock);
        }

        private cfy bakeNormal(bvu model, IModelState perState, final IModelState modelState, List<TRSRTransformation> newTransforms, final cea format, final Function<nf, cdq> bakedTextureGetter, boolean uvLocked) {
            TRSRTransformation baseState = modelState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
            cdq particle = bakedTextureGetter.apply(new nf(model.c("particle")));
            cgf.a builder = new cgf.a(model, model.g()).a(particle);
            for (int i2 = 0; i2 < model.a().size(); ++i2) {
                if (modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList<String>)ImmutableList.of((Object)Integer.toString(i2))))).isPresent()) continue;
                bvq part = (bvq)model.a().get(i2);
                TRSRTransformation transformation = baseState;
                if (newTransforms.get(i2) != null) {
                    transformation = transformation.compose(newTransforms.get(i2));
                    bvs rot = part.d;
                    if (rot == null) {
                        rot = new bvs(new Vector3f(), fa.a.b, 0.0f, false);
                    }
                    part = new bvq(part.a, part.b, part.c, rot, part.e);
                }
                for (Map.Entry e : part.c.entrySet()) {
                    cdq textureatlassprite1 = bakedTextureGetter.apply(new nf(model.c(((bvr)e.getValue()).d)));
                    if (((bvr)e.getValue()).b == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.a(ModelLoader.this.makeBakedQuad(part, (bvr)e.getValue(), textureatlassprite1, (fa)e.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.a(baseState.rotate(((bvr)e.getValue()).b), ModelLoader.this.makeBakedQuad(part, (bvr)e.getValue(), textureatlassprite1, (fa)e.getKey(), transformation, uvLocked));
                }
            }
            return new PerspectiveMapWrapper(builder.b(), perState){
                private final bwa overrides;
                {
                    super(parent, state);
                    this.overrides = new AnimationItemOverrideList((IModel)VanillaModelWrapper.this, modelState, format, (Function<nf, cdq>)bakedTextureGetter, super.f());
                }

                @Override
                public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
                    IExtendedBlockState exState;
                    if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
                        IModelState newState = exState.getValue(Properties.AnimationProperty);
                        IExtendedBlockState newExState = exState.withProperty(Properties.AnimationProperty, null);
                        if (newState != null) {
                            return VanillaModelWrapper.this.bake(new ModelStateComposition(modelState, newState), format, bakedTextureGetter).a((awt)newExState, side, rand);
                        }
                    }
                    return super.a(state, side, rand);
                }

                @Override
                public bwa f() {
                    return this.overrides;
                }
            };
        }

        @Override
        public VanillaModelWrapper retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (bvq part : this.model.a()) {
                elements.add(new bvq(part.a, part.b, (Map)Maps.newHashMap((Map)part.c), part.d, part.e));
            }
            bvu newModel = new bvu(this.model.h(), (List)elements, (Map)Maps.newHashMap((Map)this.model.c), this.model.b(), this.model.c(), this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.b = this.model.b;
            newModel.d = this.model.d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add(e.getKey());
                    newModel.c.remove(e.getKey());
                    continue;
                }
                newModel.c.put(e.getKey(), e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry e : newModel.c.entrySet()) {
                String key;
                if (!((String)e.getValue()).startsWith("#") || !newModel.c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
                remapped.put(e.getKey(), newModel.c.get(key));
            }
            newModel.c.putAll(remapped);
            for (bvq part : newModel.a()) {
                part.c.entrySet().removeIf(entry -> removed.contains(((bvr)entry.getValue()).d));
            }
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.ofNullable(this.animation.getClips().get((Object)name));
            }
            return Optional.empty();
        }

        @Override
        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.i == value) {
                return this;
            }
            bvu newModel = new bvu(this.model.h(), this.model.a(), this.model.c, value, this.model.c(), this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.c() == value) {
                return this;
            }
            bvu newModel = new bvu(this.model.h(), this.model.a(), this.model.c, this.model.i, value, this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public IModel uvlock(boolean value) {
            if (this.uvlock == value) {
                return this;
            }
            return new VanillaModelWrapper(this.location, this.model, value, this.animation);
        }
    }
}

