/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.b3d.B3DClip;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public enum B3DLoader implements ICustomModelLoader
{
    INSTANCE;

    private cep manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<nf, B3DModel> cache = new HashMap<nf, B3DModel>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
    }

    public void a(cep manager) {
        this.manager = manager;
        this.cache.clear();
    }

    @Override
    public boolean accepts(nf modelLocation) {
        return this.enabledDomains.contains(modelLocation.b()) && modelLocation.a().endsWith(".b3d");
    }

    @Override
    public IModel loadModel(nf modelLocation) throws Exception {
        B3DModel model;
        nf file = new nf(modelLocation.b(), modelLocation.a());
        if (!this.cache.containsKey(file)) {
            try {
                ceo resource;
                try {
                    resource = this.manager.a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.a().startsWith("models/block/")) {
                        resource = this.manager.a(new nf(file.b(), "models/item/" + file.a().substring("models/block/".length())));
                    }
                    if (modelLocation.a().startsWith("models/item/")) {
                        resource = this.manager.a(new nf(file.b(), "models/block/" + file.a().substring("models/item/".length())));
                    }
                    throw e;
                }
                B3DModel.Parser parser = new B3DModel.Parser(resource.b());
                B3DModel model2 = parser.parse();
                this.cache.put(file, model2);
            }
            catch (IOException e) {
                this.cache.put(file, null);
                throw e;
            }
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file);
        }
        if (!(model.getRoot().getKind() instanceof B3DModel.Mesh)) {
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of(), true, true, 1);
        }
        return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)model.getRoot().getName()), true, true, 1);
    }

    private static final class BakedWrapper
    implements cfy {
        private final B3DModel.Node<?> node;
        private final IModelState state;
        private final boolean smooth;
        private final boolean gui3d;
        private final cea format;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, cdq> textures;
        private final LoadingCache<Integer, B3DState> cache;
        private ImmutableList<bvp> quads;

        public BakedWrapper(final B3DModel.Node<?> node, final IModelState state, boolean smooth, boolean gui3d, cea format, ImmutableSet<String> meshes, ImmutableMap<String, cdq> textures) {
            this(node, state, smooth, gui3d, format, meshes, textures, (LoadingCache<Integer, B3DState>)CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, B3DState>(){

                public B3DState load(Integer frame) throws Exception {
                    IModelState parent = state;
                    B3DModel.Animation newAnimation = node.getAnimation();
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    return new B3DState(newAnimation, frame, frame, 0.0f, parent);
                }
            }));
        }

        public BakedWrapper(B3DModel.Node<?> node, IModelState state, boolean smooth, boolean gui3d, cea format, ImmutableSet<String> meshes, ImmutableMap<String, cdq> textures, LoadingCache<Integer, B3DState> cache) {
            this.node = node;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.format = format;
            this.meshes = meshes;
            this.textures = textures;
            this.cache = cache;
        }

        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            ImmutableList.Builder builder;
            IExtendedBlockState exState;
            if (side != null) {
                return ImmutableList.of();
            }
            IModelState modelState = this.state;
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
                IModelState newState;
                IModelState parent = this.state;
                if (parent instanceof B3DState) {
                    B3DState ps = (B3DState)parent;
                    parent = ps.getParent();
                }
                if ((newState = exState.getValue(Properties.AnimationProperty)) != null) {
                    modelState = parent == null ? newState : new ModelStateComposition(parent, newState);
                }
            }
            if (this.quads == null) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<bvp>)builder, this.node, this.state, (ImmutableList<String>)ImmutableList.of());
                this.quads = builder.build();
            }
            if (this.state != modelState) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<bvp>)builder, this.node, modelState, (ImmutableList<String>)ImmutableList.of());
                return builder.build();
            }
            return this.quads;
        }

        private void generateQuads(ImmutableList.Builder<bvp> builder, B3DModel.Node<?> node, final IModelState state, ImmutableList<String> path) {
            ImmutableList.Builder pathBuilder = ImmutableList.builder();
            pathBuilder.addAll(path);
            pathBuilder.add((Object)node.getName());
            ImmutableList newPath = pathBuilder.build();
            for (B3DModel.Node child : node.getNodes().values()) {
                this.generateQuads(builder, child, state, (ImmutableList<String>)newPath);
            }
            if (node.getKind() instanceof B3DModel.Mesh && this.meshes.contains((Object)node.getName()) && !state.apply(Optional.of(Models.getHiddenModelPart((ImmutableList<String>)newPath))).isPresent()) {
                B3DModel.Mesh mesh = (B3DModel.Mesh)node.getKind();
                ImmutableList<B3DModel.Face> faces = mesh.bake(new Function<B3DModel.Node<?>, Matrix4f>(){
                    private final TRSRTransformation global;
                    private final LoadingCache<B3DModel.Node<?>, TRSRTransformation> localCache;
                    {
                        this.global = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
                        this.localCache = CacheBuilder.newBuilder().maximumSize(32L).build(new CacheLoader<B3DModel.Node<?>, TRSRTransformation>(){

                            public TRSRTransformation load(B3DModel.Node<?> node) throws Exception {
                                return state.apply(Optional.of(new NodeJoint(node))).orElse(TRSRTransformation.identity());
                            }
                        });
                    }

                    @Override
                    public Matrix4f apply(B3DModel.Node<?> node) {
                        return this.global.compose((TRSRTransformation)this.localCache.getUnchecked(node)).getMatrix();
                    }
                });
                for (B3DModel.Face f : faces) {
                    UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
                    quadBuilder.setContractUVs(true);
                    quadBuilder.setQuadOrientation(fa.a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
                    List<B3DModel.Texture> textures = null;
                    if (f.getBrush() != null) {
                        textures = f.getBrush().getTextures();
                    }
                    Object sprite = textures == null || textures.isEmpty() ? (cdq)this.textures.get((Object)"missingno") : (textures.get(0) == B3DModel.Texture.White ? ModelLoader.White.INSTANCE : (cdq)this.textures.get((Object)textures.get(0).getPath()));
                    quadBuilder.setTexture((cdq)sprite);
                    this.putVertexData(quadBuilder, f.getV1(), f.getNormal(), (cdq)sprite);
                    this.putVertexData(quadBuilder, f.getV2(), f.getNormal(), (cdq)sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), (cdq)sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), (cdq)sprite);
                    builder.add((Object)quadBuilder.build());
                }
            }
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, B3DModel.Vertex v, Vector3f faceNormal, cdq sprite) {
            block6: for (int e = 0; e < this.format.i(); ++e) {
                switch (this.format.c(e).b()) {
                    case a: {
                        builder.put(e, v.getPos().x, v.getPos().y, v.getPos().z, 1.0f);
                        continue block6;
                    }
                    case c: {
                        if (v.getColor() != null) {
                            builder.put(e, v.getColor().x, v.getColor().y, v.getColor().z, v.getColor().w);
                            continue block6;
                        }
                        builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                        continue block6;
                    }
                    case d: {
                        if (this.format.c(e).d() < v.getTexCoords().length) {
                            builder.put(e, sprite.a((double)(v.getTexCoords()[0].x * 16.0f)), sprite.b((double)(v.getTexCoords()[0].y * 16.0f)), 0.0f, 1.0f);
                            continue block6;
                        }
                        builder.put(e, 0.0f, 0.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                    case b: {
                        if (v.getNormal() != null) {
                            builder.put(e, v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f);
                            continue block6;
                        }
                        builder.put(e, faceNormal.x, faceNormal.y, faceNormal.z, 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean a() {
            return this.smooth;
        }

        public boolean b() {
            return this.gui3d;
        }

        public boolean c() {
            return false;
        }

        public cdq d() {
            return (cdq)this.textures.values().asList().get(0);
        }

        public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((cfy)this, this.state, cameraTransformType);
        }

        public bwa f() {
            return bwa.a;
        }
    }

    private static final class ModelWrapper
    implements IModel {
        private final nf modelLocation;
        private final B3DModel model;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, nf> textures;
        private final boolean smooth;
        private final boolean gui3d;
        private final int defaultKey;

        public ModelWrapper(nf modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, int defaultKey) {
            this(modelLocation, model, meshes, smooth, gui3d, defaultKey, ModelWrapper.buildTextures(model.getTextures()));
        }

        public ModelWrapper(nf modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, int defaultKey, ImmutableMap<String, nf> textures) {
            this.modelLocation = modelLocation;
            this.model = model;
            this.meshes = meshes;
            this.textures = textures;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.defaultKey = defaultKey;
        }

        private static ImmutableMap<String, nf> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                String location = ModelWrapper.getLocation(path);
                if (!location.startsWith("#")) {
                    location = "#" + location;
                }
                builder.put((Object)path, (Object)new nf(location));
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        @Override
        public Collection<nf> getTextures() {
            return Collections2.filter((Collection)this.textures.values(), loc -> !loc.a().startsWith("#"));
        }

        @Override
        public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            cdq missing = bakedTextureGetter.apply(new nf("missingno"));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((nf)e.getValue()).a().startsWith("#")) {
                    FMLLog.log.fatal("unresolved texture '{}' for b3d model '{}'", (Object)((nf)e.getValue()).a(), (Object)this.modelLocation);
                    builder.put(e.getKey(), (Object)missing);
                    continue;
                }
                builder.put(e.getKey(), (Object)bakedTextureGetter.apply((nf)e.getValue()));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.model.getRoot(), state, this.smooth, this.gui3d, format, this.meshes, (ImmutableMap<String, cdq>)builder.build());
        }

        @Override
        public ModelWrapper retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = ModelWrapper.getLocation(path);
                if (textures.containsKey((Object)loc)) {
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = ModelWrapper.getLocation(path);
                    }
                    builder.put(e.getKey(), (Object)new nf(newLoc));
                    continue;
                }
                builder.put(e);
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, this.gui3d, this.defaultKey, (ImmutableMap<String, nf>)builder.build());
        }

        @Override
        public ModelWrapper process(ImmutableMap<String, String> data) {
            JsonElement e;
            ImmutableSet newMeshes = this.meshes;
            int newDefaultKey = this.defaultKey;
            boolean hasChanged = false;
            if (data.containsKey((Object)"mesh")) {
                e = new JsonParser().parse((String)data.get((Object)"mesh"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)ImmutableSet.of((Object)e.getAsString()), this.smooth, this.gui3d, this.defaultKey, this.textures);
                }
                if (e.isJsonArray()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (JsonElement s : e.getAsJsonArray()) {
                        if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                            builder.add((Object)s.getAsString());
                            continue;
                        }
                        FMLLog.log.fatal("unknown mesh definition '{}' in array for b3d model '{}'", (Object)s.toString(), (Object)this.modelLocation);
                        return this;
                    }
                    newMeshes = builder.build();
                    hasChanged = true;
                } else {
                    FMLLog.log.fatal("unknown mesh definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            if (data.containsKey((Object)"key")) {
                e = new JsonParser().parse((String)data.get((Object)"key"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    newDefaultKey = e.getAsNumber().intValue();
                    hasChanged = true;
                } else {
                    FMLLog.log.fatal("unknown keyframe definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            return hasChanged ? new ModelWrapper(this.modelLocation, this.model, newMeshes, this.smooth, this.gui3d, newDefaultKey, this.textures) : this;
        }

        public Optional<IClip> getClip(String name) {
            if (name.equals("main")) {
                return Optional.of(B3DClip.INSTANCE);
            }
            return Optional.empty();
        }

        @Override
        public IModelState getDefaultState() {
            return new B3DState(this.model.getRoot().getAnimation(), this.defaultKey, this.defaultKey, 0.0f);
        }

        @Override
        public ModelWrapper smoothLighting(boolean value) {
            if (value == this.smooth) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, value, this.gui3d, this.defaultKey, this.textures);
        }

        @Override
        public ModelWrapper gui3d(boolean value) {
            if (value == this.gui3d) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, value, this.defaultKey, this.textures);
        }
    }

    static final class NodeJoint
    implements IJoint {
        private final B3DModel.Node<?> node;

        public NodeJoint(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public TRSRTransformation getInvBindPose() {
            Matrix4f m = new TRSRTransformation(this.node.getPos(), this.node.getRot(), this.node.getScale(), null).getMatrix();
            m.invert();
            TRSRTransformation pose = new TRSRTransformation(m);
            if (this.node.getParent() != null) {
                TRSRTransformation parent = new NodeJoint(this.node.getParent()).getInvBindPose();
                pose = pose.compose(parent);
            }
            return pose;
        }

        public Optional<NodeJoint> getParent() {
            if (this.node.getParent() == null) {
                return Optional.empty();
            }
            return Optional.of(new NodeJoint(this.node.getParent()));
        }

        public B3DModel.Node<?> getNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeJoint other = (NodeJoint)obj;
            return Objects.equal(this.node, other.node);
        }
    }

    public static final class B3DState
    implements IModelState {
        @Nullable
        private final B3DModel.Animation animation;
        private final int frame;
        private final int nextFrame;
        private final float progress;
        @Nullable
        private final IModelState parent;
        private static LoadingCache<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation> cache = CacheBuilder.newBuilder().maximumSize(16384L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation>(){

            public TRSRTransformation load(Triple<B3DModel.Animation, B3DModel.Node<?>, Integer> key) throws Exception {
                return B3DState.getNodeMatrix((B3DModel.Animation)key.getLeft(), (B3DModel.Node)key.getMiddle(), (Integer)key.getRight());
            }
        });

        public B3DState(@Nullable B3DModel.Animation animation, int frame) {
            this(animation, frame, frame, 0.0f);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, IModelState parent) {
            this(animation, frame, frame, 0.0f, parent);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress) {
            this(animation, frame, nextFrame, progress, null);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress, @Nullable IModelState parent) {
            this.animation = animation;
            this.frame = frame;
            this.nextFrame = nextFrame;
            this.progress = rk.a((float)progress, (float)0.0f, (float)1.0f);
            this.parent = this.getParent(parent);
        }

        @Nullable
        private IModelState getParent(@Nullable IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof B3DState) {
                return ((B3DState)parent).parent;
            }
            return parent;
        }

        @Nullable
        public B3DModel.Animation getAnimation() {
            return this.animation;
        }

        public int getFrame() {
            return this.frame;
        }

        public int getNextFrame() {
            return this.nextFrame;
        }

        public float getProgress() {
            return this.progress;
        }

        @Nullable
        public IModelState getParent() {
            return this.parent;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            TRSRTransformation nodeTransform;
            if (!part.isPresent()) {
                if (this.parent != null) {
                    return this.parent.apply(part);
                }
                return Optional.empty();
            }
            if (!(part.get() instanceof NodeJoint)) {
                return Optional.empty();
            }
            B3DModel.Node<?> node = ((NodeJoint)part.get()).getNode();
            if ((double)this.progress < 1.0E-5 || this.frame == this.nextFrame) {
                nodeTransform = this.getNodeMatrix(node, this.frame);
            } else if ((double)this.progress > 0.99999) {
                nodeTransform = this.getNodeMatrix(node, this.nextFrame);
            } else {
                nodeTransform = this.getNodeMatrix(node, this.frame);
                nodeTransform = nodeTransform.slerp(this.getNodeMatrix(node, this.nextFrame), this.progress);
            }
            if (this.parent != null && node.getParent() == null) {
                return Optional.of(this.parent.apply(part).orElse(TRSRTransformation.identity()).compose(nodeTransform));
            }
            return Optional.of(nodeTransform);
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node) {
            return this.getNodeMatrix(node, this.frame);
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node, int frame) {
            return (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)frame));
        }

        public static TRSRTransformation getNodeMatrix(@Nullable B3DModel.Animation animation, B3DModel.Node<?> node, int frame) {
            TRSRTransformation ret = TRSRTransformation.identity();
            B3DModel.Key key = null;
            if (animation != null) {
                key = (B3DModel.Key)animation.getKeys().get((Object)frame, node);
            } else if (node.getAnimation() != null) {
                key = (B3DModel.Key)node.getAnimation().getKeys().get((Object)frame, node);
            }
            if (key != null) {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(key.getPos(), key.getRot(), key.getScale(), null));
                TRSRTransformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.compose(invBind);
            } else {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(node.getPos(), node.getRot(), node.getScale(), null));
                TRSRTransformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.compose(invBind);
            }
            return ret;
        }
    }
}

