/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

public class BlockInfo {
    private static final fa[] SIDES = fa.values();
    private final bik colors;
    private amy world;
    private awt state;
    private et blockPos;
    private final boolean[][][] translucent = new boolean[3][3][3];
    private final int[][][] s = new int[3][3][3];
    private final int[][][] b = new int[3][3][3];
    private final float[][][][] skyLight = new float[3][2][2][2];
    private final float[][][][] blockLight = new float[3][2][2][2];
    private final float[][][] ao = new float[3][3][3];
    private final int[] packed = new int[7];
    private boolean full;
    private float shx = 0.0f;
    private float shy = 0.0f;
    private float shz = 0.0f;
    private int cachedTint = -1;
    private int cachedMultiplier = -1;

    public BlockInfo(bik colors) {
        this.colors = colors;
    }

    public int getColorMultiplier(int tint) {
        if (this.cachedTint == tint) {
            return this.cachedMultiplier;
        }
        this.cachedTint = tint;
        this.cachedMultiplier = this.colors.a(this.state, this.world, this.blockPos, tint);
        return this.cachedMultiplier;
    }

    public void updateShift() {
        bhe offset = this.state.f(this.world, this.blockPos);
        this.shx = (float)offset.b;
        this.shy = (float)offset.c;
        this.shz = (float)offset.d;
    }

    public void setWorld(amy world) {
        this.world = world;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setState(awt state) {
        this.state = state;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setBlockPos(et blockPos) {
        this.blockPos = blockPos;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
        this.shz = 0.0f;
        this.shy = 0.0f;
        this.shx = 0.0f;
    }

    private float combine(int c2, int s1, int s2, int s3) {
        if (c2 == 0) {
            c2 = Math.max(0, Math.max(s1, s2) - 1);
        }
        if (s1 == 0) {
            s1 = Math.max(0, c2 - 1);
        }
        if (s2 == 0) {
            s2 = Math.max(0, c2 - 1);
        }
        if (s3 == 0) {
            s3 = Math.max(0, Math.max(s1, s2) - 1);
        }
        return (float)(c2 + s1 + s2 + s3) * 32.0f / 262140.0f;
    }

    public void updateLightMatrix() {
        int z;
        int y;
        for (int x = 0; x <= 2; ++x) {
            for (y = 0; y <= 2; ++y) {
                for (z = 0; z <= 2; ++z) {
                    et pos = this.blockPos.a(x - 1, y - 1, z - 1);
                    awt state = this.world.o(pos);
                    this.translucent[x][y][z] = state.e();
                    int brightness = state.b(this.world, pos);
                    this.s[x][y][z] = brightness >> 20 & 0xF;
                    this.b[x][y][z] = brightness >> 4 & 0xF;
                    this.ao[x][y][z] = state.j();
                }
            }
        }
        fa[] x = SIDES;
        y = x.length;
        for (z = 0; z < y; ++z) {
            fa side = x[z];
            if (this.state.u().doesSideBlockRendering(this.state, this.world, this.blockPos, side)) continue;
            int x2 = side.g() + 1;
            int y2 = side.h() + 1;
            int z2 = side.i() + 1;
            this.s[x2][y2][z2] = Math.max(this.s[1][1][1] - 1, this.s[x2][y2][z2]);
            this.b[x2][y2][z2] = Math.max(this.b[1][1][1] - 1, this.b[x2][y2][z2]);
        }
        for (int x3 = 0; x3 < 2; ++x3) {
            for (y = 0; y < 2; ++y) {
                for (z = 0; z < 2; ++z) {
                    int x1 = x3 * 2;
                    int y1 = y * 2;
                    int z1 = z * 2;
                    boolean tx = this.translucent[x1][1][z1] || this.translucent[x1][y1][1];
                    this.skyLight[0][x3][y][z] = this.combine(this.s[x1][1][1], this.s[x1][1][z1], this.s[x1][y1][1], tx ? this.s[x1][y1][z1] : this.s[x1][1][1]);
                    this.blockLight[0][x3][y][z] = this.combine(this.b[x1][1][1], this.b[x1][1][z1], this.b[x1][y1][1], tx ? this.b[x1][y1][z1] : this.b[x1][1][1]);
                    boolean ty = this.translucent[x1][y1][1] || this.translucent[1][y1][z1];
                    this.skyLight[1][x3][y][z] = this.combine(this.s[1][y1][1], this.s[x1][y1][1], this.s[1][y1][z1], ty ? this.s[x1][y1][z1] : this.s[1][y1][1]);
                    this.blockLight[1][x3][y][z] = this.combine(this.b[1][y1][1], this.b[x1][y1][1], this.b[1][y1][z1], ty ? this.b[x1][y1][z1] : this.b[1][y1][1]);
                    boolean tz2 = this.translucent[1][y1][z1] || this.translucent[x1][1][z1];
                    this.skyLight[2][x3][y][z] = this.combine(this.s[1][1][z1], this.s[1][y1][z1], this.s[x1][1][z1], tz2 ? this.s[x1][y1][z1] : this.s[1][1][z1]);
                    this.blockLight[2][x3][y][z] = this.combine(this.b[1][1][z1], this.b[1][y1][z1], this.b[x1][1][z1], tz2 ? this.b[x1][y1][z1] : this.b[1][1][z1]);
                }
            }
        }
    }

    public void updateFlatLighting() {
        this.full = this.state.g();
        this.packed[0] = this.state.b(this.world, this.blockPos);
        for (fa side : SIDES) {
            int i2 = side.ordinal() + 1;
            this.packed[i2] = this.state.b(this.world, this.blockPos.a(side));
        }
    }

    public amy getWorld() {
        return this.world;
    }

    public awt getState() {
        return this.state;
    }

    public et getBlockPos() {
        return this.blockPos;
    }

    public boolean[][][] getTranslucent() {
        return this.translucent;
    }

    public float[][][][] getSkyLight() {
        return this.skyLight;
    }

    public float[][][][] getBlockLight() {
        return this.blockLight;
    }

    public float[][][] getAo() {
        return this.ao;
    }

    public int[] getPackedLight() {
        return this.packed;
    }

    public boolean isFullCube() {
        return this.full;
    }

    public float getShx() {
        return this.shx;
    }

    public float getShy() {
        return this.shy;
    }

    public float getShz() {
        return this.shz;
    }

    public int getCachedTint() {
        return this.cachedTint;
    }

    public int getCachedMultiplier() {
        return this.cachedMultiplier;
    }
}

