/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ITypeDiscoverer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;

public class JarDiscoverer
implements ITypeDiscoverer {
    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList foundMods = Lists.newArrayList();
        FMLLog.log.debug("Examining file {} for potential mods", (Object)candidate.getModContainer().getName());
        try (JarFile jar = new JarFile(candidate.getModContainer());){
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            MetadataCollection mc = null;
            if (modInfo != null) {
                FMLLog.log.trace("Located mcmod.info file in file {}", (Object)candidate.getModContainer().getName());
                Throwable throwable = null;
                try (InputStream inputStream = jar.getInputStream(modInfo);){
                    mc = MetadataCollection.from(inputStream, candidate.getModContainer().getName());
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            } else {
                FMLLog.log.debug("The mod container {} appears to be missing an mcmod.info file", (Object)candidate.getModContainer().getName());
                mc = MetadataCollection.from(null, "");
            }
            for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                ASMModParser modParser;
                Matcher match;
                if (zipEntry.getName() != null && zipEntry.getName().startsWith("__MACOSX") || !(match = classFile.matcher(zipEntry.getName())).matches()) continue;
                try {
                    try (InputStream inputStream = jar.getInputStream(zipEntry);){
                        modParser = new ASMModParser(inputStream);
                    }
                    candidate.addClassEntry(zipEntry.getName());
                }
                catch (LoaderException e) {
                    FMLLog.log.error("There was a problem reading the entry {} in the jar {} - probably a corrupt zip", (Object)candidate.getModContainer().getPath(), (Object)e);
                    jar.close();
                    throw e;
                }
                modParser.validate();
                modParser.sendToTable(table, candidate);
                ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
                if (container == null) continue;
                table.addContainer(container);
                foundMods.add(container);
                container.bindMetadata(mc);
                container.setClassVersion(modParser.getClassVersion());
            }
        }
        catch (Exception e) {
            FMLLog.log.warn("Zip file {} failed to read properly, it will be ignored", (Object)candidate.getModContainer().getName(), (Object)e);
        }
        return foundMods;
    }
}

