/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkHandshakeEstablished;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.NetworkModHolder;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public enum NetworkRegistry {
    INSTANCE;

    private EnumMap<Side, Map<String, FMLEmbeddedChannel>> channels = Maps.newEnumMap(Side.class);
    private Map<ModContainer, NetworkModHolder> registry = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();
    public static final AttributeKey<String> FML_CHANNEL;
    public static final AttributeKey<Side> CHANNEL_SOURCE;
    public static final AttributeKey<ModContainer> MOD_CONTAINER;
    public static final AttributeKey<hb> NET_HANDLER;
    public static final AttributeKey<Boolean> FML_MARKER;
    public static final byte FML_PROTOCOL = 2;

    private NetworkRegistry() {
        this.channels.put(Side.CLIENT, Maps.newConcurrentMap());
        this.channels.put(Side.SERVER, Maps.newConcurrentMap());
    }

    public EnumMap<Side, FMLEmbeddedChannel> newChannel(String name, ChannelHandler ... handlers) {
        if (this.channels.get((Object)Side.CLIENT).containsKey(name) || this.channels.get((Object)Side.SERVER).containsKey(name) || name.startsWith("MC|") || name.startsWith("\u0001") || name.startsWith("FML")) {
            throw new RuntimeException("That channel is already registered");
        }
        EnumMap result = Maps.newEnumMap(Side.class);
        for (Side side : Side.values()) {
            FMLEmbeddedChannel channel = new FMLEmbeddedChannel(name, side, handlers);
            this.channels.get((Object)side).put(name, channel);
            result.put(side, channel);
        }
        return result;
    }

    public SimpleNetworkWrapper newSimpleChannel(String name) {
        return new SimpleNetworkWrapper(name);
    }

    public FMLEventChannel newEventDrivenChannel(String name) {
        return new FMLEventChannel(name);
    }

    public EnumMap<Side, FMLEmbeddedChannel> newChannel(ModContainer container, String name, ChannelHandler ... handlers) {
        if (this.channels.get((Object)Side.CLIENT).containsKey(name) || this.channels.get((Object)Side.SERVER).containsKey(name) || name.startsWith("MC|") || name.startsWith("\u0001") || name.startsWith("FML") && !"FML".equals(container.getModId())) {
            throw new RuntimeException("That channel is already registered");
        }
        EnumMap result = Maps.newEnumMap(Side.class);
        for (Side side : Side.values()) {
            FMLEmbeddedChannel channel = new FMLEmbeddedChannel(container, name, side, handlers);
            this.channels.get((Object)side).put(name, channel);
            result.put(side, channel);
        }
        return result;
    }

    public FMLEmbeddedChannel getChannel(String name, Side source) {
        return this.channels.get((Object)source).get(name);
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            FMLLog.log.error("Mod of type {} attempted to register a gui network handler during a construction phase", (Object)mod.getClass().getName());
            throw new RuntimeException("Invalid attempt to create a GUI during mod construction. Use an EventHandler instead");
        }
        this.serverGuiHandlers.put(mc, handler);
        this.clientGuiHandlers.put(mc, handler);
    }

    @Nullable
    public afr getRemoteGuiContainer(ModContainer mc, oq player, int modGuiId, amu world, int x, int y, int z) {
        IGuiHandler handler = this.serverGuiHandlers.get(mc);
        if (handler != null) {
            return (afr)handler.getServerGuiElement(modGuiId, (aed)player, world, x, y, z);
        }
        return null;
    }

    @Nullable
    public Object getLocalGuiContainer(ModContainer mc, aed player, int modGuiId, amu world, int x, int y, int z) {
        IGuiHandler handler = this.clientGuiHandlers.get(mc);
        return handler.getClientGuiElement(modGuiId, player, world, x, y, z);
    }

    public boolean hasChannel(String channelName, Side source) {
        return this.channels.get((Object)source).containsKey(channelName);
    }

    public void register(ModContainer fmlModContainer, Class<?> clazz, @Nullable String remoteVersionRange, ASMDataTable asmHarvestedData) {
        NetworkModHolder networkModHolder = new NetworkModHolder(fmlModContainer, clazz, remoteVersionRange, asmHarvestedData);
        this.registry.put(fmlModContainer, networkModHolder);
        networkModHolder.testVanillaAcceptance();
    }

    public boolean isVanillaAccepted(Side from) {
        boolean result = true;
        for (Map.Entry<ModContainer, NetworkModHolder> e : this.registry.entrySet()) {
            result &= e.getValue().acceptsVanilla(from);
        }
        return result;
    }

    public Map<ModContainer, NetworkModHolder> registry() {
        return ImmutableMap.copyOf(this.registry);
    }

    public Set<String> channelNamesFor(Side side) {
        return this.channels.get((Object)side).keySet();
    }

    public void fireNetworkHandshake(NetworkDispatcher networkDispatcher, Side origin) {
        NetworkHandshakeEstablished handshake = new NetworkHandshakeEstablished(networkDispatcher, networkDispatcher.getNetHandler(), origin);
        for (Map.Entry<String, FMLEmbeddedChannel> channel : this.channels.get((Object)origin).entrySet()) {
            channel.getValue().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
            channel.getValue().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)networkDispatcher);
            channel.getValue().pipeline().fireUserEventTriggered((Object)handshake);
        }
    }

    static {
        FML_CHANNEL = AttributeKey.valueOf((String)"fml:channelName");
        CHANNEL_SOURCE = AttributeKey.valueOf((String)"fml:channelSource");
        MOD_CONTAINER = AttributeKey.valueOf((String)"fml:modContainer");
        NET_HANDLER = AttributeKey.valueOf((String)"fml:netHandler");
        FML_MARKER = AttributeKey.valueOf((String)"fml:hasMarker");
    }

    public static class TargetPoint {
        public final double x;
        public final double y;
        public final double z;
        public final double range;
        public final int dimension;

        public TargetPoint(int dimension, double x, double y, double z, double range) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.range = range;
            this.dimension = dimension;
        }
    }
}

