/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.NamespacedDefaultedWrapper;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;

public class GameData {
    public static final nf BLOCKS = new nf("minecraft:blocks");
    public static final nf ITEMS = new nf("minecraft:items");
    public static final nf POTIONS = new nf("minecraft:potions");
    public static final nf BIOMES = new nf("minecraft:biomes");
    public static final nf SOUNDEVENTS = new nf("minecraft:soundevents");
    public static final nf POTIONTYPES = new nf("minecraft:potiontypes");
    public static final nf ENCHANTMENTS = new nf("minecraft:enchantments");
    public static final nf ENTITIES = new nf("minecraft:entities");
    public static final nf RECIPES = new nf("minecraft:recipes");
    public static final nf PROFESSIONS = new nf("minecraft:villagerprofessions");
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MAX_POTION_ID = 255;
    private static final int MAX_BIOME_ID = 255;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final int MAX_ENTITY_ID = 0x3FFFFFF;
    private static final int MAX_RECIPE_ID = 0x3FFFFFF;
    private static final int MAX_PROFESSION_ID = 1024;
    private static final nf BLOCK_TO_ITEM = new nf("minecraft:blocktoitemmap");
    private static final nf BLOCKSTATE_TO_ID = new nf("minecraft:blockstatetoid");
    private static boolean hasInit = false;
    private static final boolean DISABLE_VANILLA_REGISTRIES = Boolean.parseBoolean(System.getProperty("forge.disableVanillaGameData", "false"));
    private static final BiConsumer<nf, ForgeRegistry<?>> LOCK_VANILLA = (name, reg) -> reg.slaves.values().stream().filter(o -> o instanceof ILockableRegistry).forEach(o -> ((ILockableRegistry)o).lock());
    private static ForgeRegistry<EntityEntry> entityRegistry;
    private static Field regName;

    public static void init() {
        if (DISABLE_VANILLA_REGISTRIES) {
            FMLLog.bigWarning("DISABLING VANILLA REGISTRY CREATION AS PER SYSTEM VARIABLE SETTING! forge.disableVanillaGameData", new Object[0]);
            return;
        }
        if (hasInit) {
            return;
        }
        hasInit = true;
        GameData.makeRegistry(BLOCKS, aow.class, 4095, new nf("air")).addCallback(BlockCallbacks.INSTANCE).create();
        GameData.makeRegistry(ITEMS, ain.class, 4096, 31999).addCallback(ItemCallbacks.INSTANCE).create();
        GameData.makeRegistry(POTIONS, uz.class, 255).create();
        GameData.makeRegistry(BIOMES, anh.class, 255).create();
        GameData.makeRegistry(SOUNDEVENTS, qe.class, 0x3FFFFFF).create();
        GameData.makeRegistry(POTIONTYPES, akg.class, 0x3FFFFFF, new nf("empty")).create();
        GameData.makeRegistry(ENCHANTMENTS, alk.class, 32766).create();
        GameData.makeRegistry(RECIPES, akt.class, 0x3FFFFFF).disableSaving().allowModification().addCallback(RecipeCallbacks.INSTANCE).create();
        GameData.makeRegistry(PROFESSIONS, VillagerRegistry.VillagerProfession.class, 1024).create();
        entityRegistry = (ForgeRegistry)GameData.makeRegistry(ENTITIES, EntityEntry.class, 0x3FFFFFF).addCallback(EntityCallbacks.INSTANCE).create();
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(nf name, Class<T> type, int min, int max) {
        return new RegistryBuilder().setName(name).setType(type).setIDRange(min, max).addCallback(new NamespacedWrapper.Factory());
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(nf name, Class<T> type, int max) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(max).addCallback(new NamespacedWrapper.Factory());
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(nf name, Class<T> type, int max, nf _default) {
        return new RegistryBuilder().setName(name).setType(type).setMaxID(max).addCallback(new NamespacedDefaultedWrapper.Factory()).setDefaultKey(_default);
    }

    public static <V extends IForgeRegistryEntry<V>> ey<nf, V> getWrapperDefaulted(Class<V> cls) {
        IForgeRegistry<V> reg = GameRegistry.findRegistry(cls);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + cls.toString()), (Object[])new Object[0]);
        ey ret = reg.getSlaveMap(NamespacedDefaultedWrapper.Factory.ID, NamespacedDefaultedWrapper.class);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + cls.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static <V extends IForgeRegistryEntry<V>> fh<nf, V> getWrapper(Class<V> cls) {
        IForgeRegistry<V> reg = GameRegistry.findRegistry(cls);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for unknown registry: " + cls.toString()), (Object[])new Object[0]);
        fh ret = reg.getSlaveMap(NamespacedWrapper.Factory.ID, NamespacedWrapper.class);
        Validate.notNull(reg, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + cls.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static BiMap<aow, ain> getBlockItemMap() {
        return GameRegistry.findRegistry(ain.class).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    public static fd<awt> getBlockStateIDMap() {
        return GameRegistry.findRegistry(aow.class).getSlaveMap(BLOCKSTATE_TO_ID, fd.class);
    }

    public static <K extends IForgeRegistryEntry<K>> K register_impl(K value) {
        Validate.notNull(value, (String)"Attempted to register a null object", (Object[])new Object[0]);
        Validate.notNull((Object)value.getRegistryName(), (String)String.format("Attempt to register object without having set a registry name %s (type %s)", value, value.getClass().getName()), (Object[])new Object[0]);
        IForgeRegistry<K> registry = GameRegistry.findRegistry(value.getRegistryType());
        Validate.notNull(registry, (String)("Attempted to registry object without creating registry first: " + value.getRegistryType().getName()), (Object[])new Object[0]);
        registry.register(value);
        return value;
    }

    public static void vanillaSnapshot() {
        FMLLog.log.debug("Creating vanilla freeze snapshot");
        for (Map.Entry r2 : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((nf)r2.getKey());
            GameData.loadRegistry((nf)r2.getKey(), RegistryManager.ACTIVE, RegistryManager.VANILLA, clazz, true);
        }
        RegistryManager.VANILLA.registries.forEach((name, reg) -> {
            reg.validateContent((nf)name);
            reg.freeze();
        });
        RegistryManager.VANILLA.registries.forEach(LOCK_VANILLA);
        RegistryManager.ACTIVE.registries.forEach(LOCK_VANILLA);
        FMLLog.log.debug("Vanilla freeze snapshot created");
    }

    public static void freezeData() {
        FMLLog.log.debug("Freezing registries");
        for (Map.Entry r2 : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((nf)r2.getKey());
            GameData.loadRegistry((nf)r2.getKey(), RegistryManager.ACTIVE, RegistryManager.FROZEN, clazz, true);
        }
        RegistryManager.FROZEN.registries.forEach((name, reg) -> {
            reg.validateContent((nf)name);
            reg.freeze();
        });
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.freeze());
        Loader.instance().fireRemapEvent((Map<nf, Map<nf, Integer[]>>)ImmutableMap.of(), true);
        FMLLog.log.debug("All registries frozen");
    }

    public static void revertToFrozen() {
        if (RegistryManager.FROZEN.registries.isEmpty()) {
            FMLLog.log.warn("Can't revert to frozen GameData state without freezing first.");
            return;
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        FMLLog.log.debug("Reverting to frozen data state.");
        for (Map.Entry r2 : RegistryManager.ACTIVE.registries.entrySet()) {
            Class clazz = RegistryManager.ACTIVE.getSuperType((nf)r2.getKey());
            GameData.loadRegistry((nf)r2.getKey(), RegistryManager.FROZEN, RegistryManager.ACTIVE, clazz, true);
        }
        Loader.instance().fireRemapEvent((Map<nf, Map<nf, Integer[]>>)ImmutableMap.of(), true);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        FMLLog.log.debug("Frozen state restored.");
    }

    public static void revert(RegistryManager state, nf registry, boolean lock) {
        FMLLog.log.debug("Reverting {} to {}", (Object)registry, (Object)state.getName());
        Class clazz = RegistryManager.ACTIVE.getSuperType(registry);
        GameData.loadRegistry(registry, state, RegistryManager.ACTIVE, clazz, lock);
        FMLLog.log.debug("Reverting complete");
    }

    public static ForgeRegistry<EntityEntry> getEntityRegistry() {
        return entityRegistry;
    }

    public static void registerEntity(int id, nf key, Class<? extends vg> clazz, String oldName) {
        fh<nf, EntityEntry> reg = GameData.getWrapper(EntityEntry.class);
        reg.a(id, (Object)key, (Object)new EntityEntry(clazz, oldName));
    }

    private static <T extends IForgeRegistryEntry<T>> void loadRegistry(final nf registryName, final RegistryManager from, final RegistryManager to, Class<T> regType, boolean freeze) {
        ForgeRegistry fromRegistry = from.getRegistry(registryName);
        if (fromRegistry == null) {
            ForgeRegistry toRegistry = to.getRegistry(registryName);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + registryName){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + registryName);
                        stream.println("Found From:");
                        for (nf name : from.registries.keySet()) {
                            stream.println("  " + name);
                        }
                        stream.println("Found To:");
                        for (nf name : to.registries.keySet()) {
                            stream.println("  " + name);
                        }
                    }
                };
            }
        } else {
            ForgeRegistry toRegistry = to.getRegistry(registryName, from);
            toRegistry.sync(registryName, fromRegistry);
            if (freeze) {
                toRegistry.isFrozen = true;
            }
        }
    }

    public static Multimap<nf, nf> injectSnapshot(Map<nf, ForgeRegistry.Snapshot> snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        FMLLog.log.info("Injecting existing registry data into this {} instance", (Object)(FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client"));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.validateContent((nf)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((nf)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        List missingRegs = snapshot.keySet().stream().filter(name -> !RegistryManager.ACTIVE.registries.containsKey(name)).collect(Collectors.toList());
        if (missingRegs.size() > 0) {
            String text = "Forge Mod Loader detected missing/unknown registrie(s).\n\nThere are " + missingRegs.size() + " missing registries in this save.\nIf you continue the missing registries will get removed.\nThis may cause issues, it is advised that you create a world backup before continuing.\n\nMissing Registries:\n";
            for (nf s : missingRegs) {
                text = text + s.toString() + "\n";
            }
            if (!StartupQuery.confirm(text)) {
                StartupQuery.abort();
            }
        }
        RegistryManager STAGING = new RegistryManager("STAGING");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        snapshot.forEach((key, value) -> {
            Class clazz = RegistryManager.ACTIVE.getSuperType((nf)key);
            remaps.put(key, Maps.newLinkedHashMap());
            missing.put(key, Maps.newHashMap());
            GameData.loadPersistentDataToStagingRegistry(RegistryManager.ACTIVE, STAGING, (Map)remaps.get(key), (Map)missing.get(key), key, value, clazz);
        });
        snapshot.forEach((key, value) -> value.dummied.forEach(dummy -> {
            Map m = (Map)missing.get(key);
            ForgeRegistry reg = STAGING.getRegistry((nf)key);
            if (m.containsKey(dummy)) {
                if (reg.markDummy((nf)dummy, (Integer)m.get(dummy))) {
                    m.remove(dummy);
                }
            } else if (isLocalWorld) {
                if (ForgeRegistry.DEBUG) {
                    FMLLog.log.debug("Registry {}: Resuscitating dummy entry {}", key, dummy);
                }
            } else {
                int id = reg.getID((nf)dummy);
                FMLLog.log.warn("Registry {}: The ID {} @ {} is currently locally mapped - it will be replaced with a dummy for this session", dummy, key, (Object)id);
                reg.markDummy((nf)dummy, id);
            }
        }));
        int count = missing.values().stream().mapToInt(Map::size).sum();
        if (count > 0) {
            FMLLog.log.debug("There are {} mappings missing - attempting a mod remap", (Object)count);
            ArrayListMultimap defaulted = ArrayListMultimap.create();
            ArrayListMultimap failed = ArrayListMultimap.create();
            missing.entrySet().stream().filter(e2 -> ((Map)e2.getValue()).size() > 0).forEach(arg_0 -> GameData.lambda$injectSnapshot$20(STAGING, (Multimap)failed, remaps, (Multimap)defaulted, isLocalWorld, arg_0));
            if (!defaulted.isEmpty() && !isLocalWorld) {
                return defaulted;
            }
            if (!defaulted.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Forge Mod Loader detected missing registry entries.\n\n").append("There are ").append(defaulted.size()).append(" missing entries in this save.\n").append("If you continue the missing entries will get removed.\n").append("A world backup will be automatically created in your saves directory.\n\n");
                defaulted.asMap().forEach((name, entries) -> {
                    buf.append("Missing ").append(name).append(":\n");
                    entries.forEach(rl2 -> buf.append("    ").append(rl2).append("\n"));
                });
                boolean confirmed = StartupQuery.confirm(buf.toString());
                if (!confirmed) {
                    StartupQuery.abort();
                }
                try {
                    String skip = System.getProperty("fml.doNotBackup");
                    if (skip == null || !"true".equals(skip)) {
                        ZipperUtil.backupWorld();
                    } else {
                        for (int x = 0; x < 10; ++x) {
                            FMLLog.log.error("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!");
                        }
                    }
                }
                catch (IOException e3) {
                    StartupQuery.notify("The world backup couldn't be created.\n\n" + e3);
                    StartupQuery.abort();
                }
            }
            if (!defaulted.isEmpty() && isLocalWorld) {
                FMLLog.log.error("There are unidentified mappings in this world - we are going to attempt to process anyway");
            }
        }
        if (injectFrozenData) {
            missing.forEach((name, m) -> {
                ForgeRegistry reg = STAGING.getRegistry((nf)name);
                m.forEach((rl2, id) -> reg.markDummy((nf)rl2, (int)id));
            });
            RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
                Class clazz = RegistryManager.ACTIVE.getSuperType((nf)name);
                GameData.loadFrozenDataToStagingRegistry(STAGING, name, (Map)remaps.get(name), clazz);
            });
        }
        STAGING.registries.forEach((name, reg) -> reg.validateContent((nf)name));
        for (Map.Entry r2 : RegistryManager.ACTIVE.registries.entrySet()) {
            Class registrySuperType = RegistryManager.ACTIVE.getSuperType((nf)r2.getKey());
            GameData.loadRegistry((nf)r2.getKey(), STAGING, RegistryManager.ACTIVE, registrySuperType, true);
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((nf)name));
        Loader.instance().fireRemapEvent(remaps, false);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        return ArrayListMultimap.create();
    }

    private static <T extends IForgeRegistryEntry<T>> void loadPersistentDataToStagingRegistry(RegistryManager pool, RegistryManager to, Map<nf, Integer[]> remaps, Map<nf, Integer> missing, nf name, ForgeRegistry.Snapshot snap, Class<T> regType) {
        ForgeRegistry active = pool.getRegistry(name);
        if (active == null) {
            return;
        }
        ForgeRegistry _new = to.getRegistry(name, RegistryManager.ACTIVE);
        snap.aliases.forEach(_new::addAlias);
        snap.blocked.forEach(_new::block);
        snap.dummied.forEach(_new::addDummy);
        _new.loadIds(snap.ids, snap.overrides, missing, remaps, active, name);
    }

    private static <T extends IForgeRegistryEntry<T>> void processMissing(Class<T> clazz, nf name, RegistryManager STAGING, RegistryEvent.MissingMappings<?> e2, Map<nf, Integer> missing, Map<nf, Integer[]> remaps, Collection<nf> defaulted, Collection<nf> failed, boolean injectNetworkDummies) {
        ImmutableList<RegistryEvent.MissingMappings.Mapping<?>> mappings = e2.getAllMappings();
        ForgeRegistry active = RegistryManager.ACTIVE.getRegistry(name);
        ForgeRegistry staging = STAGING.getRegistry(name);
        staging.processMissingEvent(name, active, mappings, missing, remaps, defaulted, failed, injectNetworkDummies);
    }

    private static <T extends IForgeRegistryEntry<T>> void loadFrozenDataToStagingRegistry(RegistryManager STAGING, nf name, Map<nf, Integer[]> remaps, Class<T> clazz) {
        ForgeRegistry frozen = RegistryManager.FROZEN.getRegistry(name);
        ForgeRegistry newRegistry = STAGING.getRegistry(name, RegistryManager.FROZEN);
        HashMap _new = Maps.newHashMap();
        frozen.getKeys().stream().filter(key -> !newRegistry.containsKey((nf)key)).forEach(key -> _new.put(key, frozen.getID((nf)key)));
        newRegistry.loadIds(_new, frozen.getOverrideOwners(), Maps.newLinkedHashMap(), remaps, frozen, name);
    }

    public static void fireCreateRegistryEvents() {
        MinecraftForge.EVENT_BUS.post(new RegistryEvent.NewRegistry());
    }

    public static void fireRegistryEvents() {
        GameData.fireRegistryEvents(rl2 -> true);
    }

    public static void fireRegistryEvents(Predicate<nf> filter) {
        ArrayList keys = Lists.newArrayList((Iterable)RegistryManager.ACTIVE.registries.keySet());
        Collections.sort(keys, (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
        if (filter.test(BLOCKS)) {
            MinecraftForge.EVENT_BUS.post(RegistryManager.ACTIVE.getRegistry(BLOCKS).getRegisterEvent(BLOCKS));
            ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        }
        if (filter.test(ITEMS)) {
            MinecraftForge.EVENT_BUS.post(RegistryManager.ACTIVE.getRegistry(ITEMS).getRegisterEvent(ITEMS));
            ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        }
        for (nf rl2 : keys) {
            if (!filter.test(rl2) || rl2 == BLOCKS || rl2 == ITEMS) continue;
            MinecraftForge.EVENT_BUS.post(RegistryManager.ACTIVE.getRegistry(rl2).getRegisterEvent(rl2));
        }
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    private static void forceRegistryName(IForgeRegistryEntry<?> entry, nf name) {
        if (regName == null) {
            try {
                regName = IForgeRegistryEntry.Impl.class.getDeclaredField("registryName");
                regName.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e2) {
                FMLLog.log.error("Could not get `registryName` field from IForgeRegistryEntry.Impl");
                FMLLog.log.throwing(Level.ERROR, (Throwable)e2);
                throw new RuntimeException(e2);
            }
        }
        try {
            regName.set(entry, name);
        }
        catch (IllegalAccessException | IllegalArgumentException e3) {
            FMLLog.log.error("Could not set `registryName` field in IForgeRegistryEntry.Impl to `{}`", (Object)name.toString());
            FMLLog.log.throwing(Level.ERROR, (Throwable)e3);
            throw new RuntimeException(e3);
        }
    }

    private static /* synthetic */ void lambda$injectSnapshot$20(RegistryManager STAGING, Multimap failed, Map remaps, Multimap defaulted, boolean isLocalWorld, Map.Entry m) {
        nf name = (nf)m.getKey();
        ForgeRegistry reg = STAGING.getRegistry(name);
        RegistryEvent.MissingMappings<?> event = reg.getMissingEvent(name, (Map)m.getValue());
        MinecraftForge.EVENT_BUS.post(event);
        List<RegistryEvent.MissingMappings.Mapping> lst = event.getAllMappings().stream().filter(e2 -> e2.getAction() == RegistryEvent.MissingMappings.Action.DEFAULT).sorted((a2, b2) -> a2.toString().compareTo(b2.toString())).collect(Collectors.toList());
        if (!lst.isEmpty()) {
            FMLLog.log.error("Unidentified mapping from registry {}", (Object)name);
            lst.forEach(map -> FMLLog.log.error("    {}: {}", (Object)map.key, (Object)map.id));
        }
        event.getAllMappings().stream().filter(e2 -> e2.getAction() == RegistryEvent.MissingMappings.Action.FAIL).forEach(fail -> failed.put((Object)name, (Object)fail.key));
        Class clazz = RegistryManager.ACTIVE.getSuperType(name);
        GameData.processMissing(clazz, name, STAGING, event, (Map)m.getValue(), (Map)remaps.get(name), defaulted.get((Object)name), failed.get((Object)name), !isLocalWorld);
    }

    static {
        GameData.init();
    }

    private static class EntityCallbacks
    implements IForgeRegistry.AddCallback<EntityEntry> {
        static final EntityCallbacks INSTANCE = new EntityCallbacks();

        private EntityCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<EntityEntry> owner, RegistryManager stage, int id, EntityEntry entry, @Nullable EntityEntry oldEntry) {
            if (entry instanceof EntityEntryBuilder.BuiltEntityEntry) {
                ((EntityEntryBuilder.BuiltEntityEntry)entry).addedToRegistry();
            }
            if (entry.getEgg() != null) {
                vi.c.put(entry.getRegistryName(), entry.getEgg());
            }
        }
    }

    private static class RecipeCallbacks
    implements IForgeRegistry.MissingFactory<akt> {
        static final RecipeCallbacks INSTANCE = new RecipeCallbacks();

        private RecipeCallbacks() {
        }

        @Override
        public akt createMissing(nf key, boolean isNetwork) {
            return isNetwork ? new DummyRecipe().setRegistryName(key) : null;
        }

        private static class DummyRecipe
        implements akt {
            private static aip result = new aip(air.l, 64);
            private nf name;

            private DummyRecipe() {
            }

            public akt setRegistryName(nf name) {
                this.name = name;
                return this;
            }

            public nf getRegistryName() {
                return this.name;
            }

            public Class<akt> getRegistryType() {
                return akt.class;
            }

            public boolean a(afy inv, amu worldIn) {
                return false;
            }

            public aip a(afy inv) {
                return result;
            }

            public boolean a(int width, int height) {
                return false;
            }

            public aip b() {
                return result;
            }

            public boolean c() {
                return true;
            }
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<ain>,
    IForgeRegistry.ClearCallback<ain>,
    IForgeRegistry.CreateCallback<ain> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<ain> owner, RegistryManager stage, int id, ain item, @Nullable ain oldItem) {
            if (item instanceof ahb) {
                BiMap blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
                blockToItem.forcePut((Object)((ahb)item).d(), (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<ain> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<ain> owner, RegistryManager stage) {
            BiMap map = stage.getRegistry(BLOCKS).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
            owner.setSlaveMap(BLOCK_TO_ITEM, map);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<aow>,
    IForgeRegistry.ClearCallback<aow>,
    IForgeRegistry.CreateCallback<aow>,
    IForgeRegistry.DummyFactory<aow> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<aow> owner, RegistryManager stage, int id, aow block, @Nullable aow oldBlock) {
            BiMap blockToItem;
            ain item;
            ClearableObjectIntIdentityMap blockstateMap = owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class);
            if ("minecraft:tripwire".equals(block.getRegistryName().toString())) {
                for (int meta = 0; meta < 15; ++meta) {
                    blockstateMap.a(block.a(meta), id << 4 | meta);
                }
            }
            boolean[] usedMeta = new boolean[16];
            for (awt state : block.s().a()) {
                int meta = block.e(state);
                blockstateMap.a(state, id << 4 | meta);
                usedMeta[meta] = true;
            }
            for (int meta = 0; meta < 16; ++meta) {
                if (block.getClass() == asl.class || !usedMeta[meta]) continue;
                blockstateMap.a(block.a(meta), id << 4 | meta);
            }
            if (oldBlock != null && (item = (ain)(blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, BiMap.class)).get((Object)oldBlock)) != null) {
                blockToItem.forcePut((Object)block, (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<aow> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<aow> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap<awt> idMap = new ClearableObjectIntIdentityMap<awt>(){

                public int get(awt key) {
                    Integer integer = (Integer)this.a.get(key);
                    if (integer == null && key != null) {
                        integer = (Integer)this.a.get(key.u().a(key.u().e(key)));
                    }
                    return integer == null ? -1 : integer;
                }
            };
            owner.setSlaveMap(BLOCKSTATE_TO_ID, idMap);
            owner.setSlaveMap(BLOCK_TO_ITEM, HashBiMap.create());
        }

        @Override
        public aow createDummy(nf key) {
            aow ret = new BlockDummyAir().c("air");
            GameData.forceRegistryName((IForgeRegistryEntry)ret, key);
            return ret;
        }

        private static class BlockDummyAir
        extends aom {
            private BlockDummyAir() {
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends fd<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

