/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.api.main.Utils;
import com.swdteam.client.data.PlayerSessionData;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.IOUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DMSession {
    private static String appID = "DM-U47";
    private static long startTime;
    public static boolean isBusy;
    private static int rawScore;
    private static HashMap<String, PlayerSessionData> sessionData;

    public static void addToScore(int points) {
        rawScore += points;
    }

    public static void init() {
        new Thread(() -> {
            try {
                isBusy = true;
                String[] data = new String[]{"uuid", Minecraft.func_71410_x().func_110432_I().func_148255_b(), "username", Minecraft.func_71410_x().func_110432_I().func_111285_a(), "dmversion", "(Update 48.7)", "jre", System.getProperty("java.version"), "os", System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version")};
                String response = Utils.getHTTPResponse("http://api.swdteam.co.uk/files/SWDEss/dmscripts/AuthEvent.php", data);
                TheDalekMod.LOG.info(response);
                isBusy = false;
            }
            catch (Exception e) {
                TheDalekMod.LOG.catching((Throwable)e);
            }
        }).start();
    }

    public static void startSession() {
    }

    public static void endSession() {
    }

    public static PlayerSessionData getPlayerData(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        String id = uuid.toString().replace("-", "");
        if (sessionData.containsKey(id)) {
            return sessionData.get(id);
        }
        isBusy = true;
        String json = IOUtils.getJsonFromURL("http://api.swdteam.co.uk/files/SWDEss/webpage/userData.php?uuid=" + id);
        if (json.startsWith("[")) {
            PlayerSessionData[] data = (PlayerSessionData[])TheDalekMod.GSON.fromJson(json, PlayerSessionData[].class);
            if (data.length > 0) {
                sessionData.put(id, data[0]);
                isBusy = false;
                return sessionData.get(id);
            }
            isBusy = false;
            return null;
        }
        PlayerSessionData data = (PlayerSessionData)TheDalekMod.GSON.fromJson(json, PlayerSessionData.class);
        if (data == null) {
            return null;
        }
        sessionData.put(id, data);
        isBusy = false;
        return sessionData.get(id);
    }

    public static List<PlayerSessionData> getTopPlayers() {
        isBusy = true;
        String json = IOUtils.getJsonFromURL("http://api.swdteam.co.uk/files/SWDEss/webpage/leaderboard.php");
        ArrayList<PlayerSessionData> players = new ArrayList<PlayerSessionData>();
        if (json != null && json.length() > 0) {
            try {
                PlayerSessionData[] weaponsData;
                for (PlayerSessionData data : weaponsData = (PlayerSessionData[])TheDalekMod.GSON.fromJson(json, PlayerSessionData[].class)) {
                    players.add(data);
                }
                isBusy = false;
                return players;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        isBusy = false;
        return null;
    }

    public static void clearData() {
        sessionData.clear();
    }

    static {
        isBusy = false;
        rawScore = 0;
        sessionData = new HashMap();
    }
}

