/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.FMLLog;

class ChunkIOProvider
implements Runnable {
    private final QueuedChunk chunkInfo;
    private final aye loader;
    private final on provider;
    private axw chunk;
    private fy nbt;
    private final ConcurrentLinkedQueue<Runnable> callbacks = new ConcurrentLinkedQueue();
    private boolean ran = false;

    ChunkIOProvider(QueuedChunk chunk, aye loader, on provider) {
        this.chunkInfo = chunk;
        this.loader = loader;
        this.provider = provider;
    }

    public void addCallback(Runnable callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Runnable callback) {
        this.callbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChunkIOProvider chunkIOProvider = this;
        synchronized (chunkIOProvider) {
            Object[] data = null;
            try {
                data = this.loader.loadChunk__Async(this.chunkInfo.world, this.chunkInfo.x, this.chunkInfo.z);
            }
            catch (IOException e) {
                FMLLog.log.error("Failed to load chunk async.", (Throwable)e);
            }
            if (data != null) {
                this.nbt = (fy)data[1];
                this.chunk = (axw)data[0];
            }
            this.ran = true;
            this.notifyAll();
        }
    }

    public void syncCallback() {
        if (this.chunk == null) {
            this.runCallbacks();
            return;
        }
        this.loader.loadEntities(this.chunkInfo.world, this.nbt.p("Level"), this.chunk);
        MinecraftForge.EVENT_BUS.post(new ChunkDataEvent.Load(this.chunk, this.nbt));
        this.chunk.b(this.provider.f.R());
        this.provider.c.b(this.chunk, this.chunkInfo.x, this.chunkInfo.z);
        this.provider.e.put(amn.a((int)this.chunkInfo.x, (int)this.chunkInfo.z), (Object)this.chunk);
        this.chunk.c();
        this.chunk.a((axr)this.provider, this.provider.c);
        this.runCallbacks();
    }

    public axw getChunk() {
        return this.chunk;
    }

    public boolean runFinished() {
        return this.ran;
    }

    public boolean hasCallback() {
        return this.callbacks.size() > 0;
    }

    public void runCallbacks() {
        for (Runnable r2 : this.callbacks) {
            r2.run();
        }
        this.callbacks.clear();
    }
}

