/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui;

import com.swdteam.client.gui.GuiTardisSettings;
import com.swdteam.client.gui.GuiTardisWaypoints;
import com.swdteam.client.gui.elements.GuiButtonImage;
import com.swdteam.client.gui.elements.GuiNumericalInput;
import com.swdteam.client.init.DMFontRenderer;
import com.swdteam.client.render.gui.planets.IRenderPlanet;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.planets.IPlanet;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_UpdateTardisDataField;
import com.swdteam.network.packets.Packet_UpdateTardisSettings;
import com.swdteam.utils.Graphics;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiTardisInterface
extends GuiScreen {
    private boolean isCreative;
    private int rotation;
    private GuiNumericalInput xPosInput;
    private GuiNumericalInput yPosInput;
    private GuiNumericalInput zPosInput;
    private GuiMode currentGUIMode;
    private TardisData data = null;
    private int currentExteriorSelection;
    private IPlanet currentPlanetSelection;
    private int currentPlanetSelectionID;
    private int extrot = 0;

    public GuiTardisInterface(String[] args) {
        if (args != null && args.length > 0) {
            try {
                this.data = (TardisData)TheDalekMod.GSON.fromJson(args[0], TardisData.class);
            }
            catch (Exception e) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
            if (args.length > 1) {
                try {
                    this.isCreative = Boolean.parseBoolean(args[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currentPlanetSelection = DMDimensions.getPlanetForDimension(this.data.getTardisDestinationDimension());
            this.currentPlanetSelectionID = DMDimensions.getIndexOfDimension(this.data.getTardisDestinationDimension());
            this.currentExteriorSelection = DMTardis.getTardisSkin(this.data.getExteriorID()).getID();
        }
        this.currentGUIMode = GuiMode.PLANET_SELECTION;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        String tardisfacing = "Facing (N)";
        switch ((int)(this.data.getTravelRotation() / 45.0f)) {
            case 0: {
                tardisfacing = "Facing (N)";
                break;
            }
            case 1: {
                tardisfacing = "Facing (NE)";
                break;
            }
            case 2: {
                tardisfacing = "Facing (E)";
                break;
            }
            case 3: {
                tardisfacing = "Facing (SE)";
                break;
            }
            case 4: {
                tardisfacing = "Facing (S)";
                break;
            }
            case 5: {
                tardisfacing = "Facing (SW)";
                break;
            }
            case 6: {
                tardisfacing = "Facing (W)";
                break;
            }
            case 7: {
                tardisfacing = "Facing (NW)";
            }
        }
        this.extrot = (int)(this.data.getTravelRotation() / 45.0f);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 84, this.field_146295_m / 2 + 72, 76, 20, "Save"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2, this.field_146295_m / 2 + 72, 76, 20, "Close"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 157, this.field_146295_m / 2 + 40, 143, 20, "Chameleon Circuit"));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 85, this.field_146295_m / 2 + 17, 70, 20, "Waypoints"));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 85, this.field_146295_m / 2 + 72, 70, 20, "Settings"));
        this.field_146292_n.add(new GuiButtonImage(5, this.field_146294_l / 2 + 132, this.field_146295_m / 2 + 40, 80, 0));
        this.field_146292_n.add(new GuiButtonImage(6, this.field_146294_l / 2 + 8, this.field_146295_m / 2 + 40, 120, 0));
        this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 - 157, this.field_146295_m / 2 + 17, 70, 20, tardisfacing));
        this.xPosInput = new GuiNumericalInput(0, this.field_146289_q, this.field_146294_l / 2 - 156, this.field_146295_m / 2 - 53, 140, 20);
        this.yPosInput = new GuiNumericalInput(0, this.field_146289_q, this.field_146294_l / 2 - 156, this.field_146295_m / 2 - 29, 140, 20);
        this.zPosInput = new GuiNumericalInput(0, this.field_146289_q, this.field_146294_l / 2 - 156, this.field_146295_m / 2 - 5, 140, 20);
        this.xPosInput.func_146195_b(true);
        this.xPosInput.func_146203_f(6);
        this.yPosInput.func_146203_f(6);
        this.zPosInput.func_146203_f(6);
        if (this.data.getTravelToLocation() == null) {
            this.xPosInput.setValue(this.data.getCurrentTardisPosition().x);
            this.yPosInput.setValue(this.data.getCurrentTardisPosition().y);
            this.zPosInput.setValue(this.data.getCurrentTardisPosition().z);
        } else {
            this.xPosInput.setValue(this.data.getTravelToLocation().x);
            this.yPosInput.setValue(this.data.getTravelToLocation().y);
            this.zPosInput.setValue(this.data.getTravelToLocation().z);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.xPosInput == null || this.yPosInput == null || this.zPosInput == null) {
            return;
        }
        FontRenderer font = this.field_146289_q;
        int w = 360;
        int h = 200;
        Graphics.FillRect(0.0, 0.0, (double)this.field_146294_l, (double)this.field_146295_m, 0.0, -1728053248);
        Graphics.drawGUIBack(this.field_146294_l / 2 - w / 2, this.field_146295_m / 2 - h / 2, w, h);
        Graphics.FillRect((double)(this.field_146294_l / 2), (double)(this.field_146295_m / 2 - 80), 160.0, 146.0, 0.0, -15658735);
        font.func_175065_a("Tardis Control", (float)(this.field_146294_l / 2 - w / 2 + 8), (float)(this.field_146295_m / 2 - h / 2 + 8), -1, true);
        Graphics.FillRect((double)(this.field_146294_l / 2 - w / 2 + 8), (double)(this.field_146295_m / 2 - h / 2 + 20), 156.0, 24.0, 0.0, -1442840576);
        font.func_175065_a("Current:        Rotation: " + this.data.getTravelRotation(), (float)(this.field_146294_l / 2 - w / 2 + 11), (float)(this.field_146295_m / 2 - h / 2 + 23), 0xFFFFFF, true);
        font.func_175065_a("X: " + this.data.getCurrentTardisPosition().x + ", Y: " + this.data.getCurrentTardisPosition().y + ", Z: " + this.data.getCurrentTardisPosition().z, (float)(this.field_146294_l / 2 - w / 2 + 11), (float)(this.field_146295_m / 2 - h / 2 + 34), 0xFFFFFF, true);
        font.func_175065_a("X:", (float)(this.field_146294_l / 2 - w / 2 + 8), (float)(this.field_146295_m / 2 - h / 2 + 52), -256, true);
        font.func_175065_a("Y:", (float)(this.field_146294_l / 2 - w / 2 + 8), (float)(this.field_146295_m / 2 - h / 2 + 76), -256, true);
        font.func_175065_a("Z:", (float)(this.field_146294_l / 2 - w / 2 + 8), (float)(this.field_146295_m / 2 - h / 2 + 100), -256, true);
        font.func_175065_a("Health: " + this.data.getTardisHealth(), (float)(this.field_146294_l / 2 - w / 2 + 90), (float)(this.field_146295_m / 2 - h / 2 + 8), -1, true);
        this.xPosInput.func_146194_f();
        this.yPosInput.func_146194_f();
        this.zPosInput.func_146194_f();
        switch (this.currentGUIMode) {
            case PLANET_SELECTION: {
                String worldName = this.currentPlanetSelection.getPlanetName();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IRenderPlanet planetRender = this.currentPlanetSelection.getPlanetRenderer();
                if (planetRender != null) {
                    Graphics.renderPlanetRenderer(this, planetRender, this.field_146294_l / 2 + 80, this.field_146295_m / 2 - 65, 1.75f, 1.0f);
                } else {
                    DMFontRenderer.drawCenteredString("Model is work in progress", this.field_146294_l / 2 + 80, this.field_146295_m / 2 - 16, 1.0f, 1.0f, 1.0f, 1.0f);
                    DMFontRenderer.drawCenteredString("Still not done :(  -Ed", this.field_146294_l / 2 + 80, this.field_146295_m / 2 - 0, 0.0f, 0.05f, 0.1f, 1.0f);
                }
                this.func_73732_a(font, worldName, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + 47, -1);
                break;
            }
            case CHAMELEON_CIRCUIT: {
                ChameleonCircuitBase tardis = DMTardis.getTardisSkin(this.currentExteriorSelection);
                if (tardis == null) break;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)400.0f);
                this.func_73732_a(font, tardis.getExteriorName(), this.field_146294_l / 2 + 80, this.field_146295_m / 2 - 72, -1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                Graphics.bindTexture(tardis.getTexture());
                if (!this.data.getUnlockedExteriors().contains(this.currentExteriorSelection) && !this.isCreative) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                    int tex = GL11.glGetInteger((int)32873);
                    this.func_73732_a(font, "LOCKED", this.field_146294_l / 2 + 80, this.field_146295_m / 2 - 6, -1);
                    Graphics.bindTexture(tex);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                Graphics.drawModelToGui(tardis.getModel(), this.field_146294_l / 2 + 80, (int)((float)(this.field_146295_m / 2) - tardis.modelGUIYOffset()), tardis.modelGUIScale() - 0.4f, this.rotation);
                GlStateManager.func_179121_F();
                break;
            }
            case WAYPOINTS: {
                break;
            }
        }
        Graphics.bindTexture(Gui.field_110324_m);
        this.func_73732_a(font, this.currentGUIMode == GuiMode.PLANET_SELECTION ? "Planet Selection" : "Chameleon Circuit", this.field_146294_l / 2 + 80, this.field_146295_m / 2 - 93, -1118482);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        IRenderPlanet planetRender;
        if (this.xPosInput == null || this.yPosInput == null || this.zPosInput == null) {
            return;
        }
        ++this.rotation;
        if (this.rotation > 360) {
            this.rotation = 0;
        }
        this.xPosInput.func_146178_a();
        this.yPosInput.func_146178_a();
        this.zPosInput.func_146178_a();
        if (this.currentGUIMode == GuiMode.PLANET_SELECTION && (planetRender = this.currentPlanetSelection.getPlanetRenderer()) != null) {
            planetRender.update();
        }
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 7) {
            String tardisfacing = "Facing (N)";
            ++this.extrot;
            if (this.extrot > 7) {
                this.extrot -= 7;
            }
            switch (this.extrot) {
                case 0: {
                    tardisfacing = "Facing (N)";
                    break;
                }
                case 1: {
                    tardisfacing = "Facing (NE)";
                    break;
                }
                case 2: {
                    tardisfacing = "Facing (E)";
                    break;
                }
                case 3: {
                    tardisfacing = "Facing (SE)";
                    break;
                }
                case 4: {
                    tardisfacing = "Facing (S)";
                    break;
                }
                case 5: {
                    tardisfacing = "Facing (SW)";
                    break;
                }
                case 6: {
                    tardisfacing = "Facing (W)";
                    break;
                }
                case 7: {
                    tardisfacing = "Facing (NW)";
                }
            }
            button.field_146126_j = tardisfacing;
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisSettings("tardislanding", "" + this.extrot));
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        }
        if (button.field_146127_k == 2) {
            switch (this.currentGUIMode) {
                case CHAMELEON_CIRCUIT: {
                    this.currentGUIMode = GuiMode.PLANET_SELECTION;
                    button.field_146126_j = "Chameleon Circuit";
                    break;
                }
                default: {
                    this.currentGUIMode = GuiMode.CHAMELEON_CIRCUIT;
                    button.field_146126_j = "Planet Selection";
                }
            }
        }
        if (button.field_146127_k == 4) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTardisSettings(this.data));
        }
        if (button.field_146127_k == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiTardisWaypoints(this.data));
        }
        switch (this.currentGUIMode) {
            case PLANET_SELECTION: {
                if (button.field_146127_k == 5) {
                    this.currentPlanetSelectionID = this.currentPlanetSelectionID + 1 >= DMDimensions.getPlanetOrderedList().size() ? 0 : ++this.currentPlanetSelectionID;
                    this.currentPlanetSelection = DMDimensions.getPlanetForDimension(DMDimensions.getIDOfDimensionAtIndex(this.currentPlanetSelectionID));
                }
                if (button.field_146127_k != 6) break;
                this.currentPlanetSelectionID = this.currentPlanetSelectionID - 1 < 0 ? DMDimensions.getPlanetOrderedList().size() - 1 : --this.currentPlanetSelectionID;
                this.currentPlanetSelection = DMDimensions.getPlanetForDimension(DMDimensions.getIDOfDimensionAtIndex(this.currentPlanetSelectionID));
                break;
            }
            case CHAMELEON_CIRCUIT: {
                if (button.field_146127_k == 5) {
                    this.currentExteriorSelection = this.currentExteriorSelection + 1 >= DMTardis.getTardisSkinArray().length ? 0 : ++this.currentExteriorSelection;
                }
                if (button.field_146127_k != 6) break;
                if (this.currentExteriorSelection - 1 < 0) {
                    this.currentExteriorSelection = DMTardis.getTardisSkinArray().length - 1;
                    break;
                }
                --this.currentExteriorSelection;
                break;
            }
        }
        if (button.field_146127_k == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        if (button.field_146127_k == 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisDataField("tardisDIM", DMDimensions.getIDOfDimensionAtIndex(this.currentPlanetSelectionID) + ""));
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisDataField("position", this.xPosInput.func_146179_b() + ":" + this.yPosInput.func_146179_b() + ":" + this.zPosInput.func_146179_b()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateTardisDataField("exterior", DMTardis.getTardisSkin(this.currentExteriorSelection).getID() + ""));
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.xPosInput.func_146201_a(typedChar, keyCode);
        this.yPosInput.func_146201_a(typedChar, keyCode);
        this.zPosInput.func_146201_a(typedChar, keyCode);
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.xPosInput.func_146192_a(mouseX, mouseY, mouseButton);
        this.yPosInput.func_146192_a(mouseX, mouseY, mouseButton);
        this.zPosInput.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public boolean func_73868_f() {
        return false;
    }

    public static enum GuiMode {
        PLANET_SELECTION,
        CHAMELEON_CIRCUIT,
        WAYPOINTS;

    }
}

