/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.block.BlockTardis;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.UserTardises;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandDM
extends CommandTreeBase {
    public String func_71517_b() {
        return "dalek-mod";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [cache|tardis|version] [action] [id] [value]";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandDM.func_71530_a((String[])args, (String[])new String[]{"cache", "tardis", "version"});
            }
            case 2: {
                if (args[0].equalsIgnoreCase("cache")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"reload"});
                }
                if (args[0].equalsIgnoreCase("tardis")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"add-self", "find-owner", "set-owner", "set-scale", "set-health", "toggle-lock", "toggle-open", "list"});
                }
            }
            case 3: {
                if (args[1].equalsIgnoreCase("set-owner")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"tardis_id", "player"});
                }
                if (args[1].equalsIgnoreCase("set-scale")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"tardis_id", "scale"});
                }
                if (args[1].equalsIgnoreCase("set-health")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"tardis_id", "health"});
                }
                if (args[1].equalsIgnoreCase("add-self") || args[1].equalsIgnoreCase("find-owner") || args[1].equalsIgnoreCase("toggle-lock")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"tardis_id"});
                }
            }
            case 4: {
                if (args[1].equalsIgnoreCase("set-scale")) {
                    return CommandDM.func_71530_a((String[])args, (String[])new String[]{"scale"});
                }
                if (!args[1].equalsIgnoreCase("set-owner")) break;
                return CommandDM.func_71530_a((String[])args, (String[])new String[]{"player"});
            }
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0) {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)CommandDM.func_71521_c((ICommandSender)sender), this.func_71518_a(sender));
            return;
        }
        if (!(sender instanceof EntityPlayerMP)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "message.fail.playeronly", new Object[0]));
        }
        EntityPlayerMP player = CommandDM.func_71521_c((ICommandSender)sender);
        World w = player.func_130014_f_();
        TileEntity te = null;
        boolean isTileTardis = false;
        List<WorldUtils.BlockWithPos> l = WorldUtils.getBlocksWithinBounds(sender.func_130014_f_(), player.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0));
        WorldUtils.BlockWithPos blockWithPos = null;
        boolean isTile = false;
        for (WorldUtils.BlockWithPos bwp : l) {
            Block b = bwp.getBlock();
            if (b != DMBlocks.TARDIS) continue;
            blockWithPos = bwp;
            isTile = true;
            break;
        }
        if (isTile) {
            te = w.func_175625_s(blockWithPos.getBlockPos());
        }
        TardisData data = null;
        TileEntityTardis tardis = null;
        if (te instanceof TileEntityTardis) {
            tardis = (TileEntityTardis)te;
            data = tardis.tempTardisData;
            if (data != null) {
                isTileTardis = true;
            }
        }
        String pattern = "(.*)\\{\"name\":\"(.*)\"(.*)\\}\\]";
        if (args[0].equalsIgnoreCase("cache")) {
            if (args[1].equalsIgnoreCase("reload")) {
                return;
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Available actions: reload"));
            return;
        }
        if (args[0].equalsIgnoreCase("tardis")) {
            if (args[1].equalsIgnoreCase("add-self")) {
                if (args.length == 3) {
                    int id = Integer.parseInt(args[2]);
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                data.addCompanion((EntityPlayer)player);
                data.setTardisPermissions(TardisPermission.COMPANIONS);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have force added yourself to " + data.getOwner() + "'s Tardis (" + data.getTardisID() + ")"));
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("find-owner")) {
                if (args.length == 3) {
                    int id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                if (data.getCurrentOwner() != null) {
                    String OwnerName = DMUtils.getName(data.getCurrentOwner().toString()).replaceAll(pattern, "$2").toString().replace("\",\"changedToAt", "");
                    data.setOwner(OwnerName);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "TARDIS ID " + data.getTardisID() + " Belongs to " + data.getCurrentOwner().toString() + " AKA " + data.getOwner()));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS!"));
                }
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("set-owner")) {
                int id;
                UUID ownerUUID = player.func_110124_au();
                if (args.length == 4) {
                    ownerUUID = UUID.fromString(DMUtils.getUUIDs(args[3]));
                    id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                if (args.length == 3) {
                    if (isTileTardis) {
                        ownerUUID = UUID.fromString(DMUtils.getUUIDs(args[3]));
                    } else {
                        id = Integer.parseInt(args[2].replace(".", ""));
                        if (id > 0) {
                            data = DMTardis.getTardis(id);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                            return;
                        }
                    }
                }
                data.setCurrentOwner(ownerUUID);
                String OwnerName = DMUtils.getName(data.getCurrentOwner().toString()).replaceAll(pattern, "$2").toString().replace("\",\"changedToAt", "");
                data.setOwner(OwnerName);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have transferred TARDIS(" + data.getTardisID() + ") ownership to " + data.getOwner()));
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("set-scale")) {
                float scale = 1.0f;
                if (args.length == 4) {
                    scale = Float.parseFloat(args[3]);
                    int id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                if (args.length == 3) {
                    scale = Float.parseFloat(args[2]);
                }
                data.setScale(scale);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have scaled the TARDIS(" + data.getTardisID() + ") to " + data.getScale()));
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("set-health")) {
                int health = 1;
                if (args.length == 4) {
                    health = Integer.parseInt(args[3]);
                    int id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                if (args.length == 3) {
                    health = Integer.parseInt(args[2]);
                }
                data.setTardisHealth(health);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have set the TARDIS(" + data.getTardisID() + ") Health to " + data.getTardisHealth()));
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("toggle-lock")) {
                if (args.length == 3) {
                    int id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                data.setLocked(!data.isLocked());
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have force " + (data.isLocked() ? "locked " : "unlocked ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                TardisSaveHandler.saveTardis(data);
            } else if (args[1].equalsIgnoreCase("toggle-open")) {
                if (args.length == 3) {
                    int id = Integer.parseInt(args[2].replace(".", ""));
                    if (id > 0) {
                        data = DMTardis.getTardis(id);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid TARDIS ID."));
                        return;
                    }
                }
                if (data.isInFlight()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot enter the Tardis during materialization"));
                }
                if (data.isLocked()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + data.getOwner() + "'s Tardis is now unlocked."));
                }
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "You have force " + (data.isDoorOpen() ? "closed " : "opened ") + data.getOwner() + "'s Tardis(" + data.getTardisID() + ")"));
                BlockTardis.getSkin(w, blockWithPos.getBlockPos()).onRightClick(w, (EntityPlayer)player, blockWithPos.getBlockPos(), tardis, true);
                TardisSaveHandler.saveTardis(data);
            } else {
                if (args[1].equalsIgnoreCase("list")) {
                    if (args.length >= 3) {
                        GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(args[2]);
                        if (profile == null) {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Unable to get data for " + args[2]);
                            return;
                        }
                        UUID uuid = profile.getId();
                        if (uuid == null) {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "Player " + args[2] + " does not exist.");
                            return;
                        }
                        UserTardises uTar = DMTardis.getUserTardises(uuid);
                        if (uTar == null) {
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + args[2] + " has no Tardises");
                            return;
                        }
                        if (uTar.getTardises() != null && uTar.getTardises().size() > 0) {
                            StringBuilder b = new StringBuilder();
                            for (int i = 0; i < uTar.getTardises().size(); ++i) {
                                b.append(uTar.getTardises().get(i) + (i == uTar.getTardises().size() - 1 ? "" : ","));
                            }
                            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.GREEN + args[2] + " owns the following Tardises: " + TextFormatting.RESET + b.toString());
                            return;
                        }
                        PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + args[2] + " has no Tardises");
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No user specified"));
                    return;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Available actions: add-self, find-owner, set-owner, set-scale, toggle-lock, toggle-open, list"));
                return;
            }
        }
        if (!args[0].equalsIgnoreCase("version")) {
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)CommandDM.func_71521_c((ICommandSender)sender), this.func_71518_a(sender));
            return;
        }
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You are playing: " + TextFormatting.RED + "Dalek Mod" + " " + TextFormatting.BLUE + "(Update 50.0)"));
    }
}

