/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.event;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class TardisHandler {
    @SubscribeEvent
    public static void LivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            if (capa.getInFlight() && !TardisHandler.onGround(player) && capa instanceof CapabilityTardis) {
                float f1 = (float)(player.field_70159_w + player.field_70181_x + player.field_70179_y) / 4.0f;
                ((CapabilityTardis)capa).rotation += 1.0f - f1;
            }
            if (TardisHandler.onGround(player) && capa.getInFlight()) {
                capa.setTicksOnground(capa.getTicksOnground() + 1);
                capa.syncToPlayer();
            }
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP p = (EntityPlayerMP)player;
                if (capa.getInFlight() && capa instanceof CapabilityTardis && !((CapabilityTardis)capa).requestedSent) {
                    capa.syncToPlayer();
                    ((CapabilityTardis)capa).requestedSent = true;
                }
                if (TardisHandler.onGround((EntityPlayer)p) && capa.getInFlight()) {
                    if (capa.getTicksOnground() == 32) {
                        capa.syncToPlayer();
                    }
                    if (capa.getTicksOnground() >= 32 && p.func_70093_af() && player.func_70055_a(Material.field_151579_a) && !player.func_180799_ab() && !player.func_70090_H() && player.field_70170_p.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                        capa.setInFlight(false);
                        capa.setTicksOnground(0);
                        PlayerUtils.TARDIS.resetPlayer((EntityPlayer)p);
                        TardisData data = DMTardis.getTardis(capa.getTARDISID());
                        if (data != null) {
                            data.setInFlight(false);
                            data.setInFlightMode(false);
                            data.setCurrentTardisPosition(WorldUtils.blockPosToVec3(player.func_180425_c()));
                            data.setDestinationTardisPosition(WorldUtils.blockPosToVec3(player.func_180425_c()));
                            TardisSaveHandler.saveTardis(data);
                        }
                        double xPos = capa.getTARDISX();
                        double yPos = capa.getTARDISY();
                        double zPos = capa.getTARDISZ();
                        float pitch = capa.getPitch();
                        float yaw = capa.getYaw();
                        capa.syncToPlayer();
                        float rotation = 0.0f;
                        if (capa instanceof CapabilityTardis) {
                            rotation = capa.getRotation();
                        }
                        World w = player.func_130014_f_();
                        BlockPos pos = p.func_180425_c();
                        w.func_175656_a(pos, DMBlocks.TARDIS.func_176223_P());
                        TileEntity te = w.func_175625_s(pos);
                        if (te instanceof TileEntityTardis) {
                            if (data != null) {
                                ((TileEntityTardis)te).tempTardisData = data;
                            }
                            ((TileEntityTardis)te).rotation = rotation;
                            ((TileEntityTardis)te).tardisID = capa.getTARDISID();
                            te.func_70296_d();
                            WorldUtils.markBlockForUpdate(w, pos);
                        }
                        try {
                            TeleportUtils.teleportToDimension(p, DMDimensions.DIM_TARDIS_ID, xPos, yPos, zPos, yaw, pitch);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (capa.getTicksOnground() == 1) {
                        p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, DMSounds.tardisLand, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
                if (!TardisHandler.onGround((EntityPlayer)p) && capa.getInFlight() && capa.getTicksOnground() != 0) {
                    capa.setTicksOnground(0);
                    capa.syncToPlayer();
                }
                if (TardisHandler.isInFlightMode((EntityPlayer)p)) {
                    p.func_184224_h(true);
                    p.field_71075_bZ.field_75101_c = true;
                    p.field_71075_bZ.field_75099_e = false;
                    p.field_71075_bZ.field_75102_a = true;
                    p.field_71075_bZ.field_75100_b = true;
                }
            }
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent e) {
        EntityPlayerMP player;
        if (e.getEntity() != null && e.getEntity() instanceof EntityPlayerMP && TardisHandler.isInFlightMode((EntityPlayer)(player = (EntityPlayerMP)e.getEntity()))) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void loginReset(PlayerEvent.PlayerLoggedOutEvent e) {
        EntityPlayer player = e.player;
        ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        capa.setInFlight(false);
        TardisData data = DMTardis.getTardis(capa.getTARDISID());
        if (data != null) {
            data.setInFlight(false);
            data.setInFlightMode(false);
            TardisSaveHandler.saveTardis(data);
        }
    }

    @SubscribeEvent
    public static void playerInteract(PlayerInteractEvent e) {
        EntityPlayerMP player;
        Entity entity = e.getEntity();
        if (entity instanceof EntityPlayerMP && TardisHandler.isInFlightMode((EntityPlayer)(player = (EntityPlayerMP)entity))) {
            e.setCanceled(true);
        }
    }

    public static boolean isInFlightMode(EntityPlayer player) {
        if (player.hasCapability(CapabilityTardis.FLIGHTMODE_CAP, null)) {
            return ((ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null)).getInFlight();
        }
        return false;
    }

    @SubscribeEvent
    public static void commandEvent(CommandEvent c) {
        EntityPlayerMP player;
        if (c.getSender() instanceof EntityPlayerMP && TardisHandler.isInFlightMode((EntityPlayer)(player = (EntityPlayerMP)c.getSender()))) {
            c.setCanceled(true);
            PlayerUtils.Messaging.sendMessageToPlayer((EntityPlayer)player, TextFormatting.RED + "You cannot use commands whilst in flight mode.");
        }
    }

    @SubscribeEvent
    public static void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent e) {
        ITardisCapability capa = (ITardisCapability)e.player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        if (capa.getInFlight()) {
            capa.setResetLogin(true);
            capa.setInFlight(false);
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent e) {
        ITardisCapability capa = (ITardisCapability)e.player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        boolean b = capa.getResetLogin();
        if (e.player instanceof EntityPlayerMP && b) {
            PlayerUtils.TARDIS.resetPlayer(e.player);
            capa.setResetLogin(false);
            double xPos = capa.getTARDISX();
            double yPos = capa.getTARDISY();
            double zPos = capa.getTARDISZ();
            float pitch = capa.getPitch();
            float yaw = capa.getYaw();
            TeleportUtils.teleportToDimension((Entity)e.player, DMDimensions.DIM_TARDIS_ID, xPos, yPos, zPos, yaw, pitch);
        }
    }

    public static boolean onGround(EntityPlayer player) {
        BlockPos pos = new BlockPos((double)player.func_180425_c().func_177958_n(), Math.ceil(player.field_70163_u) - 1.0, (double)player.func_180425_c().func_177952_p());
        IBlockState blip = player.field_70170_p.func_180495_p(pos);
        return blip.func_185904_a() != Material.field_151579_a;
    }

    @SubscribeEvent
    public static void disableAttack(LivingAttackEvent e) {
        EntityPlayer player;
        if (e.getSource().func_76346_g() instanceof EntityPlayer && TardisHandler.isInFlightMode(player = (EntityPlayer)e.getSource().func_76346_g())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        System.out.println("World loading...");
    }
}

