/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen.structures.global;

import com.google.common.base.Predicate;
import com.swdteam.common.entity.EntityAuton;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.world.gen.structures.classic.WorldGenClassicTree;
import com.swdteam.common.world.gen.structures.gallifrey.WorldGenGallifreyTrees;
import com.swdteam.common.world.gen.structures.global.WorldGenComet;
import com.swdteam.common.world.gen.structures.global.WorldGenMoonOrePile;
import com.swdteam.common.world.gen.structures.moon.WorldGenCyberHut;
import com.swdteam.common.world.gen.structures.skaro.WorldGenOrePile;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.DMUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGeneration
implements IWorldGenerator {
    private final WorldGenGallifreyTrees trees = new WorldGenGallifreyTrees();
    private final WorldGenOrePile orePile = new WorldGenOrePile();
    private final WorldGenMoonOrePile orePileMoon = new WorldGenMoonOrePile();
    private final WorldGenComet oreMeteor = new WorldGenComet();
    private final WorldGenCyberHut cyHut = new WorldGenCyberHut();

    private void generateOre(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            WorldGenMinable generator = new WorldGenMinable(ore, size);
            generator.func_180709_b(world, random, pos);
        }
    }

    private void generateOreDIM(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances, Block blk) {
        int deltaY = maxY - minY;
        Predicate predicate = input -> input == blk.func_176223_P();
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            WorldGenMinable generator = new WorldGenMinable(ore, size, predicate);
            generator.func_180709_b(world, random, pos);
        }
    }

    private void spawnDaleks(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 5; ++i) {
            int randPosZ;
            int randPosX = chunkX + 8;
            int randPosY = rand.nextInt(96);
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ = chunkZ + 8);
            if (world.func_175623_d(pos) || !world.func_175623_d(pos.func_177982_a(0, 1, 0)) || !world.func_175623_d(pos.func_177982_a(0, 1, 0))) continue;
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150391_bh) {
                return;
            }
            if (rand.nextInt(2) != 1) continue;
            EntityAuton dalek = new EntityAuton(world);
            dalek.func_70107_b(randPosX, randPosY + 1, randPosZ);
            world.func_72838_d((Entity)dalek);
        }
    }

    private void generateClassicTrees(World world, Random rand, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        if (rand.nextBoolean() && world.func_180495_p(new BlockPos(randPosX = chunkX + rand.nextInt(10) + 4, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(10) + 4)).func_177956_o() - 1, randPosZ)).func_177230_c() == DMBlocks.classic_grass) {
            new WorldGenClassicTree().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimID = world.field_73011_w.getDimension();
        if (dimID == DMConfig.dimensionIDs.Moon_Dimension_ID) {
            this.generateOreDIM(DMBlocks.bTitaniumOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 64, 1 + random.nextInt(4), 10, DMBlocks.moon_rock);
            this.generateCyberHut(world, random, chunkX * 16, chunkZ * 16);
            this.generateOreDIM(DMBlocks.eggShellBlock.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 64, 8 + random.nextInt(12), 20, DMBlocks.moon_rock);
            this.generateOreDIM(DMBlocks.cheeseOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 24, 2 + random.nextInt(5), 20, DMBlocks.moon_rock);
        }
        if (dimID == 0) {
            this.generateComet(world, random, chunkX * 16, chunkZ * 16);
            this.generateOre(DMBlocks.cyOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 96, 4 + random.nextInt(4), 8);
            this.generateOre(DMBlocks.silicate.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 96, 6 + random.nextInt(4), 8);
            this.generateOre(DMBlocks.SonicCrystalOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 2, 96, 1 + random.nextInt(4), 7);
        }
        if (dimID == DMConfig.dimensionIDs.Varos_Dimension_ID) {
            this.generateOreDIM(DMBlocks.ZeitonBlock.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 64, 4 + random.nextInt(4), 6, DMBlocks.varosSand);
        }
        if (dimID == DMConfig.dimensionIDs.Minecraft_Classic_Dimension_ID) {
            this.generateClassicTrees(world, random, chunkX * 16, chunkZ * 16);
        }
        if (dimID == DMConfig.dimensionIDs.Skaro_Dimension_ID) {
            this.generateOreDIM(DMBlocks.dalekaniumOre.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 16, 96, 1 + random.nextInt(4), 20, DMBlocks.skaroStone);
            this.generateSkaroOrePile(world, random, chunkX * 16, chunkZ * 16);
        }
        if (dimID == DMConfig.dimensionIDs.Gallifrey_Dimension_ID) {
            this.generateGallifreyTrees(world, random, chunkX * 16, chunkZ * 16);
            this.generateGallifreySand(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateSkaroOrePile(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 30; ++i) {
            int randPosX = chunkX + rand.nextInt(16);
            int randPosZ = chunkZ + rand.nextInt(16);
            int randPosY = world.func_189649_b(randPosX, randPosX);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() != DMBlocks.SkaroSand || rand.nextInt(61) != 1) continue;
            this.orePile.generate(world, DMUtils.RANDOM, randPosX, randPosY, randPosZ);
        }
    }

    private void generateMoonOrePile(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 90; ++i) {
            int randPosX = chunkX + rand.nextInt(16);
            int randPosZ = chunkZ + rand.nextInt(16);
            int randPosY = world.func_189649_b(randPosX, randPosX);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() != DMBlocks.moon_rock || world.func_180495_p(new BlockPos(randPosX, randPosY - 1, randPosZ)).func_177230_c() == Blocks.field_150350_a || rand.nextInt(61) != 1) continue;
            this.orePileMoon.generate(world, DMUtils.RANDOM, randPosX, randPosY, randPosZ);
        }
    }

    private void generateCyberHut(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 30; ++i) {
            int randPosX = chunkX + rand.nextInt(16);
            int randPosZ = chunkZ + rand.nextInt(16);
            int randPosY = world.func_189649_b(randPosX, randPosX);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() != DMBlocks.moon_rock && world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() != DMBlocks.moon_rock_2 || world.func_180495_p(new BlockPos(randPosX, randPosY + 1, randPosZ)).func_177230_c() != Blocks.field_150350_a || rand.nextInt(1200) != 1) continue;
            this.cyHut.generate(world, DMUtils.RANDOM, randPosX, randPosY, randPosZ);
        }
    }

    private void generateComet(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 30; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX = chunkX + rand.nextInt(16);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY = rand.nextInt(96), randPosZ = chunkZ + rand.nextInt(16))).func_177230_c() != Blocks.field_150349_c && world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() != DMBlocks.moon_rock_2 || world.func_180495_p(new BlockPos(randPosX, randPosY + 1, randPosZ)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(new BlockPos(randPosX, randPosY - 1, randPosZ)).func_177230_c() != DMBlocks.gallifreyGrass || world.func_180495_p(new BlockPos(randPosX, randPosY - 1, randPosZ)).func_177230_c() != DMBlocks.gallifreyGrass || rand.nextInt(100) != 1) continue;
            this.oreMeteor.generate(world, DMUtils.RANDOM, randPosX, randPosY, randPosZ);
        }
    }

    private void generateGallifreyTrees(World world, Random rand, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        if (rand.nextBoolean() && (world.func_180495_p(new BlockPos(randPosX = chunkX + rand.nextInt(10) + 4, randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ = chunkZ + rand.nextInt(10) + 4)).func_177956_o() - 1, randPosZ)).func_177230_c() == DMBlocks.gallifreyGrass && world.func_180495_p(new BlockPos(randPosX + 1, randPosY, randPosZ + 1)).func_177230_c() == DMBlocks.gallifreyGrass || world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() == DMBlocks.GallifreyDirt) && world.func_180495_p(new BlockPos(randPosX, randPosY + 1, randPosZ)).func_177230_c() == Blocks.field_150350_a) {
            this.trees.generate(randPosX, randPosY, randPosZ, world);
        }
    }

    private void generateGallifreySand(World world, Random rand, int chunkX, int chunkZ) {
        int randPosX = chunkX + rand.nextInt(10) + 4;
        int randPosZ = chunkZ + rand.nextInt(10) + 4;
        int randPosY = world.func_175672_r(new BlockPos(randPosX, 0, randPosZ)).func_177956_o() - 1;
        int c = 1;
        if (c == 1 && (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() == DMBlocks.gallifreyGrass && world.func_180495_p(new BlockPos(randPosX + 1, randPosY, randPosZ + 1)).func_177230_c() == DMBlocks.gallifreyGrass || world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ)).func_177230_c() == DMBlocks.GallifreyDirt)) {
            world.func_175656_a(new BlockPos(randPosX, randPosY, randPosZ), DMBlocks.GallifreySand.func_176223_P());
            --c;
        }
    }

    public class WorldGeneratorCustom {
        public IBlockState block;
        public int chance = 0;

        public WorldGeneratorCustom(IBlockState state, int chance) {
            this.block = state;
            this.chance = chance;
        }
    }
}

