/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl;

import com.swdteam.mdl.graphics.Graphics;
import com.swdteam.mdl.obj.Model;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class MDL {
    private Model[] models;
    public int[] displayLists;
    public BufferedImage[] textureFile;
    public int[] textures;
    public boolean[] loadingTextures;

    public void setModels(Model[] models) {
        this.models = models;
        this.displayLists = new int[models.length];
        int i = 0;
        while (i < models.length) {
            this.displayLists[i] = -1;
            ++i;
        }
    }

    public void setTextures(BufferedImage[] imgs) {
        this.textureFile = imgs;
        this.textures = new int[imgs.length];
        this.loadingTextures = new boolean[imgs.length];
        int i = 0;
        while (i < imgs.length) {
            this.textures[i] = -1;
            this.loadingTextures[i] = false;
            ++i;
        }
    }

    public void render() {
        if (this.models != null) {
            int previousTexture = GL11.glGetInteger((int)32873);
            Model[] modelArray = this.models;
            int n = this.models.length;
            int n2 = 0;
            while (n2 < n) {
                float f;
                Model m1 = modelArray[n2];
                if (m1.objName.equalsIgnoreCase("dalek_head")) {
                    m1.xRotation = 0.0;
                    m1.yTransform = 0.51f;
                    m1.yRotation = -Minecraft.func_71410_x().field_71441_e.func_72820_D();
                    m1.zRotation = 0.0;
                }
                if (m1.objName.equalsIgnoreCase("dalek_eye")) {
                    f = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.25f));
                    m1.xRotation = Math.toDegrees(f) - 90.0;
                }
                if (m1.objName.equalsIgnoreCase("dalek_gun")) {
                    f = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.25f));
                    m1.xRotation = -Math.toDegrees(f) + 90.0;
                }
                if (!m1.isChild) {
                    Minecraft.func_71410_x().field_71460_t.func_180436_i();
                    m1.renderAll(this);
                    Minecraft.func_71410_x().field_71460_t.func_175072_h();
                }
                ++n2;
            }
            Graphics.bindTexture(previousTexture);
        }
    }

    public int createDisplayList(Model model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        model.render(this);
        GL11.glEndList();
        return displayList;
    }

    public Model[] getModels() {
        return this.models;
    }
}

