/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl.obj;

import com.swdteam.mdl.MDLData;
import com.swdteam.mdl.MDLLoader;
import com.swdteam.mdl.obj.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class OBJLoader {
    public static OBJLoader INSTANCE = new OBJLoader();

    public static void main(String[] args) {
        MDLData data = new MDLData();
        data.textures = new String[]{"tex"};
        MDLData.ObjectData d = new MDLData.ObjectData();
        d.name = "model_test";
        d.texture_index = 0;
        d.xOffset = 0.0;
        d.yOffset = 0.0;
        d.zOffset = 0.0;
        d.xTransform = 0.0;
        d.yTransform = 0.0;
        d.zTransform = 0.0;
        data.object_data = new MDLData.ObjectData[]{d};
        System.out.println(MDLLoader.GSON.toJson((Object)data));
    }

    public int createDisplayList(Model model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        this.render(model);
        GL11.glEndList();
        return displayList;
    }

    public void render(Model model) {
        GlStateManager.func_179094_E();
        for (Model.Face face : model.getFaces()) {
            List<Vector3f> n = model.getNormals();
            List<Vector2f> t = model.getTextureCoordinates();
            List<Vector3f> v = model.getVertices();
            if (face.getNormals().length > 3) {
                GL11.glBegin((int)7);
            } else {
                GL11.glBegin((int)4);
            }
            int i = 0;
            while (i < face.getNormals().length) {
                GL11.glNormal3f((float)n.get(face.getNormals()[i] - 1).getX(), (float)n.get(face.getNormals()[i] - 1).getY(), (float)n.get(face.getNormals()[i] - 1).getZ());
                GL11.glTexCoord2f((float)t.get(face.getTextureCoords()[i] - 1).getX(), (float)(1.0f - t.get(face.getTextureCoords()[i] - 1).getY()));
                GL11.glVertex3f((float)v.get(face.getVertices()[i] - 1).getX(), (float)v.get(face.getVertices()[i] - 1).getY(), (float)v.get(face.getVertices()[i] - 1).getZ());
                ++i;
            }
            GL11.glEnd();
        }
        GlStateManager.func_179121_F();
    }

    public Model loadModel(File file) throws FileNotFoundException {
        Scanner s = new Scanner(file);
        Model obj = this.loadModel(s);
        return obj;
    }

    public Model loadModel(InputStream stream) {
        Scanner s = new Scanner(stream);
        Model obj = this.loadModel(s);
        return obj;
    }

    public Model loadModel(ResourceLocation resource) {
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b();
            Model obj = this.loadModel(stream);
            return obj;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Model loadModel(Scanner sc) {
        Model model = new Model();
        block14: while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln == null || ln.equals("") || ln.startsWith("#")) continue;
            String[] split = ln.split(" ");
            switch (split[0]) {
                case "v": {
                    model.getVertices().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vn": {
                    model.getNormals().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vt": {
                    model.getTextureCoordinates().add(new Vector2f(Float.parseFloat(split[1]), Float.parseFloat(split[2])));
                    break;
                }
                case "f": {
                    if (split.length == 4) {
                        model.getFaces().add(new Model.Face(new int[]{this.parseInt(split[1].split("/")[0]), this.parseInt(split[2].split("/")[0]), this.parseInt(split[3].split("/")[0])}, new int[]{this.parseInt(split[1].split("/")[1]), this.parseInt(split[2].split("/")[1]), this.parseInt(split[3].split("/")[1])}, new int[]{this.parseInt(split[1].split("/")[2]), this.parseInt(split[2].split("/")[2]), this.parseInt(split[3].split("/")[2])}));
                    }
                    if (split.length != 5) continue block14;
                    model.getFaces().add(new Model.Face(new int[]{this.parseInt(split[1].split("/")[0]), this.parseInt(split[2].split("/")[0]), this.parseInt(split[3].split("/")[0]), this.parseInt(split[4].split("/")[0])}, new int[]{this.parseInt(split[1].split("/")[1]), this.parseInt(split[2].split("/")[1]), this.parseInt(split[3].split("/")[1]), this.parseInt(split[4].split("/")[1])}, new int[]{this.parseInt(split[1].split("/")[2]), this.parseInt(split[2].split("/")[2]), this.parseInt(split[3].split("/")[2]), this.parseInt(split[4].split("/")[2])}));
                    break;
                }
                case "s": {
                    model.setSmoothShadingEnabled(!ln.contains("off"));
                    break;
                }
                default: {
                    System.out.println("[OBJ] Unknown Line: " + ln);
                }
            }
        }
        return model;
    }

    public int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

