/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.AbstractServerMessageHandler;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Packet_UpdateTardisDataField
implements IMessage {
    public String field;
    public String data;

    public Packet_UpdateTardisDataField() {
    }

    public Packet_UpdateTardisDataField(String fieldName, String data) {
        this.field = fieldName;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.field = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.field);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
    }

    public static class Handler
    extends AbstractServerMessageHandler<Packet_UpdateTardisDataField> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_UpdateTardisDataField message, MessageContext ctx) {
            EnumActionResult RESULT = EnumActionResult.SUCCESS;
            ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            int tardisID = capa.getTARDISID();
            TardisData tData = DMTardis.getTardis(tardisID);
            String FIELD = message.field;
            String DATA = message.data;
            if (DMTardis.hasPermission(tData, player)) {
                if (FIELD.equals("tardisDIM")) {
                    if (DMDimensions.getPlanets().containsKey(tData.getTardisDestinationDimension())) {
                        tData.setTardisDestinationDimension(Integer.parseInt(DATA));
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "This planet does not exist on this server");
                        RESULT = EnumActionResult.FAIL;
                    }
                }
                if (FIELD.equals("exterior")) {
                    int exteriorID = 0;
                    try {
                        exteriorID = Integer.parseInt(DATA);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (tData.getUnlockedExteriors().contains(exteriorID) || player.func_184812_l_()) {
                        tData.setExteriorID(exteriorID);
                    } else {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "You have not unlocked this skin yet");
                    }
                }
                if (FIELD.equals("position")) {
                    int[] pos = new int[3];
                    String[] s = DATA.split(":");
                    for (int i = 0; i < 3; ++i) {
                        pos[i] = Integer.parseInt(s[i].replaceAll(" ", ""));
                    }
                    if (s.length > 3) {
                        tData.setTravelRotation(Float.parseFloat(s[3].replaceAll(" ", "")));
                    }
                    tData.setTravelToLocation(new Vector3(pos[0], pos[1], pos[2]));
                }
                if (RESULT == EnumActionResult.SUCCESS) {
                    TardisSaveHandler.saveTardis(tData);
                    TileEntityTardis tet = (TileEntityTardis)TheDalekMod.FML.getMinecraftServerInstance().func_71218_a(tData.getTardisCurrentdimension()).func_175625_s(WorldUtils.vec3ToBlockPos(tData.getCurrentTardisPosition()));
                    if (tet != null) {
                        tet.tempTardisData = tData;
                    }
                }
            }
            return null;
        }
    }
}

