/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils.world;

import com.swdteam.common.init.DMBlocks;
import com.swdteam.main.DM18BlockMap;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.world.Schematic;
import com.swdteam.utils.world.TileData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SchematicUtils {
    public static void main(String[] args) {
    }

    public static Schematic loadSchematic(String file, FileLocation location) {
        Schematic schem = null;
        if (location == FileLocation.INTERNAL) {
            InputStream stream = SchematicUtils.class.getResourceAsStream("/assets/thedalekmod/schematics/" + file + ".schm");
            try {
                ObjectInputStream ois = new ObjectInputStream(stream);
                Object o = ois.readObject();
                ois.close();
                if (o instanceof Schematic) {
                    schem = (Schematic)o;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (location == FileLocation.EXTERNAL) {
            try {
                FileInputStream stream = new FileInputStream(file);
                ObjectInputStream ois = new ObjectInputStream(stream);
                Object o = ois.readObject();
                ois.close();
                if (o instanceof Schematic) {
                    schem = (Schematic)o;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return schem;
    }

    public static void saveSchematic(Schematic schem, String fileName) {
        String fileDir = "mods/Dalek Mod/Schematics/";
        fileName = fileName + ".schm";
        try {
            File file = new File(fileDir + fileName);
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file, false);
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(schem);
            stream.close();
            System.out.println(file.getPath());
        }
        catch (Exception e) {
            TheDalekMod.LOG.error((Object)e);
        }
    }

    public static void generateSchematic(World w, BlockPos p, Schematic schem) {
        SchematicUtils.generateSchematic(w, p, schem, BlockMap.DM_1_12_2);
    }

    public static void generateSchematic(World w, BlockPos p, Schematic schem, BlockMap map) {
        int i;
        int chunkSize = schem.getSchemDimX() * schem.getSchemDimY() * schem.getSchemDimZ();
        int index = 0;
        for (i = 0; i <= schem.getSchemDimY(); ++i) {
            int y = i;
            for (int x = 0; x <= schem.getSchemDimX(); ++x) {
                for (int z = 0; z <= schem.getSchemDimZ(); ++z) {
                    IBlockState state;
                    Block block;
                    BlockPos pos = new BlockPos(x, y, z).func_177982_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                    if (schem.getBoolMap()[index] == 1) {
                        block = null;
                        block = map == BlockMap.DM_1_12_2 ? DMBlocks.BlockInfo.DM_BLOCKS.get(schem.getBlockMap()[index]) : DM18BlockMap.getBlockForID(schem.getBlockMap()[index]);
                        state = block.func_176223_P();
                        try {
                            state = block.func_176203_a((int)schem.getMetaMap()[index]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (state == null) {
                            state = block.func_176223_P();
                        }
                        WorldUtils.setBlockFast(w, pos, state, 2);
                    } else {
                        block = Block.func_149729_e((int)schem.getBlockMap()[index]);
                        state = block.func_176203_a((int)schem.getMetaMap()[index]);
                        WorldUtils.setBlockFast(w, pos, state, 2);
                    }
                    ++index;
                }
            }
        }
        for (i = 0; i < schem.getTileData().size(); ++i) {
            TileData tileData = schem.getTileData().get(i);
            BlockPos pos = new BlockPos(p.func_177958_n() + tileData.getPos()[0], p.func_177956_o() + tileData.getPos()[1], p.func_177952_p() + tileData.getPos()[2]);
            TileEntity t = w.func_175625_s(pos);
            NBTTagCompound tag = new NBTTagCompound();
            try {
                tag = JsonToNBT.func_180713_a((String)tileData.getNbtDataString());
            }
            catch (NBTException e) {
                TheDalekMod.LOG.error((Object)e);
            }
            if (t == null) continue;
            if (tag != null) {
                tag.func_74768_a("x", pos.func_177958_n());
                tag.func_74768_a("y", pos.func_177956_o());
                tag.func_74768_a("z", pos.func_177952_p());
                t.func_145839_a(tag);
            }
            t.func_70296_d();
            WorldUtils.markBlockForUpdate(w, pos);
        }
    }

    public static enum FileLocation {
        INTERNAL,
        EXTERNAL;

    }

    public static enum BlockMap {
        DM_1_8,
        DM_1_12_2;

    }
}

