/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.model.entities.dalek;

import com.swdteam.client.model.mdl.ModelMDL;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.init.DMDalekRegistry;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLLoader;
import com.swdteam.mdl.obj.Model;
import com.swdteam.utils.Graphics;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class ModelDalek
extends ModelBase {
    MDL dalekSteampunk;

    public ModelDalek() {
        try {
            this.dalekSteampunk = MDLLoader.loadMDL(new ResourceLocation("thedalekmod", "models/mdl/entity/dalek/dalek_steampunk_gold.mdl"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (entity instanceof EntityDalek) {
            EntityDalek dalek = (EntityDalek)entity;
            if (dalek.getDalekData() == DMDalekRegistry.STEAMPUNK) {
                for (Model m : this.dalekSteampunk.getModels()) {
                    double rotationEye;
                    if (m.objName.equalsIgnoreCase("head")) {
                        double rotation;
                        m.yRotation = rotation = Math.toDegrees(netHeadYaw / 57.295776f);
                    }
                    if (!m.objName.equalsIgnoreCase("eye")) continue;
                    m.xRotation = rotationEye = Math.toDegrees(headPitch / 57.295776f);
                }
                this.dalekSteampunk.render();
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.1f, (float)0.0f, (float)0.0f);
                this.renderArm(dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                Graphics.bindTexture(dalek.getDalekData().getTexture());
                this.renderBase(dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.renderGun(dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.renderDome(dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
            }
        }
        super.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    public void renderArm(EntityDalek dalek, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelMDL model = dalek.getDalekData().getModel((Entity)dalek).getModelArm(dalek);
        if (model != null) {
            double[] offset = dalek.getDalekData().getModel((Entity)dalek).getModelArm((EntityDalek)dalek).getModelData().animation_rotation_offset;
            double[] positionOffset = dalek.getDalekData().getModel((Entity)dalek).getModelArm((EntityDalek)dalek).getModelData().animation_position_offset;
            GlStateManager.func_179137_b((double)(-positionOffset[0]), (double)(-positionOffset[1]), (double)(-positionOffset[2]));
            GlStateManager.func_179137_b((double)(-offset[0]), (double)offset[1], (double)offset[2]);
            GlStateManager.func_179137_b((double)offset[0], (double)(-offset[1]), (double)(-offset[2]));
            model.func_78088_a((Entity)dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179137_b((double)positionOffset[0], (double)positionOffset[1], (double)positionOffset[2]);
        }
    }

    public void renderBase(EntityDalek dalek, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelMDL model = dalek.getDalekData().getModel((Entity)dalek).getModelBase(dalek);
        if (model != null) {
            model.func_78088_a((Entity)dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public void renderDome(EntityDalek dalek, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelMDL model = dalek.getDalekData().getModel((Entity)dalek).getModelHeadDome(dalek);
        if (model != null) {
            double[] offset = dalek.getDalekData().getModel((Entity)dalek).getModelHeadDome((EntityDalek)dalek).getModelData().animation_rotation_offset;
            double[] positionOffset = dalek.getDalekData().getModel((Entity)dalek).getModelHeadDome((EntityDalek)dalek).getModelData().animation_position_offset;
            double rotation = Math.toDegrees(netHeadYaw / 57.295776f);
            GlStateManager.func_179137_b((double)(-positionOffset[0]), (double)(-positionOffset[1]), (double)(-positionOffset[2]));
            GlStateManager.func_179137_b((double)(-offset[0]), (double)offset[1], (double)offset[2]);
            GlStateManager.func_179114_b((float)((float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)offset[0], (double)(-offset[1]), (double)(-offset[2]));
            model.func_78088_a((Entity)dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            this.renderEyestalk(dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179137_b((double)positionOffset[0], (double)positionOffset[1], (double)positionOffset[2]);
            dalek.getDalekData().getModel((Entity)dalek).renderDomeExtra(dalek);
        }
    }

    public void renderGun(EntityDalek dalek, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelMDL model = dalek.getDalekData().getModel((Entity)dalek).getModelGun(dalek);
        if (model != null) {
            GlStateManager.func_179094_E();
            double[] offset = dalek.getDalekData().getModel((Entity)dalek).getModelGun((EntityDalek)dalek).getModelData().animation_rotation_offset;
            double[] positionOffset = dalek.getDalekData().getModel((Entity)dalek).getModelGun((EntityDalek)dalek).getModelData().animation_position_offset;
            GlStateManager.func_179137_b((double)(-positionOffset[0]), (double)(-positionOffset[1]), (double)(-positionOffset[2]));
            GlStateManager.func_179137_b((double)(-offset[0]), (double)offset[1], (double)offset[2]);
            GlStateManager.func_179137_b((double)offset[0], (double)(-offset[1]), (double)(-offset[2]));
            model.func_78088_a((Entity)dalek, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179137_b((double)positionOffset[0], (double)positionOffset[1], (double)positionOffset[2]);
            GlStateManager.func_179121_F();
        }
    }

    public void renderEyestalk(EntityDalek dalek, float par2, float par3, float par4, float par5, float par6, float par7) {
        ModelMDL model = dalek.getDalekData().getModel((Entity)dalek).getModelEyestalk(dalek);
        if (model != null) {
            double[] offset = dalek.getDalekData().getModel((Entity)dalek).getModelEyestalk((EntityDalek)dalek).getModelData().animation_rotation_offset;
            double[] positionOffset = dalek.getDalekData().getModel((Entity)dalek).getModelEyestalk((EntityDalek)dalek).getModelData().animation_position_offset;
            double rotationEye = Math.toDegrees(par6 / 57.295776f);
            GlStateManager.func_179137_b((double)(-positionOffset[0]), (double)(-positionOffset[1]), (double)(-positionOffset[2]));
            GlStateManager.func_179137_b((double)(-offset[0]), (double)(-offset[1]), (double)(-offset[2]));
            GlStateManager.func_179114_b((float)((float)rotationEye), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)offset[0], (double)offset[1], (double)offset[2]);
            model.func_78088_a((Entity)dalek, par2, par3, par4, par5, par6, par7);
            GlStateManager.func_179137_b((double)positionOffset[0], (double)positionOffset[1], (double)positionOffset[2]);
        }
    }
}

