/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl;

import com.google.gson.Gson;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLData;
import com.swdteam.mdl.obj.Model;
import com.swdteam.mdl.obj.OBJLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class MDLLoader {
    public static Gson GSON = new Gson();

    public static MDL loadMDL(ResourceLocation location) throws Exception {
        InputStream inputstream = null;
        BufferedReader reader = null;
        try {
            inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
            MDL model = new MDL();
            HashMap<String, Model> models = new HashMap<String, Model>();
            HashMap<String, BufferedImage> textures = new HashMap<String, BufferedImage>();
            ZipInputStream stream = new ZipInputStream(inputstream);
            ZipEntry e = null;
            MDLData mdld = null;
            while ((e = stream.getNextEntry()) != null) {
                if (e.getName().equalsIgnoreCase("data_mdl.json")) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    mdld = (MDLData)GSON.fromJson(sb.toString(), MDLData.class);
                    if (mdld == null) {
                        reader.close();
                        throw new Exception("MDL Data is missing...");
                    }
                }
                if (e.getName().toUpperCase().endsWith(".OBJ")) {
                    Model obj = OBJLoader.INSTANCE.loadModel(stream);
                    obj.objName = e.getName().substring(0, e.getName().length() - 4);
                    models.put(obj.objName, obj);
                }
                if (!e.getName().toUpperCase().endsWith(".PNG")) continue;
                BufferedImage image = ImageIO.read(stream);
                textures.put(e.getName().substring(0, e.getName().length() - 4), image);
            }
            if (mdld != null && mdld.object_data != null) {
                MDLData.ObjectData data;
                ArrayList<BufferedImage> img = new ArrayList<BufferedImage>();
                ArrayList<Model> mdls = new ArrayList<Model>();
                int i = 0;
                while (i < mdld.textures.length) {
                    if (textures.containsKey(mdld.textures[i])) {
                        img.add((BufferedImage)textures.get(mdld.textures[i]));
                    }
                    ++i;
                }
                i = 0;
                while (i < mdld.object_data.length) {
                    data = mdld.object_data[i];
                    if (models.containsKey(data.name)) {
                        Model obj = (Model)models.get(data.name);
                        if (data.name.equalsIgnoreCase(obj.objName)) {
                            obj.textureIndex = data.texture_index;
                            obj.xOffset = data.xOffset;
                            obj.yOffset = data.yOffset;
                            obj.zOffset = data.zOffset;
                            obj.xTransform = data.xTransform;
                            obj.yTransform = data.yTransform;
                            obj.zTransform = data.zTransform;
                            mdls.add(obj);
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < mdld.object_data.length) {
                    data = mdld.object_data[i];
                    if (models.containsKey(data.name)) {
                        int j = 0;
                        while (j < data.children.length) {
                            if (models.containsKey(data.children[j])) {
                                ((Model)models.get((Object)data.name)).children.add((Model)models.get(data.children[j]));
                                ((Model)models.get((Object)data.children[j])).isChild = true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                model.setTextures(img.toArray(new BufferedImage[img.size()]));
                model.setModels(mdls.toArray(new Model[mdls.size()]));
                MDL mDL = model;
                return mDL;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputstream != null) {
                inputstream.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return null;
    }
}

