/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldUtils {
    @SideOnly(value=Side.CLIENT)
    static float partialTicks;

    public static boolean setBlockFast(World world, BlockPos pos, IBlockState state, int flags) {
        if (world.func_189509_E(pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IBlockState iblockstate = chunk.func_177436_a(pos = pos.func_185334_h(), state);
        if (iblockstate == null) {
            return false;
        }
        world.markAndNotifyBlock(pos, chunk, iblockstate, state, flags);
        return true;
    }

    public static void setBlock(World world, int x, int y, int z, Block b) {
        world.func_175656_a(new BlockPos(x, y, z), b.func_176223_P());
    }

    @SideOnly(value=Side.CLIENT)
    public static void setPartialTicks(float partialTicks) {
        WorldUtils.partialTicks = partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getPartialTicks() {
        return partialTicks;
    }

    public static List<Block> getBlocksWithinAxisAlignedBB(World w, AxisAlignedBB box) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    blocks.add(w.func_180495_p(new BlockPos(x, y, z)).func_177230_c());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z) {
        return world.func_175625_s(new BlockPos(x, y, z));
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    public static boolean blockExists(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150350_a;
    }

    public static BlockPos vec3ToBlockPos(Vector3 v) {
        return new BlockPos(v.getX(), v.getY(), v.getZ());
    }

    public static Vector3 blockPosToVec3(BlockPos v) {
        return new Vector3(v.func_177958_n(), v.func_177956_o(), v.func_177952_p());
    }

    public static List<Block> getBlocksForLandingWithinBounds(World w, AxisAlignedBB box) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    IBlockState blockState = w.func_180495_p(new BlockPos(x, y, z));
                    Block b = blockState.func_177230_c();
                    if (b != Blocks.field_150350_a && b.func_149688_o(blockState) != Material.field_151585_k && b.func_149688_o(blockState) != Material.field_151582_l && b.func_149688_o(blockState) != Material.field_151597_y) {
                        blocks.add(b);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static List<BlockWithPos> getBlocksWithinBounds(World w, AxisAlignedBB box) {
        ArrayList<BlockWithPos> blocks = new ArrayList<BlockWithPos>();
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block b = w.func_180495_p(pos).func_177230_c();
                    blocks.add(new BlockWithPos(b, pos));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), world.func_180495_p(pos), world.func_180495_p(pos), 1);
    }

    @Deprecated
    public static void playSoundByEntity(Entity entity, SoundEvent sound, SoundCategory cat) {
        WorldUtils.playSoundByEntity(entity, sound, cat, 1.0f, 1.0f);
    }

    @Deprecated
    public static void playSoundByEntity(Entity entity, SoundEvent sound, SoundCategory cat, float volume, float pitch) {
        entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, SoundCategory.AMBIENT, volume, pitch, false);
    }

    public static boolean isInWorldBorderBounds(Vector3 vec3, World world) {
        WorldBorder border = world.func_175723_af();
        return (double)vec3.x < border.func_177728_d() && (double)vec3.x > border.func_177726_b() && (double)vec3.z < border.func_177733_e() && (double)vec3.z > border.func_177736_c();
    }

    public static boolean isInWorldBounds(Vector3 vec) {
        return vec.x > -29000000 && vec.x < 29000000 && vec.y < 255 && vec.y > 0 && vec.z > -29000000 && vec.z < 29000000;
    }

    public static EnumActionResult summonTardisToPos(World w, TardisData data, BlockPos p, float rotation) {
        BlockPos oldPos;
        if (w.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
            return EnumActionResult.FAIL;
        }
        BlockPos summonTo = p;
        if (data == null) {
            return EnumActionResult.FAIL;
        }
        WorldServer server = w.func_73046_m().func_71218_a(data.getTardisCurrentdimension());
        TileEntity te = server.func_175625_s(oldPos = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition()));
        if (!(te instanceof TileEntityTardis)) {
            List<BlockWithPos> blocks = WorldUtils.getBlocksWithinBounds((World)server, new AxisAlignedBB(oldPos).func_186662_g(5.0));
            for (BlockWithPos bwp : blocks) {
                if (bwp == null || bwp.b != DMBlocks.TARDIS) continue;
                TileEntityTardis tet = (TileEntityTardis)server.func_175625_s(bwp.p);
                if (tet.tardisID != data.getTardisID()) continue;
                te = tet;
                break;
            }
        }
        if (te instanceof TileEntityTardis) {
            ((TileEntityTardis)te).setDemat(true);
            ((TileEntityTardis)te).sendUpdates();
        }
        w.func_175656_a(summonTo, DMBlocks.TARDIS.func_176223_P());
        TileEntity te1 = w.func_175625_s(summonTo);
        if (te1 instanceof TileEntityTardis && te1 != null) {
            TileEntityTardis tet2 = (TileEntityTardis)te1;
            tet2.rotation = rotation;
            tet2.tardisID = data.getTardisID();
            tet2.setRemat(true);
            data.setCurrentLocationName(server.func_73046_m().func_71218_a((int)data.getTardisCurrentdimension()).field_73011_w.func_186058_p().func_186065_b());
            data.setTardisCurrentDimensionLocation(w.field_73011_w.getDimension());
            data.setInFlight(false);
            data.setCurrentLocationName(w.func_73046_m().func_71218_a((int)w.field_73011_w.getDimension()).field_73011_w.func_186058_p().func_186065_b());
            data.setTravelRotation(rotation);
            data.setCurrentTardisPosition(MathUtils.blockPosToVec3(summonTo));
            TardisSaveHandler.saveTardis(data);
            tet2.tempTardisData = data;
            tet2.func_189515_b(new NBTTagCompound());
            tet2.sendUpdates();
            List players = w.func_72872_a(EntityPlayer.class, new AxisAlignedBB(summonTo).func_186662_g(50.0));
            for (Object player1 : players) {
                if (!(player1 instanceof EntityPlayer)) continue;
                DMTardis.loadClientData(data.getTardisID(), (EntityPlayerMP)player1);
            }
            WorldUtils.markBlockForUpdate(w, summonTo);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static class BlockWithPos {
        private BlockPos p;
        private Block b;

        public BlockWithPos(Block b, BlockPos p) {
            this.setBlock(b);
            this.setBlockPos(p);
        }

        public Block getBlock() {
            return this.b;
        }

        public BlockPos getBlockPos() {
            return this.p;
        }

        public void setBlock(Block b) {
            this.b = b;
        }

        public void setBlockPos(BlockPos p) {
            this.p = p;
        }
    }
}

