/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMMDLLoader;
import com.swdteam.client.model.ModelCube;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLLoader;
import com.swdteam.mdl.ModelMDL;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.model.techne.TechneModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;

public class DMTCNModelLoader {
    public static TechneModel defaultModel;
    public static int defaultTexture;
    private static boolean defTex;
    private static HashMap<String, ModelBase> models;

    public static void initModels() {
        File[] listOfFiles;
        File folder;
        if (!defTex) {
            BufferedImage im = new BufferedImage(64, 64, 10);
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    im.setRGB(i, j, 0);
                }
            }
            im.getGraphics().drawString("Missing", 11, 28);
            im.getGraphics().drawString("Model", 13, 41);
            defaultTexture = Graphics.loadTexture(im);
            defaultTexture = Graphics.loadTexture(im);
            defTex = true;
        }
        if (defaultModel == null) {
            defaultModel = new ModelCube();
        }
        if (!(folder = new File(Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/Models")).exists()) {
            folder.mkdirs();
        }
        for (File listOfFile : listOfFiles = folder.listFiles()) {
            FileInputStream is;
            if (!listOfFile.isFile()) continue;
            if (listOfFile.getName().endsWith(".tcn")) {
                is = null;
                try {
                    is = new FileInputStream(listOfFile.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (is != null) {
                    if (!models.containsKey(listOfFile.getName())) {
                        DMTCNModelLoader.addModel(listOfFile.getName(), new TechneModel(is));
                    }
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (!listOfFile.getName().endsWith(".mdl")) continue;
            is = null;
            try {
                is = new FileInputStream(listOfFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (is == null) continue;
            if (!models.containsKey(listOfFile.getName())) {
                ModelBase mdl = DMMDLLoader.loadModel(is, true);
                if (mdl == null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        is = new FileInputStream(listOfFile.getAbsolutePath());
                        MDL m = MDLLoader.loadMDL(is);
                        mdl = new ModelMDL(m);
                        System.out.println(m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (mdl != null) {
                    DMTCNModelLoader.addModel(listOfFile.getName(), mdl);
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HashMap<String, ModelBase> getModels() {
        return models;
    }

    public static void addModel(String name, ModelBase b) {
        if (!models.containsKey(name)) {
            models.put(name, b);
        }
    }

    public static ModelBase getModel(String name) {
        if (models.containsKey(name)) {
            return models.get(name);
        }
        return defaultModel;
    }

    @Deprecated
    public static int loadTexture(BufferedImage image) {
        return Graphics.loadTexture(image);
    }

    static {
        models = new HashMap();
    }
}

