/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal;

import com.swdteam.client.worldportal.BlockData;
import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketWorldPortal;
import com.swdteam.common.tileentity.TileEntityGallifreyFallsPainting;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Graphics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class WorldPortal {
    public static HashMap<Integer, CustomWorldClient> clients = new HashMap();
    public static HashMap<BlockPos, BufferBuilder.State> worldrenders = new HashMap();
    public static int RELOAD = 500;

    @SideOnly(value=Side.CLIENT)
    public static void render(IWorldPortal world, Vec3d renderPos, float rot) {
        if (DMConfig.clientSide.renderBoti && world != null) {
            WorldClient worldClient;
            if (clients.containsKey(world.getDimension()) && (worldClient = (WorldClient)clients.get(world.getDimension())) != null && worldClient.field_73011_w != null && worldClient.field_73011_w.getSkyRenderer() != null) {
                worldClient.field_73011_w.getSkyRenderer().render(Minecraft.func_71410_x().func_184121_ak(), worldClient, Minecraft.func_71410_x());
            }
            if (world.getWorldRender().blocks != null) {
                BlockPos offset = world.getWorldRender().renderPos;
                int rotate = 0;
                if (Math.abs(rot) < 45.0f) {
                    rotate = 0;
                }
                if (Math.abs(rot - 90.0f) < 45.0f) {
                    rotate = 90;
                }
                if (Math.abs(rot - 180.0f) < 45.0f) {
                    rotate = 180;
                }
                if (Math.abs(rot - 270.0f) < 45.0f) {
                    rotate = 270;
                }
                if (Math.abs(rot - 360.0f) < 45.0f) {
                    rotate = 0;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
                GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                GlStateManager.func_179137_b((double)(renderPos.field_72450_a - (double)offset.func_177958_n()), (double)(renderPos.field_72448_b - (double)offset.func_177956_o()), (double)(renderPos.field_72449_c - (double)offset.func_177952_p()));
                GlStateManager.func_179137_b((double)(-renderPos.field_72450_a), (double)(-renderPos.field_72448_b), (double)(-renderPos.field_72449_c));
                WorldPortal.renderBlocks(world);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlocks(IWorldPortal portal) {
        WorldRender world = portal.getWorldRender();
        if (RELOAD < 500) {
            ++RELOAD;
        } else {
            RELOAD = 0;
            worldrenders.remove(world.renderPos);
        }
        if (!worldrenders.containsKey(world.renderPos) && worldrenders.get(world.renderPos) == null) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179094_E();
            for (Map.Entry<BlockPos, BlockData> list : world.blocks.entrySet()) {
                IBlockState block = list.getValue().state;
                BlockPos blockPos = list.getKey();
                if (blockPos == null || block == null || blockPos.func_177986_g() == portal.getPosToRender().func_177986_g()) continue;
                Graphics.bindTexture(TextureMap.field_110575_b);
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)world.customWorld, vertexBuffer);
            }
            worldrenders.put(world.renderPos, vertexBuffer.func_181672_a());
            tessellator.func_78381_a();
            if (clients.containsKey(portal.getDimension())) {
                WorldPortal.renderTiles(portal, clients.get(portal.getDimension()));
            }
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glShadeModel((int)7425);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Graphics.bindTexture(TextureMap.field_110575_b);
            vertexBuffer.func_178993_a(worldrenders.get(world.renderPos));
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        if (clients.containsKey(portal.getDimension())) {
            WorldPortal.renderTiles(portal, clients.get(portal.getDimension()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTiles(IWorldPortal portal, WorldClient client) {
        GlStateManager.func_179094_E();
        Graphics.bindTexture(TextureMap.field_110575_b);
        GL11.glEnable((int)3042);
        for (TileEntity tileEntity : portal.getWorldRender().tileEntities) {
            if (tileEntity == null || tileEntity instanceof TileEntityBeacon || tileEntity instanceof TileEntityGallifreyFallsPainting || tileEntity.func_174877_v().func_177986_g() == portal.getPosToRender().func_177986_g()) continue;
            try {
                tileEntity.func_145834_a((World)client);
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tileEntity, (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), Minecraft.func_71410_x().func_184121_ak());
            }
            catch (Exception exception) {
                // empty catch block
            }
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
    }

    public static void renderEntities(WorldRender world, BlockPos p) {
        List<Entity> entities = world.entities;
        for (Entity e : entities) {
            if (e == null) continue;
            float x1 = (float)e.field_70165_t - (float)p.func_177958_n();
            float y1 = (float)e.field_70163_u - (float)p.func_177956_o();
            float z1 = (float)e.field_70161_v - (float)p.func_177952_p();
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(e, (double)(-x1), (double)(0.0f - y1), (double)(-z1 + 2.0f), 0.0f, Minecraft.func_71410_x().func_184121_ak(), false);
        }
    }

    public static void getWorldRender(World world, WorldRender worlds, BlockPos posToRender, int dimensiontorender, BlockPos pos, float rot) {
        if (world.func_82737_E() % 5L == 0L && !world.field_72995_K) {
            worlds = new WorldRender(posToRender);
            WorldServer renderworld = world.func_73046_m().func_71218_a(dimensiontorender);
            int x = 0;
            int z = 0;
            int xi = 0;
            int zi = 0;
            int r = DMConfig.tardis.blockMapSize;
            int rotate = 0;
            if (Math.abs(rot) < 45.0f) {
                rotate = 0;
            }
            if (Math.abs(rot - 90.0f) < 45.0f) {
                rotate = 90;
            }
            if (Math.abs(rot - 180.0f) < 45.0f) {
                rotate = 180;
            }
            if (Math.abs(rot - 270.0f) < 45.0f) {
                rotate = 270;
            }
            if (Math.abs(rot - 360.0f) < 45.0f) {
                rotate = 0;
            }
            if (rotate == 0) {
                x = -1;
                z = 0;
                xi = 1;
                zi = 1;
            }
            if (rotate == 90) {
                x = -1;
                z = -1;
                xi = 0;
                zi = 1;
            }
            if (rotate == 180) {
                x = -1;
                z = 0;
                xi = 1;
                zi = -1;
            }
            if (rotate == 270) {
                x = 0;
                z = -1;
                xi = 1;
                zi = 1;
            }
            for (BlockPos p : BlockPos.func_177980_a((BlockPos)worlds.renderPos.func_177971_a(new Vec3i(x * r, -10, z * r)), (BlockPos)worlds.renderPos.func_177971_a(new Vec3i(xi * r, 15, zi * r)))) {
                BlockData bl = new BlockData(renderworld.func_180495_p(p), renderworld.func_175625_s(p), renderworld.func_175699_k(p));
                if (bl.state.func_177230_c() == Blocks.field_150350_a) continue;
                worlds.blocks.put(p, bl);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketWorldPortal(worlds, pos, dimensiontorender), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
        }
    }

    public static void getEntities(WorldRender worlds, World renderworld) {
        if (renderworld.func_72964_e(worlds.renderPos.func_177958_n(), worlds.renderPos.func_177952_p()).func_177410_o()) {
            AxisAlignedBB bb = new AxisAlignedBB(worlds.renderPos.func_177982_a(-10, -10, -10), worlds.renderPos.func_177982_a(10, 10, 10));
            worlds.setEntities(renderworld.func_72872_a(Entity.class, bb));
        }
    }
}

