/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tardis.data.chameleon;

import com.swdteam.client.model.tardis.ModelTardisBase;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSchematics;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.InteriorSounds;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.IChameleonCircuit;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.math.MathUtils;
import com.swdteam.utils.world.SchematicUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ChameleonCircuitBase
implements IChameleonCircuit {
    private int id;
    @SideOnly(value=Side.CLIENT)
    public static ModelTardisBase DEFAULT_MODEL;
    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation DEFAULT_TEXTURE;
    @SideOnly(value=Side.CLIENT)
    private ModelTardisBase model;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation texture;

    public ChameleonCircuitBase() {
        this.setId(DMTardis.getNextFreeTardisChameleonID());
    }

    @SideOnly(value=Side.CLIENT)
    public ModelTardisBase getModel() {
        if (this.model == null) {
            return DEFAULT_MODEL;
        }
        return this.model;
    }

    @Override
    public float maxDoorRotation() {
        return 1.0f;
    }

    @Override
    public float doorOpenSpeed() {
        return 0.045f;
    }

    @Override
    public float doorCloseSpeed() {
        return 0.25f;
    }

    public int getID() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    @Override
    public SoundEvent doorSound(DoorState state) {
        if (state == DoorState.OPEN) {
            return DMSounds.tardisDoorOpen;
        }
        return DMSounds.tardisDoorShut;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            return DEFAULT_TEXTURE;
        }
        return this.texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void setModel(ModelTardisBase model) {
        this.model = model;
    }

    @SideOnly(value=Side.CLIENT)
    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public void onRightClick(World world, EntityPlayer player, BlockPos pos, TileEntityTardis te, boolean overridePerms) {
        if (!world.field_72995_K && world.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID && te instanceof TileEntityTardis) {
            TileEntityTardis tardis = te;
            if (tardis.tardisID == 0) {
                tardis.tardisID = DMTardis.addTardis(this.getID());
            } else if (!DMTardis.doesTardisExist(tardis.tardisID)) {
                tardis.tardisID = DMTardis.addTardis(this.getID());
            }
            TardisData data = tardis.tempTardisData;
            if (data == null) {
                data = tardis.tempTardisData = DMTardis.getTardis(tardis.tardisID);
            }
            if (data != null) {
                if (data.getCurrentOwner() == null) {
                    if (data.getOwner() != null && data.getOwner().equals(player.func_70005_c_())) {
                        data.setCurrentOwner(player.func_110124_au());
                        data.setOwner(player.func_70005_c_());
                    } else if (data.getOwner() == null || data.getOwner().length() < 1) {
                        data.setCurrentOwner(player.func_110124_au());
                        data.setOwner(player.func_70005_c_());
                    }
                }
                if (data.getCurrentOwner() != null && data.getCurrentOwner().equals(player.func_110124_au())) {
                    data.setOwner(player.func_70005_c_());
                }
                if (!overridePerms && !DMTardis.hasPermission(data, player)) {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "You do not have permission to enter, this TARDIS belongs to " + TextFormatting.YELLOW + data.getOwner());
                    return;
                }
                if (this.hasDoorRotation()) {
                    if (data.isDoorOpen()) {
                        data.setDoorOpen(false);
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new Packet_TardisDoors(pos, false), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 50.0));
                        DMSounds.playSound(player, this.doorSound(DoorState.CLOSED), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                    } else {
                        data.setDoorOpen(true);
                        try {
                            DMSounds.playSound(player, this.doorSound(DoorState.OPEN), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                            PacketHandler.INSTANCE.sendToAllAround((IMessage)new Packet_TardisDoors(pos, false), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 50.0));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                tardis.tempTardisData = data;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawCustomSignText(float scale, float maxWidth, float height, float depth, String text) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSignText(float height, float depth) {
    }

    public void handleEnter(World worldIn, BlockPos pos, TileEntityTardis tardis, Entity entity) {
        if (!worldIn.field_72995_K) {
            EntityPlayer player;
            TardisData data;
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            if (entity.func_184207_aI()) {
                entity.func_184226_ay();
            }
            if ((data = tardis.tempTardisData) == null) {
                data = tardis.tempTardisData = DMTardis.getTardis(tardis.tardisID);
            }
            if (data == null) {
                return;
            }
            String dimName = worldIn.field_73011_w.func_186058_p().func_186065_b();
            data.setCurrentLocationName(dimName);
            data.setCurrentLocationName(dimName);
            data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos));
            data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos));
            data.setTardisCurrentDimensionLocation(worldIn.field_73011_w.getDimension());
            data.setDoorOpen(false);
            TardisSaveHandler.saveTardis(data);
            boolean inFlight = false;
            if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).hasCapability(CapabilityTardis.FLIGHTMODE_CAP, null)) {
                ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                if (!capa.getInFlight()) {
                    capa.setTARDISID(data.getTardisID());
                    capa.syncToPlayer();
                } else {
                    inFlight = true;
                }
                SoundEvent doorSound = this.doorSound(DoorState.CLOSED);
                if (doorSound != null) {
                    DMSounds.playSound((EntityPlayer)((EntityPlayerMP)entity), this.doorSound(DoorState.CLOSED), SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                }
            }
            if (!inFlight) {
                ChameleonCircuitBase skin = data.getTardisSkin();
                TeleportUtils.teleportToDimension(entity, DMDimensions.DIM_TARDIS_ID, (double)data.getTardisInteriorDoorLocation().x, (double)data.getTardisInteriorDoorLocation().y, (double)data.getTardisInteriorDoorLocation().z, data.getSpawnFacing(), 0.0f);
                PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(pos, false), data.getTardisCurrentdimension());
            }
        }
    }

    public void generateInterior(World w, BlockPos p) {
        SchematicUtils.generateSchematic(w, p, DMSchematics.TARDIS_DEFAULT);
    }

    public Vector3 getSpawnOffsetPosition() {
        return new Vector3(13, 67, 6);
    }

    public float getDefaultSpawnRotation() {
        return 0.0f;
    }

    @Override
    public float modelGUIScale() {
        return 1.0f;
    }

    @Override
    public float modelGUIYOffset() {
        return 0.0f;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB(-0.5, 0.0, -0.5, 1.5, 4.0, 1.5);
    }

    public int getHumId() {
        return InteriorSounds.InteriorSoundHelper.getHumId(InteriorSounds.DEFAULT);
    }

    @Override
    public String getItemExtraInfo() {
        return null;
    }

    @Override
    public boolean hasBoti() {
        return false;
    }

    public static enum DoorState {
        OPEN,
        CLOSED;

    }
}

