/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl;

import com.swdteam.mdl.IPortalSetup;
import com.swdteam.mdl.graphics.Graphics;
import com.swdteam.mdl.obj.Model;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MDL {
    public static IPortalSetup portalSetup;
    public static DynamicTexture lightmapTexture;
    public static ResourceLocation locationLightMap;
    private Model[] models;
    public int[] displayLists;
    public BufferedImage[] textureFile;
    public int[] textures;
    public boolean[] loadingTextures;

    static {
        lightmapTexture = new DynamicTexture(16, 16);
    }

    public MDL() {
        if (locationLightMap == null) {
            locationLightMap = Minecraft.func_71410_x().func_110434_K().func_110578_a("lightMap", lightmapTexture);
        }
    }

    public void setModels(Model[] models) {
        this.models = models;
        this.displayLists = new int[models.length];
        int i = 0;
        while (i < models.length) {
            this.displayLists[i] = -1;
            ++i;
        }
    }

    public void setTextures(BufferedImage[] imgs) {
        this.textureFile = imgs;
        this.textures = new int[imgs.length];
        this.loadingTextures = new boolean[imgs.length];
        int i = 0;
        while (i < imgs.length) {
            this.textures[i] = -1;
            this.loadingTextures[i] = false;
            ++i;
        }
    }

    public void render(Model part) {
        if (part == null) {
            return;
        }
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
        if (this.models != null) {
            int previousTexture = GL11.glGetInteger((int)32873);
            part.renderAll(this);
            Graphics.bindTexture(previousTexture);
        }
        GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)0.0);
        GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public void render() {
        if (this.models != null) {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            int previousTexture = GL11.glGetInteger((int)32873);
            Model[] modelArray = this.models;
            int n = this.models.length;
            int n2 = 0;
            while (n2 < n) {
                Model m1 = modelArray[n2];
                if (!m1.isChild && !m1.hidden) {
                    m1.renderAll(this);
                }
                ++n2;
            }
            Graphics.bindTexture(previousTexture);
            GL11.glRotatef((float)180.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
        }
    }

    public Model getPart(String s) {
        Model[] modelArray = this.getModels();
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Model m1 = modelArray[n2];
            if (m1.objName.equalsIgnoreCase(s)) {
                return m1;
            }
            ++n2;
        }
        return null;
    }

    public int createDisplayList(Model model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        model.render(this);
        GL11.glEndList();
        return displayList;
    }

    public Model[] getModels() {
        return this.models;
    }

    public void enableLightmap() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        float f = 0.00390625f;
        GlStateManager.func_179152_a((float)0.00390625f, (float)0.00390625f, (float)0.00390625f);
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)8.0f);
        GlStateManager.func_179128_n((int)5888);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(locationLightMap);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void disableLightmap() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void enableBlendingAndLightmap() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    public static void definePortal() {
        if (portalSetup != null) {
            portalSetup.definePortal();
        }
    }

    public static void openPortal() {
        if (portalSetup != null) {
            portalSetup.openPortal();
        }
    }

    public static void preOverlay() {
        if (portalSetup != null) {
            portalSetup.predrawOverlay();
        }
    }

    public static void closePortal() {
        if (portalSetup != null) {
            portalSetup.closePortal();
        }
    }
}

