/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMMDLLoader;
import com.swdteam.client.model.ModelCube;
import com.swdteam.common.tileentity.TileEntityTCNLoader;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLLoader;
import com.swdteam.mdl.ModelMDL;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.model.techne.TechneModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;

public class DMTCNModelLoader {
    public static TechneModel defaultModel;
    public static int defaultTexture;
    private static boolean defTex;
    private static HashMap<String, ModelBase> models;
    private static HashMap<String, ModelBase> cdnModels;

    public static void initModels(TileEntityTCNLoader.ModelPath path) {
        File[] listOfFiles;
        File folder;
        if (!defTex) {
            BufferedImage im = new BufferedImage(64, 64, 10);
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    im.setRGB(i, j, 0);
                }
            }
            im.getGraphics().drawString("Missing", 11, 28);
            im.getGraphics().drawString("Model", 13, 41);
            defaultTexture = Graphics.loadTexture(im);
            defaultTexture = Graphics.loadTexture(im);
            defTex = true;
        }
        if (defaultModel == null) {
            defaultModel = new ModelCube();
        }
        String folderPath = Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/Models";
        if (path == TileEntityTCNLoader.ModelPath.CDN) {
            folderPath = Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/CDN/model_loader";
        }
        if (!(folder = new File(folderPath)).exists()) {
            folder.mkdirs();
        }
        for (File listOfFile : listOfFiles = folder.listFiles()) {
            FileInputStream is;
            if (!listOfFile.isFile()) continue;
            if (listOfFile.getName().endsWith(".tcn")) {
                is = null;
                try {
                    is = new FileInputStream(listOfFile.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (is != null) {
                    if (!models.containsKey(listOfFile.getName())) {
                        DMTCNModelLoader.addModel(listOfFile.getName(), new TechneModel(is), path);
                    }
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (!listOfFile.getName().endsWith(".mdl")) continue;
            is = null;
            try {
                is = new FileInputStream(listOfFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (is == null) continue;
            if (!models.containsKey(listOfFile.getName())) {
                ModelBase mdl = DMMDLLoader.loadModel(is, true);
                if (mdl == null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        is = new FileInputStream(listOfFile.getAbsolutePath());
                        MDL m = MDLLoader.loadMDL(is);
                        mdl = new ModelMDL(m);
                        System.out.println(m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (mdl != null) {
                    DMTCNModelLoader.addModel(listOfFile.getName(), mdl, path);
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HashMap<String, ModelBase> getModels(TileEntityTCNLoader.ModelPath path) {
        if (path == TileEntityTCNLoader.ModelPath.MODELS) {
            return models;
        }
        return cdnModels;
    }

    public static void addModel(String name, ModelBase b, TileEntityTCNLoader.ModelPath path) {
        if (path == TileEntityTCNLoader.ModelPath.MODELS) {
            if (!models.containsKey(name)) {
                models.put(name, b);
            }
        } else if (!cdnModels.containsKey(name)) {
            cdnModels.put(name, b);
        }
    }

    public static ModelBase getModel(String name, TileEntityTCNLoader.ModelPath path) {
        if (path == TileEntityTCNLoader.ModelPath.MODELS) {
            if (models.containsKey(name)) {
                return models.get(name);
            }
        } else if (cdnModels.containsKey(name)) {
            return cdnModels.get(name);
        }
        return defaultModel;
    }

    @Deprecated
    public static int loadTexture(BufferedImage image) {
        return Graphics.loadTexture(image);
    }

    static {
        models = new HashMap();
        cdnModels = new HashMap();
    }
}

