/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockData {
    public IBlockState state;
    public int lightLevel;
    public TileEntity tileEntity;

    public BlockData() {
    }

    public BlockData(IBlockState state, TileEntity tileEntity, int lightLevel) {
        this.setState(state);
        this.setTileEntity(tileEntity);
        this.setLightLevel(lightLevel);
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }

    public void setTileEntity(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void setState(IBlockState state) {
        this.state = state;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public IBlockState getState() {
        return this.state;
    }

    public void toBuffer(ByteBuf buff) {
        buff.writeInt(Block.func_176210_f((IBlockState)this.state));
        ByteBufUtils.writeTag((ByteBuf)buff, this.tileEntity != null ? this.tileEntity.serializeNBT() : null);
        buff.writeInt(this.lightLevel);
    }

    @SideOnly(value=Side.CLIENT)
    public void fromBuffer(ByteBuf buff) {
        this.state = Block.func_176220_d((int)buff.readInt());
        NBTTagCompound tagCompound = ByteBufUtils.readTag((ByteBuf)buff);
        if (tagCompound != null) {
            this.tileEntity = TileEntity.func_190200_a((World)Minecraft.func_71410_x().field_71441_e, (NBTTagCompound)tagCompound);
        }
        this.lightLevel = buff.readInt();
    }
}

