/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.dmapi;

import com.swdteam.client.render.gui.planets.IRenderPlanet;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.planets.IPlanet;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class APIPlanets {
    private String planet_name;
    private int planet_id;

    public String getPlanetName() {
        return this.planet_name;
    }

    public int getPlanetID() {
        return this.planet_id;
    }

    public static void addExternalPlanet() {
        File[] files;
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath();
        File f = new File(fileDir + "/mods/Dalek Mod/API/Planets");
        if (!f.exists()) {
            f.mkdirs();
        }
        for (File file : files = f.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            File p = file;
            final APIPlanets data = (APIPlanets)FileUtils.loadObjectFromFile(p, APIPlanets.class);
            TheDalekMod.LOG.info("Added Planet: " + data.getPlanetName() + " from file: " + p.getName());
            DMDimensions.addPlanet(data.getPlanetID(), new IPlanet(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public IRenderPlanet getPlanetRenderer() {
                    return null;
                }

                @Override
                public String getPlanetName() {
                    return data.getPlanetName();
                }
            });
        }
    }

    public static void addExternalPlanets() {
        Integer[] r = DimensionManager.getStaticDimensionIDs();
        try {
            for (int i = 0; i < r.length; ++i) {
                final String name = DimensionManager.createProviderFor((int)r[i]).func_186058_p().func_186065_b();
                for (String s : DMConfig.tardis.blockedDimensions) {
                    if (name.equalsIgnoreCase(s) || name.equals(DMDimensions.DIM_TARDIS.func_186065_b())) continue;
                    if (name.equalsIgnoreCase("mars") && !TheDalekMod.canAdventBeUnlocked(6)) {
                        return;
                    }
                    int id = DimensionManager.createProviderFor((int)r[i]).func_186058_p().func_186068_a();
                    if (DMDimensions.getPlanets().containsKey(id) || APIPlanets.getBlockedDimensions().contains(id)) continue;
                    DMDimensions.addPlanet(id, new IPlanet(){

                        @Override
                        public String getPlanetName() {
                            return name;
                        }

                        @Override
                        public IRenderPlanet getPlanetRenderer() {
                            return null;
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<Integer> getBlockedDimensions() {
        ArrayList<Integer> blocked = new ArrayList<Integer>();
        blocked.add(DMDimensions.DIM_TARDIS_ID);
        return blocked;
    }
}

