/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.main;

import com.swdteam.advent.IAdvent;
import com.swdteam.api.main.API;
import com.swdteam.api.main.Credentials;
import com.swdteam.api.main.ILoginPost;
import com.swdteam.api.main.Main;
import com.swdteam.api.main.Utils;
import com.swdteam.client.command.CommandAddFez;
import com.swdteam.client.command.CommandClearCache;
import com.swdteam.client.command.CommandReloadResources;
import com.swdteam.client.data.FezData;
import com.swdteam.client.events.GuiEventHandler;
import com.swdteam.client.events.RenderEdEventHandler;
import com.swdteam.client.events.RenderWorldEvents;
import com.swdteam.client.events.TickHandler;
import com.swdteam.client.events.WorldLoad;
import com.swdteam.client.init.DMDalekRenderRegistry;
import com.swdteam.client.init.DMEntityRendererReg;
import com.swdteam.client.init.DMFontRenderer;
import com.swdteam.client.init.DMGameOverlays;
import com.swdteam.client.init.DMHatModels;
import com.swdteam.client.init.DMKeybinds;
import com.swdteam.client.init.DMRenderLayers;
import com.swdteam.client.init.DMSkinpacks;
import com.swdteam.client.init.DMSplashHandler;
import com.swdteam.client.init.DMTCNModelLoader;
import com.swdteam.client.init.DMTardisSkinRenderReg;
import com.swdteam.client.init.DMTextures;
import com.swdteam.client.init.DMTileEntityRegistry;
import com.swdteam.client.init.DMTitleBackgrounds;
import com.swdteam.client.worldportal.PortalSetup;
import com.swdteam.common.block.BlockDMMetadata;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.item.IItemMeta;
import com.swdteam.common.item.IItemMetaSingleTex;
import com.swdteam.common.item.IMetaItemWithTextures;
import com.swdteam.common.regeneration.RegenerationEventHandler;
import com.swdteam.common.tileentity.TileEntityTCNLoader;
import com.swdteam.main.CommonProxy;
import com.swdteam.main.DMCDN;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Sphere;

public class ClientProxy
extends CommonProxy {
    public static Sphere s = new Sphere();

    @Override
    public void cdnSetup() {
        super.cdnSetup();
        DMCDN.init(DMCDN.CDNSide.CLIENT);
    }

    public void setUpMusicTypes() {
    }

    public static void registerItemRenderers() {
        for (int i = 0; i < DMItems.DM_ITEMS.size(); ++i) {
            ModelResourceLocation mrl;
            int id;
            Object im;
            Item item = DMItems.DM_ITEMS.get(i);
            if (item instanceof IAdvent && !TheDalekMod.canAdventBeUnlocked(((IAdvent)item).getDay())) continue;
            if (item instanceof IItemMeta) {
                im = (IItemMeta)item;
                for (id = 0; id < im.getMetaSize(); ++id) {
                    mrl = new ModelResourceLocation("thedalekmod:" + item.func_77658_a().substring(5), "inventory");
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)id, (ModelResourceLocation)mrl);
                }
                continue;
            }
            if (item instanceof IMetaItemWithTextures) {
                im = (IMetaItemWithTextures)item;
                for (id = 0; id < im.getMetaSize(); ++id) {
                    mrl = new ModelResourceLocation("thedalekmod:" + im.textureLocationAndName() + id);
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mrl});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)id, (ModelResourceLocation)mrl);
                }
                continue;
            }
            if (item instanceof IItemMetaSingleTex) {
                im = (IItemMetaSingleTex)item;
                for (id = 0; id < im.getMetaSize(); ++id) {
                    mrl = new ModelResourceLocation("thedalekmod:" + item.func_77658_a().substring(5), "inventory");
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)mrl);
                }
                continue;
            }
            ModelResourceLocation mrl2 = new ModelResourceLocation("thedalekmod:" + item.func_77658_a().substring(5), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl2);
        }
    }

    public static void registerBlockItemRenderers() throws IllegalAccessException {
        for (Field f : DMBlocks.class.getDeclaredFields()) {
            Block b = (Block)f.get(null);
            if (b instanceof IAdvent && !TheDalekMod.canAdventBeUnlocked(((IAdvent)b).getDay())) continue;
            Item item = Item.func_150898_a((Block)b);
            if (!(b instanceof BlockDMMetadata)) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("thedalekmod:" + b.func_149739_a().substring(5), "inventory"));
                continue;
            }
            for (int id = 0; id < ((BlockDMMetadata)b).subBlockNum; ++id) {
                ModelResourceLocation mrl = new ModelResourceLocation("thedalekmod:metablock/" + ((BlockDMMetadata)b).path + b.func_149739_a().substring(5) + "_" + (id + 1), "inventory");
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mrl});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)id, (ModelResourceLocation)mrl);
            }
        }
        DMTileEntityRegistry.init();
    }

    private void registerReloadable() {
        DMTextures.init();
        DMDalekRenderRegistry.init();
        DMTitleBackgrounds.init();
        DMSplashHandler.init();
        DMHatModels.init();
        DMEntityRendererReg.init();
        DMSkinpacks.init();
        DMTileEntityRegistry.init();
        DMTCNModelLoader.initModels(TileEntityTCNLoader.ModelPath.MODELS);
        DMTCNModelLoader.initModels(TileEntityTCNLoader.ModelPath.CDN);
        DMTardisSkinRenderReg.setUp();
    }

    @Override
    public void init() {
        PortalSetup.init();
        this.setUpMusicTypes();
        DMItems.registerItemColors();
        DMKeybinds.init();
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a(resourceManager -> this.registerReloadable());
        }
        DMTCNModelLoader.initModels(TileEntityTCNLoader.ModelPath.MODELS);
        DMTCNModelLoader.initModels(TileEntityTCNLoader.ModelPath.CDN);
        super.init();
        DMRenderLayers.init();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderInformation() {
        DMGameOverlays.init();
        MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldLoad());
        MinecraftForge.EVENT_BUS.register((Object)new RenderWorldEvents());
        MinecraftForge.EVENT_BUS.register((Object)new RegenerationEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEdEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEdEventHandler());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandClearCache());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandReloadResources());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAddFez());
        FezData.init();
    }

    @Override
    public void postInit() {
    }

    private int bindTexture(String path) {
        try {
            ZipFile fis = new ZipFile(path);
            ZipEntry entry = fis.getEntry("texture.png");
            InputStream in = fis.getInputStream(entry);
            BufferedImage image = ImageIO.read(in);
            fis.close();
            in.close();
            return Graphics.loadTexture(image);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public void preInit() {
        Credentials c;
        super.preInit();
        DMFontRenderer.init();
        if (API.getInstance() == null && (c = Utils.getCredentials()) != null) {
            Main.login(new API(API.APIType.LOGIN_WITH_UPDATE, new ILoginPost(){

                @Override
                public void onUpdateThreadStart() {
                }

                @Override
                public void onThreadTick() {
                }

                @Override
                public void onFail() {
                }

                @Override
                public boolean onLoginComplete(Map<String, String> arg0) {
                    return true;
                }
            }, "Dalek Mod (Update 52.0.0)"), c);
        }
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    public String getDatasDirectory() {
        return Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/";
    }

    @Override
    public File getModDataDirectory() {
        String fileDir = Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
        File f = new File(fileDir + "/mods/Dalek Mod/");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }
}

