/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.main;

import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.IOUtils;
import java.io.File;
import org.apache.logging.log4j.Level;

public class DMCDN {
    public static void init(CDNSide side) {
        System.out.println("Setting up CDN: " + (Object)((Object)side));
        String json = IOUtils.getRawJsonFromURL("http://cdn.dalekmod.com/files.php");
        if (json != null) {
            CDN cdn = new CDN();
            cdn.files = (CDNFile[])TheDalekMod.GSON.fromJson(json, CDNFile[].class);
            if (cdn != null && cdn.files != null) {
                for (int i = 0; i < cdn.files.length; ++i) {
                    File f;
                    CDNFile file = cdn.files[i];
                    if (side == CDNSide.BOTH && file.side_required == CDNSide.BOTH) {
                        f = new File("mods/Dalek Mod/cdn/" + file.file_name);
                        if ((!f.exists() || f.length() == file.file_size) && f.exists()) continue;
                        IOUtils.tryDownloadFile("http://cdn.dalekmod.com/files/" + file.file_name, f.getAbsolutePath());
                        TheDalekMod.LOG.log(Level.INFO, "Server: Downloading: " + file.file_name);
                        continue;
                    }
                    if (side != CDNSide.CLIENT || file.side_required != CDNSide.CLIENT) continue;
                    TheDalekMod.LOG.log(Level.INFO, "Client: Downloading: " + file.file_name);
                    f = new File("mods/Dalek Mod/cdn/" + file.file_name);
                    if ((!f.exists() || f.length() == file.file_size) && f.exists()) continue;
                    IOUtils.tryDownloadFile("http://cdn.dalekmod.com/files/" + file.file_name, f.getAbsolutePath());
                    TheDalekMod.LOG.log(Level.INFO, "Server: Downloading: " + file.file_name);
                }
            }
        }
    }

    public static enum CDNSide {
        CLIENT,
        BOTH;

    }

    public static class CDNFile {
        public int id;
        public String file_name;
        public CDNSide side_required;
        public long file_size;
    }

    public static class CDN {
        public CDNFile[] files;
    }
}

