/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity.dalek;

import com.swdteam.client.resources.IResourceLoader;
import com.swdteam.common.entity.EntityLaser;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.entity.dalek.IDalek;
import com.swdteam.common.init.DMDamageSources;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLLoader;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;

public abstract class DalekBase
implements IDalek,
IResourceLoader {
    private int dalekID;
    private String dalekName;
    private String modelPath;
    private MDL dalekModel;
    public SoundEvent[] attackSounds = new SoundEvent[0];
    public SoundEvent[] shootSounds = new SoundEvent[0];
    public SoundEvent[] attackedSounds = new SoundEvent[0];
    public SoundEvent[] spawnSounds = new SoundEvent[0];
    public SoundEvent[] deathSounds = new SoundEvent[0];
    public SoundEvent[] livingSounds = new SoundEvent[0];
    public SoundEvent[] hurtSounds = new SoundEvent[0];
    private boolean isDead = false;

    public DalekBase(String dalekName) {
        this.dalekName = dalekName;
    }

    @Override
    public void setupDalek(Entity e) {
        if (e.field_70170_p.field_73012_v.nextInt(5) == 3) {
            this.playSound((EntityDalek)e, this.getSpawnSound(e));
        }
    }

    @Override
    public void initAI(EntityAITasks e) {
    }

    @Override
    public void onUpdate(Entity e) {
    }

    @Override
    public void onDeath(Entity e) {
    }

    @Override
    public void onAttacked(Entity dalek, Entity attacker, DamageSource damage) {
        if (dalek.field_70170_p.field_73012_v.nextInt(5) == 3) {
            this.playSound((EntityDalek)dalek, this.getAttackedSound(dalek));
        }
    }

    @Override
    public void onLaserAttack(EntityDalek dalek, EntityLivingBase living, float par2) {
        if (living.field_70128_L) {
            return;
        }
        if (dalek.field_70170_p.field_73012_v.nextInt(5) == 2) {
            dalek.func_184185_a(this.getAttackSound((Entity)dalek), 1.0f, 1.0f);
        }
        EntityLaser laser = new EntityLaser(dalek.field_70170_p, (EntityLivingBase)dalek, EnumParticleTypes.REDSTONE);
        laser.setDamageSource(DMDamageSources.EXTERMINATED);
        laser.setDamage(5.0f);
        double d0 = living.field_70165_t - dalek.field_70165_t;
        double d1 = living.func_174813_aQ().field_72338_b + (double)(living.field_70131_O / 3.0f) - laser.field_70163_u;
        double d2 = living.field_70161_v - dalek.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        laser.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
        laser.setLaser(dalek.getDalekData().getLaser());
        dalek.field_70170_p.func_72838_d((Entity)laser);
        dalek.func_184185_a(this.getShootSound((Entity)dalek), 1.0f, 1.0f);
    }

    @Override
    public String getName() {
        return this.dalekName;
    }

    public static SoundEvent getRandomSound(Entity e, SoundEvent[] s) {
        if (e != null && s != null && s.length != 0) {
            return s[e.field_70170_p.field_73012_v.nextInt(s.length)];
        }
        return null;
    }

    @Override
    public SoundEvent getHurtSound(Entity e) {
        return DalekBase.getRandomSound(e, this.hurtSounds);
    }

    @Override
    public SoundEvent getLivingSound(Entity e) {
        return DalekBase.getRandomSound(e, this.livingSounds);
    }

    @Override
    public SoundEvent getDeathSound(Entity e) {
        return DalekBase.getRandomSound(e, this.deathSounds);
    }

    @Override
    public SoundEvent getSpawnSound(Entity e) {
        return DalekBase.getRandomSound(e, this.spawnSounds);
    }

    @Override
    public SoundEvent getAttackSound(Entity e) {
        return DalekBase.getRandomSound(e, this.attackSounds);
    }

    @Override
    public SoundEvent getAttackedSound(Entity e) {
        return DalekBase.getRandomSound(e, this.attackedSounds);
    }

    @Override
    public SoundEvent getShootSound(Entity e) {
        return DalekBase.getRandomSound(e, this.shootSounds);
    }

    @Override
    public void setDead(boolean dead) {
        this.isDead = dead;
    }

    @Override
    public boolean isDead() {
        return this.isDead;
    }

    public void setAttackedSounds(SoundEvent[] attackedSounds) {
        this.attackedSounds = attackedSounds;
    }

    public void setAttackSounds(SoundEvent[] attackSounds) {
        this.attackSounds = attackSounds;
    }

    public void setDeathSounds(SoundEvent[] deathSounds) {
        this.deathSounds = deathSounds;
    }

    public void setHurtSounds(SoundEvent[] hurtSounds) {
        this.hurtSounds = hurtSounds;
    }

    public void setLivingSounds(SoundEvent[] livingSounds) {
        this.livingSounds = livingSounds;
    }

    public void setShootSounds(SoundEvent[] shootSounds) {
        this.shootSounds = shootSounds;
    }

    public void setSpawnSounds(SoundEvent[] spawnSounds) {
        this.spawnSounds = spawnSounds;
    }

    public void playSound(EntityDalek w, SoundEvent s) {
        if (s != null) {
            w.func_184185_a(s, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean shouldReload() {
        return true;
    }

    @Override
    public MDL getModel(Entity e) {
        return this.dalekModel;
    }

    @Override
    public void setModel(String m) {
        try {
            this.dalekModel = MDLLoader.loadMDL(new ResourceLocation("thedalekmod", "models/mdl/entity/daleks/" + m + ".mdl"));
            this.modelPath = m;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadResource() {
        this.setModel(this.modelPath);
    }

    @Override
    public double getMoveSpeed() {
        return 0.8;
    }

    @Override
    public double getMaxHealth() {
        return 50.0;
    }

    @Override
    public int getID() {
        return this.dalekID;
    }

    @Override
    public void setID(int id) {
        this.dalekID = id;
    }
}

