/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.google.gson.reflect.TypeToken;
import com.swdteam.common.data.WaypointData;
import com.swdteam.main.TheDalekMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class DMWaypoints {
    public static Type TYPE_TOKEN = new TypeToken<List<WaypointData>>(){}.getType();

    public static String getWaypointsAsJSON(int tardisID, int offset) {
        ArrayList<WaypointData> wpData = new ArrayList<WaypointData>();
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File[] files = f.listFiles();
        Arrays.sort(files, (f1, f2) -> Long.valueOf(f2.lastModified()).compareTo(f1.lastModified()));
        int startOffset = offset * 8;
        if (offset * 8 < files.length) {
            for (int i = offset * 8; i < offset * 8 + 8 && i < files.length; ++i) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(files[i]));
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                    WaypointData data = (WaypointData)TheDalekMod.GSON.fromJson(sb.toString(), WaypointData.class);
                    data.setWaypointFileName(files[i].getName());
                    wpData.add(data);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return TheDalekMod.GSON.toJson(wpData, TYPE_TOKEN);
    }

    public static void editWaypoint(int tardisID, String name, String newWPName) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File f1 = new File(f.getAbsolutePath() + "/" + name);
        WaypointData data = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(f1));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            data = (WaypointData)TheDalekMod.GSON.fromJson(sb.toString(), WaypointData.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (data != null) {
            data.setWaypointName(newWPName);
        }
        DMWaypoints.saveWaypoint(tardisID, data, name);
    }

    public static void deleteWaypoint(int tardisID, String name) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        File f1 = new File(f.getAbsolutePath() + "/" + name);
        f1.delete();
    }

    public static int getTotalWaypoints(int tardisID) {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        TheDalekMod.LOG.info("[Dalek Mod] TOTAL: " + f.listFiles().length);
        return f.listFiles().length;
    }

    public static void saveWaypoint(int tardisID, WaypointData data, String fileName) {
        if (fileName == null) {
            fileName = "wp_" + System.currentTimeMillis() / 100L + ".json";
        }
        if (data.getWaypointName() == null || data.getWaypointName() != null && data.getWaypointName().length() < 1) {
            return;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + TheDalekMod.FML.getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Waypoints/Tardis_" + tardisID + "/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(new File(f.getAbsolutePath() + "/" + fileName));
            writer.write(TheDalekMod.GSON.toJson((Object)data));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveVMWaypoint(String useruuid, String filename, WaypointData data) {
    }
}

