/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.regeneration;

import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.capability.CapabilityRegeneration;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.IRegenerationCapability;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.CapabilityUtils;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class RegenerationHandler {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(CapabilityRegeneration.REGEN_CAP, null)) {
            return;
        }
        event.addCapability(FileUtils.newResourceLocation("thedalekmod:regeneration"), (ICapabilityProvider)new CapabilityRegeneration.CapabilityTimelordProvider((EntityPlayer)event.getObject()));
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        RegenerationHandler.get(event.getEntityPlayer()).syncToPlayer();
    }

    @Nonnull
    public static IRegenerationCapability get(EntityPlayer player) {
        if (player.hasCapability(CapabilityRegeneration.REGEN_CAP, null)) {
            return (IRegenerationCapability)player.getCapability(CapabilityRegeneration.REGEN_CAP, null);
        }
        throw new IllegalStateException("Regeneration Capability Missing");
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage iStorage = CapabilityRegeneration.REGEN_CAP.getStorage();
        IRegenerationCapability old = RegenerationHandler.get(event.getOriginal());
        IRegenerationCapability newCap = RegenerationHandler.get(event.getEntityPlayer());
        NBTTagCompound nbt = (NBTTagCompound)iStorage.writeNBT(CapabilityRegeneration.REGEN_CAP, (Object)old, null);
        iStorage.readNBT(CapabilityRegeneration.REGEN_CAP, (Object)newCap, null, (NBTBase)nbt);
        RegenerationHandler.get(event.getEntityPlayer()).syncToPlayer();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RegenerationHandler.get(event.player).syncToPlayer();
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        RegenerationHandler.get(event.player).syncToPlayer();
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            int arrowCount = player.func_85035_bI();
            if (capability.getPreRegenTicks() > 0) {
                capability.setPreRegen(true);
                capability.setPreRegenTicks(0);
            }
            if (capability.getPreRegenTicks() == 0 && capability.isPreRegen()) {
                capability.setPreRegen(false);
                capability.setTicksExisted(1);
                capability.syncToPlayer();
            }
            if (capability.getTicksExisted() > 0) {
                if (player.field_70163_u >= 0.0) {
                    if (capability.getTicksExisted() == 1) {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.Regeneration, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_184224_h(true);
                        player.func_146105_b((ITextComponent)new TextComponentString("You've now regenerated " + (12 - capability.getRegenAmount() + 1) + " times, you have " + (capability.getRegenAmount() - 1) + " regenerations left."), true);
                        ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
                        TardisData data = DMTardis.getTardis(capa.getTARDISID());
                        RegenerationHandler.tardisCrash(data, (EntityPlayer)player, capa);
                    }
                    capability.setTicksExisted(capability.getTicksExisted() + 1);
                    arrowCount = player.func_85035_bI();
                    capability.syncToPlayer();
                    if (!player.field_70170_p.field_72995_K && capability.getTicksExisted() > 100 && DMConfig.regeneration.Explosions && DMUtils.RANDOM.nextInt(5) <= 2) {
                        player.func_70066_B();
                        if (player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() instanceof BlockFire) {
                            player.field_70170_p.func_175698_g(player.func_180425_c());
                        }
                        double x = player.field_70165_t + player.func_70681_au().nextGaussian() * 2.0;
                        double y = player.field_70163_u + 0.5 + player.func_70681_au().nextGaussian() * 2.0;
                        double z = player.field_70161_v + player.func_70681_au().nextGaussian() * 2.0;
                        player.field_70170_p.func_72885_a((Entity)player, x, y, z, 0.0f, player.func_70011_f(x, y, z) >= 4.0, false);
                    }
                }
                if (capability.getTicksExisted() >= 200) {
                    capability.setTicksExisted(0);
                    player.func_70606_j(player.func_110138_aP());
                    player.func_85034_r(0);
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, (double)(player.func_180425_c().func_177958_n() + DMUtils.RANDOM.nextInt(3)), (double)player.func_180425_c().func_177956_o(), (double)(player.func_180425_c().func_177952_p() + DMUtils.RANDOM.nextInt(3)), new ItemStack(Items.field_185166_h, arrowCount, 0)));
                    player.func_70674_bp();
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 3600, 3, false, false));
                    capability.setRegenCount(capability.getRegenAmount() - 1);
                    capability.syncToPlayer();
                    player.func_184224_h(false);
                }
            }
            if (capability.getPostRegenTicks() > 0) {
                capability.setPostRegen(true);
                RegenerationHandler.postRegen((EntityPlayer)player, capability);
                capability.setPostRegenTicks(capability.getPostRegenTicks() + 1);
                capability.syncToPlayer();
                if (capability.getPostRegenTicks() == 600) {
                    capability.setPostRegen(false);
                    capability.setPostRegenTicks(0);
                    capability.syncToPlayer();
                }
            }
        }
    }

    private static void tardisCrash(TardisData data, EntityPlayer player, ITardisCapability cap) {
        if (player.field_70170_p.field_73011_w instanceof WorldProviderTardis) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DMSounds.CloisterBell, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (data != null && data.isInFlight()) {
                data.setTardisCurrentDimensionLocation(DMUtils.RANDOM.nextInt(DimensionManager.getStaticDimensionIDs().length));
                if (data.getTardisCurrentdimension() == DMDimensions.DIM_TARDIS_ID || !DimensionManager.isDimensionRegistered((int)data.getTardisCurrentdimension())) {
                    data.setTardisCurrentDimensionLocation(0);
                }
                Vector3 vec = new Vector3(DMUtils.RANDOM.nextInt(player.func_130014_f_().func_175723_af().func_177722_l()), DMUtils.RANDOM.nextInt(100), DMUtils.RANDOM.nextInt(player.func_130014_f_().func_175723_af().func_177722_l()));
                data.setTravelToLocation(vec);
                ActionList.tardisDematRemat(player.field_70170_p, player.func_180425_c(), player, true);
                PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.RED + "Your Tardis is crash landing!");
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), DMSounds.tardis_out_of_bounds, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    private static void preRegen(EntityPlayer p, IRegenerationCapability cap) {
    }

    private static void postRegen(EntityPlayer p, IRegenerationCapability cap) {
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if ((event.getSource().func_94541_c() || event.getSource().func_76347_k()) && capability.getTicksExisted() >= 100) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate((EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            capability.setPreRegen(false);
            capability.setPreRegenTicks(0);
            capability.setTicksExisted(0);
            capability.syncToPlayer();
        }
    }

    @SubscribeEvent
    public static void playerPoseFix(PlayerInteractEvent.RightClickBlock e) {
        if (CapabilityUtils.isRegenerating(e.getEntityPlayer()) || CapabilityUtils.isInFlight(e.getEntityPlayer())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.canRegenerate(player = (EntityPlayer)event.getEntity())) {
            IRegenerationCapability capability = (IRegenerationCapability)event.getEntity().getCapability(CapabilityRegeneration.REGEN_CAP, null);
            if (player.func_110143_aJ() - event.getAmount() <= 0.0f) {
                if (capability.getRegenAmount() > 0 && capability.getTicksExisted() == 0 && capability.getPreRegenTicks() == 0) {
                    event.setCanceled(true);
                    player.func_70606_j(1.5f);
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)10), 200, 1, false, false));
                    if (capability.getPreRegenTicks() == 0 && capability.getTicksExisted() == 0) {
                        capability.setPreRegenTicks(100);
                    }
                } else if (capability.getRegenAmount() == 0 && capability.canPlayerRegenerate()) {
                    capability.setCanRegen(false);
                }
            }
            capability.syncToPlayer();
        }
    }
}

