/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.google.gson.reflect.TypeToken;
import com.swdteam.client.init.DMSWDTeamAccount;
import com.swdteam.main.TheDalekMod;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

public class IOUtils {
    public static int webTime = -1;

    public static File tryDownloadFile(String url, String location) {
        try {
            FileUtils.copyURLToFile((URL)new URL(url), (File)new File(location));
            return new File(location);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bufferedReaderToString(BufferedReader e) {
        StringBuilder builder = new StringBuilder();
        String aux = "";
        try {
            while ((aux = e.readLine()) != null) {
                builder.append(aux);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return builder.toString();
    }

    public static String getJsonFromURL(String URL2) {
        URL url = null;
        try {
            url = new URL(URL2);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = IOUtils.bufferedReaderToString(in);
            line = line.replace("<pre>", "");
            line = line.replace("</pre>", "");
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRawJsonFromURL(String URL2) {
        URL url = null;
        try {
            url = new URL(URL2);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = IOUtils.bufferedReaderToString(in);
            return line;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getWebServerTime() {
        if (webTime < 0) {
            try {
                URL url = new URL("http://api.swdteam.com/util/getUnixTimestamp.php");
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                String line = in.readLine();
                line = line.replace("<pre>", "");
                line = line.replace("</pre>", "");
                webTime = Integer.parseInt(line);
                return webTime;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return webTime;
        }
        webTime = -1;
        return -1;
    }

    public static boolean checkServerState(String s) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(s);
        }
        catch (UnknownHostException e) {
            return false;
        }
        try {
            return address.isReachable(3000);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean sendHTTPRequest(String s) {
        try {
            new URL(s).openStream();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void navigateToURL(String string) {
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void downloadProfileImage(String user) {
        new Thread(() -> {
            try {
                DMSWDTeamAccount.USER_IMAGE = ImageIO.read(new URL("http://swdteam.com/img/uploads/" + user + ".png"));
                TheDalekMod.LOG.info("Downloading Profile: " + user);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (DMSWDTeamAccount.USER_IMAGE == null) {
                try {
                    DMSWDTeamAccount.USER_IMAGE = ImageIO.read(new URL("http://swdteam.com/img/Default.png"));
                    TheDalekMod.LOG.info("[Dalek Mod] Downloading Default Profile: " + user);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileSizeURL(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            int n = conn.getContentLength();
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDataFromURL(String filename, String urlString) throws IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(new URL(urlString).openStream());
            fout = new FileOutputStream(filename);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public static void writeObjectToFile(Object object, String filePath) {
        File f = new File(filePath.substring(0, filePath.lastIndexOf("/")));
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            System.out.println(filePath);
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(TheDalekMod.GSON.toJson(object));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object loadObjectFromFile(String filePath, Class c) {
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            Object o = TheDalekMod.GSON.fromJson(sb.toString(), c);
            return o;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<?> listFromJson(String json) {
        return (List)TheDalekMod.GSON.fromJson(json, new TypeToken<List<?>>(){}.getType());
    }
}

