/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal;

import com.swdteam.client.worldportal.BlockData;
import com.swdteam.client.worldportal.CustomWorld;
import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketWorldPortal;
import com.swdteam.common.tileentity.TileEntityGallifreyFallsPainting;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.utils.Graphics;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class WorldPortal {
    public static HashMap<Integer, CustomWorldClient> clients = new HashMap();
    public static HashMap<Long, BufferBuilder.State> worldrenders = new HashMap();
    public static CustomWorld customWorld = new CustomWorld();
    public static int RELOAD = 500;

    @SideOnly(value=Side.CLIENT)
    public static void render(IWorldPortal world, Vec3d renderPos, float rot) {
        if (DMConfig.clientSide.renderBoti) {
            if (world != null) {
                GlStateManager.func_179094_E();
                GL11.glShadeModel((int)7425);
                if (clients.containsKey(world.getWorldRender().getDimension())) {
                    WorldClient worldClient = clients.get(world.getWorldRender().getDimension());
                    if (worldClient != null && worldClient.field_73011_w != null && worldClient.field_73011_w.getSkyRenderer() != null) {
                        worldClient.field_73011_w.getSkyRenderer().render(Minecraft.func_71410_x().func_184121_ak(), worldClient, Minecraft.func_71410_x());
                    }
                } else {
                    world.getWorldRender().renderPos = BlockPos.field_177992_a;
                }
                if (world.getWorldRender().blocks != null) {
                    Framebuffer old = Minecraft.func_71410_x().func_147110_a();
                    GlStateManager.func_179094_E();
                    GL11.glShadeModel((int)7425);
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
                    GlStateManager.func_179114_b((float)((int)rot), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                    GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
                    BlockPos offset = world.getWorldRender().renderPos;
                    GlStateManager.func_179137_b((double)(renderPos.field_72450_a - (double)offset.func_177958_n()), (double)(renderPos.field_72448_b - (double)offset.func_177956_o()), (double)(renderPos.field_72449_c - (double)offset.func_177952_p()));
                    GlStateManager.func_179137_b((double)(-renderPos.field_72450_a), (double)(-renderPos.field_72448_b), (double)(-renderPos.field_72449_c));
                    WorldPortal.renderBlocks(world);
                    old.func_147610_a(true);
                    GlStateManager.func_179121_F();
                } else {
                    world.requestRender();
                }
            } else {
                world.requestRender();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static boolean isInFrontOfPortal(BlockPos blockPos, BlockPos portalPos) {
        Vec3d block = new Vec3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        Vec3d portal = new Vec3d((double)portalPos.func_177958_n(), (double)portalPos.func_177956_o(), (double)portalPos.func_177952_p());
        Vec3d pl = Minecraft.func_71410_x().field_71439_g.func_70040_Z();
        return block.func_178788_d(portal).func_72430_b(new Vec3d(-pl.field_72450_a, -pl.field_72448_b, -pl.field_72449_c)) > -0.5;
    }

    public static void drawOutline(Vec3d s) {
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)((float)Color.BLACK.getRed() / 255.0f), (float)((float)Color.BLACK.getGreen() / 255.0f), (float)((float)Color.BLACK.getBlue() / 255.0f), (float)((float)Color.BLACK.getAlpha() / 255.0f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(0.0, s.field_72448_b, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(s.field_72450_a, s.field_72448_b, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(s.field_72450_a, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlocks(IWorldPortal portal) {
        WorldRender world = portal.getWorldRender();
        if (RELOAD < 500) {
            ++RELOAD;
        } else {
            RELOAD = 0;
            worldrenders.clear();
        }
        if (!worldrenders.containsKey(world.identifier) && worldrenders.get(world.identifier) == null) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179094_E();
            for (Map.Entry<BlockPos, BlockData> list : world.blocks.entrySet()) {
                IBlockState block = list.getValue().state;
                BlockPos blockPos = list.getKey();
                if (blockPos == null || block == null || blockPos.func_177986_g() == portal.getWorldRender().getRenderPos().func_177986_g()) continue;
                if (block.func_185901_i() == EnumBlockRenderType.LIQUID) {
                    BlockFluidRenderer blockFluidRenderer = new BlockFluidRenderer(Minecraft.func_71410_x().func_184125_al());
                    blockFluidRenderer.func_178270_a((IBlockAccess)customWorld, block, blockPos, vertexBuffer);
                }
                Graphics.bindTexture(TextureMap.field_110575_b);
                Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, blockPos, (IBlockAccess)customWorld, vertexBuffer);
            }
            worldrenders.put(world.identifier, vertexBuffer.func_181672_a());
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            GL11.glShadeModel((int)7425);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Graphics.bindTexture(TextureMap.field_110575_b);
            vertexBuffer.func_178993_a(worldrenders.get(world.identifier));
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        if (clients.containsKey(portal.getDimension())) {
            WorldPortal.renderTiles(portal, clients.get(portal.getDimension()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTiles(IWorldPortal portal, WorldClient client) {
        GlStateManager.func_179094_E();
        Graphics.bindTexture(TextureMap.field_110575_b);
        GL11.glEnable((int)3042);
        for (TileEntity tileEntity : portal.getWorldRender().tileEntities) {
            if (tileEntity == null || tileEntity instanceof TileEntityBeacon || tileEntity instanceof TileEntityGallifreyFallsPainting || tileEntity.func_174877_v().func_177986_g() == portal.getPosToRender().func_177986_g()) continue;
            try {
                tileEntity.func_145834_a((World)client);
                TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity).func_192841_a(tileEntity, (double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p(), Minecraft.func_71410_x().func_184121_ak(), -100, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
    }

    public static void renderEntities(WorldRender world, BlockPos p) {
        List<Entity> entities = world.entities;
        for (Entity e : entities) {
            if (e == null) continue;
            float x1 = (float)e.field_70165_t - (float)p.func_177958_n();
            float y1 = (float)e.field_70163_u - (float)p.func_177956_o();
            float z1 = (float)e.field_70161_v - (float)p.func_177952_p();
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(e, (double)(-x1), (double)(0.0f - y1), (double)(-z1 + 2.0f), 0.0f, Minecraft.func_71410_x().func_184121_ak(), false);
        }
    }

    public static boolean shouldRenderPos(IWorldPortal portal, BlockPos pos) {
        return false;
    }

    public static void getWorldRender(World world, WorldRender worlds, BlockPos posToRender, int dimensiontorender, BlockPos pos, float rot, boolean boti) {
        WorldServer renderworld;
        if (world.func_82737_E() % 5L == 0L && !world.field_72995_K && DimensionManager.isDimensionRegistered((int)dimensiontorender) && (renderworld = world.func_73046_m().func_71218_a(dimensiontorender)) != null) {
            worlds = new WorldRender(posToRender);
            int r = boti ? DMConfig.tardis.blockMapSizeBoti : DMConfig.tardis.blockMapSizeSoto;
            worlds.setDimension(dimensiontorender);
            worlds.setIdentifier(System.currentTimeMillis());
            for (BlockPos p : BlockPos.func_177980_a((BlockPos)worlds.renderPos.func_177973_b(new Vec3i(r, 10, r)), (BlockPos)worlds.renderPos.func_177971_a(new Vec3i(r, 15, r)))) {
                double ba;
                BlockData bl = new BlockData(renderworld.func_180495_p(p), renderworld.func_175625_s(p), renderworld.func_175699_k(p));
                if (bl.state.func_177230_c() == Blocks.field_150350_a || bl.state.func_177230_c() == Blocks.field_180401_cv || !((ba = Math.cos(-((double)(rot + 90.0f) * 0.0174533) + Math.atan2(p.func_177952_p() - posToRender.func_177952_p(), p.func_177958_n() - posToRender.func_177958_n())) + (double)0.1f) > 0.0) && (p.func_177952_p() != posToRender.func_177952_p() || p.func_177958_n() != posToRender.func_177958_n())) continue;
                worlds.blocks.put(p, bl);
            }
            for (BlockPos p : BlockPos.func_177980_a((BlockPos)worlds.renderPos.func_177973_b(new Vec3i(1, 0, 1)), (BlockPos)worlds.renderPos.func_177971_a(new Vec3i(1, 1, 1)))) {
                worlds.blocks.remove(p);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketWorldPortal(worlds, pos, dimensiontorender), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
        }
    }

    public static void getEntities(WorldRender worlds, World renderworld) {
        if (renderworld.func_72964_e(worlds.renderPos.func_177958_n(), worlds.renderPos.func_177952_p()).func_177410_o()) {
            AxisAlignedBB bb = new AxisAlignedBB(worlds.renderPos.func_177982_a(-10, -10, -10), worlds.renderPos.func_177982_a(10, 10, 10));
            worlds.setEntities(renderworld.func_72872_a(Entity.class, bb));
        }
    }
}

