/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.worldportal.packet;

import com.swdteam.client.worldportal.BlockData;
import com.swdteam.client.worldportal.CustomWorldClient;
import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketWorldPortal
implements IMessage {
    public BlockPos pos;
    public WorldRender worldPortal;
    public int dim_render;

    public PacketWorldPortal() {
    }

    public PacketWorldPortal(WorldRender portal, BlockPos blockPos, int dim_render) {
        this.pos = blockPos;
        this.worldPortal = portal;
        this.dim_render = dim_render;
    }

    @SideOnly(value=Side.CLIENT)
    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.worldPortal = new WorldRender(this.pos);
        this.worldPortal.renderPos = BlockPos.func_177969_a((long)buf.readLong());
        int blocksize = buf.readInt();
        for (int i = 0; i < blocksize; ++i) {
            BlockPos blockPos = BlockPos.func_177969_a((long)buf.readLong());
            BlockData blockData = new BlockData();
            blockData.fromBuffer(buf);
            this.worldPortal.blocks.put(blockPos, blockData);
        }
        this.worldPortal.initTiles();
        int entitysize = buf.readInt();
        for (int i = 0; i < entitysize; ++i) {
            this.worldPortal.entities.add(EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)), (World)Minecraft.func_71410_x().field_71441_e));
        }
        this.dim_render = buf.readInt();
        this.worldPortal.setIdentifier(buf.readLong());
        this.worldPortal.setDimension(this.dim_render);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeLong(this.worldPortal.renderPos.func_177986_g());
        buf.writeInt(this.worldPortal.blocks.size());
        for (Map.Entry<BlockPos, BlockData> entry : this.worldPortal.blocks.entrySet()) {
            buf.writeLong(entry.getKey().func_177986_g());
            entry.getValue().toBuffer(buf);
        }
        buf.writeInt(this.worldPortal.entities.size());
        if (this.worldPortal.entities.size() > 0) {
            for (Entity e : this.worldPortal.entities) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)EntityList.func_191301_a((Entity)e).toString());
            }
        }
        buf.writeInt(this.dim_render);
        buf.writeLong(this.worldPortal.identifier);
    }

    public static class Handler
    implements IMessageHandler<PacketWorldPortal, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final PacketWorldPortal message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    TileEntity tileEntity = world.func_175625_s(message.pos);
                    if (tileEntity != null && tileEntity instanceof IWorldPortal) {
                        IWorldPortal worldPortal = (IWorldPortal)tileEntity;
                        if (!WorldPortal.clients.containsKey(worldPortal.getWorldRender().getDimension())) {
                            WorldPortal.clients.put(worldPortal.getWorldRender().getDimension(), new CustomWorldClient(Minecraft.func_71410_x().field_71441_e, worldPortal.getWorldRender().getDimension()));
                        }
                        worldPortal.setWorldRender(message.worldPortal);
                        tileEntity.func_70296_d();
                    }
                }
            });
            return null;
        }
    }
}

