/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.commands;

import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandTardisDoorPos
extends CommandTreeBase {
    public String func_71517_b() {
        return "tardis-interior-pos";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <x> <y> <z>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (player.field_70170_p.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.CANNOT_EXECUTE_IN_DIMENSION);
                return;
            }
            ITardisCapability capa = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            int tardisID = capa.getTARDISID();
            TardisData data = DMTardis.getTardis(tardisID);
            if (data != null) {
                if (data.getCurrentOwner() != null) {
                    if (!data.getCurrentOwner().equals(player.func_110124_au())) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.NOT_YOUR_TARDIS);
                        return;
                    }
                } else {
                    return;
                }
                if (args.length < 1) {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "You Tardis interior door is located at: " + data.getTardisInteriorDoorLocation().toString());
                } else if (args.length < 4) {
                    int x = data.getTardisInteriorDoorLocation().x;
                    int y = data.getTardisInteriorDoorLocation().y;
                    int z = data.getTardisInteriorDoorLocation().z;
                    float angle = player.func_70079_am();
                    try {
                        x = DMUtils.getPosFromArg(args[0], (int)player.field_70165_t - 1);
                        y = DMUtils.getPosFromArg(args[1], (int)player.field_70163_u);
                        z = DMUtils.getPosFromArg(args[2], (int)player.field_70161_v - 1);
                    }
                    catch (Exception e) {
                        PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
                        return;
                    }
                    data.setTardisInteriorDoorLocation(new Vector3(x, y, z));
                    data.setSpawnFacing(angle);
                    TardisSaveHandler.saveTardis(data);
                    WorldServer world = player.field_70170_p.func_73046_m().func_71218_a(data.getTardisCurrentdimension());
                    ((TileEntityTardis)world.func_175625_s((BlockPos)WorldUtils.vec3ToBlockPos((Vector3)data.getCurrentTardisPosition()))).tempTardisData = data;
                    PlayerUtils.Messaging.sendMessageToPlayer(player, TextFormatting.GREEN + "Tardis interior door position set to " + data.getTardisInteriorDoorLocation().toString());
                } else {
                    PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.INVALID_COMMAND_PARAMS);
                }
            } else {
                PlayerUtils.Messaging.sendMessageToPlayer(player, EnumDefaultResponse.TARDIS_DOES_NOT_EXIST);
            }
        }
    }
}

