/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.dimensions.world;

import com.swdteam.common.init.DMBiomes;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.planets.sky.SkyRendererSkaro;
import com.swdteam.common.planets.weather.IRain;
import com.swdteam.common.planets.weather.RainType;
import com.swdteam.common.world.gen.chunk.ChunkGeneratorSkaro;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderSkaro
extends WorldProvider
implements IRain {
    private static SkyRendererSkaro SKY = new SkyRendererSkaro();

    public WorldProviderSkaro() {
        this.field_76578_c = new BiomeProviderSingle(DMBiomes.BIOME_SKARO);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(-1.0, -1.0, -1.0);
    }

    public String getSaveFolder() {
        return "dm_skaro";
    }

    public IRenderHandler getSkyRenderer() {
        return SKY;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorSkaro(this.field_76579_a);
    }

    public DimensionType func_186058_p() {
        return DMDimensions.DIM_SKARO;
    }

    public boolean func_76566_a(int x, int z) {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int func_76557_i() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int par1, int par2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    protected void func_76556_a() {
        float f = 0.2f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 1.0f + 0.0f;
        }
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.0f;
    }

    public float getSunBrightness(float par1) {
        return 0.3f;
    }

    public float getSunBrightnessFactor(float par1) {
        return 0.0f;
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return DMBiomes.BIOME_SKARO;
    }

    public BiomeProvider func_177499_m() {
        return super.func_177499_m();
    }

    @Override
    public RainType getRainType() {
        return RainType.ACIDIC;
    }

    @Override
    public float getRainDamage() {
        return 0.5f;
    }

    @Nullable
    public IRenderHandler getCloudRenderer() {
        return new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        };
    }

    public float func_76571_f() {
        return -1.0f;
    }

    public boolean isDaytime() {
        return this.getWorldTime() > 1000L && this.getWorldTime() < 13000L;
    }

    public boolean func_76569_d() {
        return true;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }
}

