/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis;

import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketRequestBoti;
import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisData;
import com.swdteam.network.packets.Packet_SotoDoors;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.Vector2f;
import com.swdteam.utils.math.Vector3d;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityDoor
extends DMTileEntityBase
implements IWorldPortal,
ITickable {
    public TardisData tempTardisData;
    public int tardisID = 0;
    public float rot = 0.0f;
    public boolean open = false;
    public int open_tick = 0;
    public boolean sotoUpdate = false;
    public float maxRotation = 0.0f;
    public float rotationSpeedOpen = 0.0f;
    public float rotationSpeedClosed = 0.0f;
    public WorldRender worldRender = new WorldRender(this.func_174877_v());

    public void func_73660_a() {
        List entities;
        if (this.tempTardisData == null && this.tardisID != 0 || this.tempTardisData != null && this.tardisID != this.tempTardisData.getTardisID()) {
            this.tempTardisData = DMTardis.getTardis(this.tardisID);
        }
        this.keepUpdated();
        if (this.tempTardisData != null && !this.field_145850_b.field_72995_K && (this.tempTardisData.isInFlight() || this.tempTardisData.isInFlightMode())) {
            this.setOpen(false);
        }
        this.handleDoorRotations();
        if (this.open && !this.field_145850_b.field_72995_K) {
            ++this.open_tick;
            if (this.open_tick > 1800 && (entities = this.field_145850_b.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(10.0))).isEmpty()) {
                this.setOpen(false);
                this.open_tick = 0;
            }
        } else if (this.open_tick > 0) {
            this.open_tick = 0;
        }
        if (!this.field_145850_b.field_72995_K && DMConfig.tardis.isBotiEnabled && this.field_145850_b.field_73011_w instanceof WorldProviderTardis && this.sotoUpdate && this.open) {
            this.tempTardisData = DMTardis.getTardis(this.tardisID);
            if (this.tempTardisData != null) {
                WorldPortal.getWorldRender(this.field_145850_b, this.worldRender, this.getPosToRender(), this.getDimension(), this.func_174877_v(), this.tempTardisData.getTravelRotation() + 180.0f, false);
            }
        }
        this.setSotoUpdate(false);
        if (!(this.field_145850_b.field_72995_K || !this.open || this.tempTardisData == null || this.tempTardisData.isInFlightMode() || this.tempTardisData.isInFlight() || (entities = this.field_145850_b.func_72872_a(Entity.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(0.1))).isEmpty())) {
            if (entities.get(0) instanceof EntityPlayer) {
                ActionList.tardisDoorExit(this.field_145850_b, (EntityPlayer)entities.get(0));
            } else {
                Vector3d look = Vector3d.fromPitchYawVector(new Vector2f(45.0f, this.tempTardisData.getActualLandRotation() + 180.0f));
                float distance = 2.5f;
                double dx = (double)this.tempTardisData.getCurrentTardisPosition().getX() + look.x * (double)distance;
                double dy = this.tempTardisData.getCurrentTardisPosition().getY();
                double dz = (double)this.tempTardisData.getCurrentTardisPosition().getZ() + look.z * (double)distance;
                this.field_145850_b.func_73046_m().func_71218_a(this.getDimension()).func_72863_F().func_186028_c((int)dx, (int)dz);
                TeleportUtils.teleportToDimension((Entity)entities.get(0), this.getDimension(), dx, dy, dz, this.tempTardisData.getActualLandRotation(), ((Entity)entities.get((int)0)).field_70125_A);
            }
        }
    }

    public void handleInteract(EntityPlayer player) {
        ITardisCapability capability = (ITardisCapability)player.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
        if (capability != null && capability.getTARDISID() != this.tardisID) {
            this.tardisID = capability.getTARDISID();
            this.requestRender();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.tempTardisData != null) {
                if (this.tempTardisData.isInFlightMode() || this.tempTardisData.isInFlight()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't open the doors in flight!"));
                    return;
                }
                this.setOpen(!this.isOpen());
            }
            if (this.isOpen()) {
                this.requestRender();
                this.requestSoto();
            }
        }
    }

    public void requestSoto() {
        PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketRequestBoti(this.field_174879_c), this.func_145831_w().field_73011_w.getDimension());
    }

    public void keepUpdated() {
        if (this.field_145850_b != null && this.tardisID != 0) {
            if (this.field_145850_b.field_72995_K && this.tempTardisData == null) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestTardisData(this.tardisID));
            }
            if (!this.field_145850_b.field_72995_K && this.tempTardisData == null) {
                this.tempTardisData = DMTardis.getTardis(this.tardisID);
            }
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public ChameleonCircuitBase getSkin(TardisData data) {
        return DMTardis.getTardisSkin(data.getExteriorID());
    }

    public void setDoorRotation(float rot) {
        this.rot = rot;
    }

    public boolean isSotoUpdate() {
        return this.sotoUpdate;
    }

    public float getRotation() {
        return this.rot;
    }

    public void setTardisID(int tardisID) {
        this.tardisID = tardisID;
    }

    public int getTardisID() {
        return this.tardisID;
    }

    public void setMaxRotation(float maxRotation) {
        this.maxRotation = maxRotation;
    }

    public void setOpen(boolean open) {
        this.open = open;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_SotoDoors(this.field_174879_c, open), this.func_145831_w().field_73011_w.getDimension());
        }
    }

    public void setOpen_tick(int open_tick) {
        this.open_tick = open_tick;
    }

    public void setRot(float rot) {
        this.rot = rot;
    }

    public void setRotationSpeedClosed(float rotationSpeedClosed) {
        this.rotationSpeedClosed = rotationSpeedClosed;
    }

    public void setRotationSpeedOpen(float rotationSpeedOpen) {
        this.rotationSpeedOpen = rotationSpeedOpen;
    }

    public float getMaxRotation() {
        return this.maxRotation;
    }

    public void setSotoUpdate(boolean sotoUpdate) {
        this.sotoUpdate = sotoUpdate;
    }

    public void setTempTardisData(TardisData tempTardisData) {
        this.tempTardisData = tempTardisData;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tardis_id", this.tardisID);
        compound.func_74776_a("rot", this.rotation);
        compound.func_74757_a("open", this.open);
        compound.func_74776_a("maxRot", this.maxRotation);
        compound.func_74776_a("openSpeed", this.rotationSpeedOpen);
        compound.func_74776_a("closedSpeed", this.rotationSpeedClosed);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tardisID = compound.func_74764_b("tardis_id") ? compound.func_74762_e("tardis_id") : 0;
        this.rotation = compound.func_74764_b("rot") ? compound.func_74760_g("rot") : 0.0f;
        this.open = compound.func_74764_b("open") ? compound.func_74767_n("open") : false;
        this.maxRotation = compound.func_74760_g("maxRot");
        this.rotationSpeedOpen = compound.func_74760_g("openSpeed");
        this.rotationSpeedClosed = compound.func_74760_g("closedSpeed");
    }

    public void onChunkUnload() {
    }

    @Override
    public int getDimension() {
        return this.tempTardisData != null ? this.tempTardisData.getTardisCurrentdimension() : 0;
    }

    @Override
    public BlockPos getPosToRender() {
        return this.tempTardisData != null ? WorldUtils.vec3ToBlockPos(this.tempTardisData.getCurrentTardisPosition()) : BlockPos.field_177992_a;
    }

    @Override
    public WorldRender getWorldRender() {
        return this.worldRender;
    }

    @Override
    public void setWorldRender(WorldRender worldRender) {
        this.worldRender = worldRender;
    }

    @Override
    public void requestRender() {
        if (this.field_145850_b.field_72995_K) {
            if (this.open && !this.sotoUpdate) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestBoti(this.func_174877_v()));
            }
            this.setSotoUpdate(true);
        }
        if (!this.field_145850_b.field_72995_K && !this.sotoUpdate) {
            this.setSotoUpdate(true);
        }
    }

    public void handleDoorRotations() {
        if (this.tempTardisData != null) {
            if (this.open && this.getRotation() < this.maxRotation) {
                this.setDoorRotation(this.getRotation() + this.rotationSpeedOpen);
                if (this.getRotation() > this.maxRotation) {
                    this.setDoorRotation(this.maxRotation);
                }
            } else {
                if (!this.open && this.getRotation() > 0.0f) {
                    this.setDoorRotation(this.getRotation() - this.rotationSpeedClosed);
                }
                if (this.getRotation() < 0.0f) {
                    this.setDoorRotation(0.0f);
                }
            }
        }
    }

    public void updateDoorRotations() {
        if (this.tempTardisData != null) {
            ChameleonCircuitBase base = this.getSkin(this.tempTardisData);
            this.maxRotation = base.maxDoorRotation();
            this.rotationSpeedOpen = base.doorOpenSpeed();
            this.rotationSpeedClosed = base.doorCloseSpeed();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }
}

