/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis;

import com.swdteam.client.worldportal.IWorldPortal;
import com.swdteam.client.worldportal.WorldPortal;
import com.swdteam.client.worldportal.WorldRender;
import com.swdteam.client.worldportal.packet.PacketRequestBoti;
import com.swdteam.common.dimensions.world.WorldProviderTardis;
import com.swdteam.common.entity.EntityLaser;
import com.swdteam.common.entity.EntityWeepingAngel;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisData;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.WorldUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTardis
extends DMTileEntityBase
implements ITickable,
IWorldPortal {
    public boolean forceField;
    public float forcefieldalpha = 0.15f;
    public int tardisID;
    public int pulses = -1;
    public boolean isDemat = false;
    public boolean isRemat = false;
    public boolean b1;
    public int health = 1000;
    public float dematAmount = 1.0f;
    public WorldRender customWorld = new WorldRender(this.field_174879_c);
    private int botiticks = 0;
    public boolean botiUpdate = true;
    private int door_open_ticks = 0;
    public boolean cloaked = false;
    public TardisData tempTardisData;
    public float scale = 1.0f;
    public boolean requestingData;
    public static AxisAlignedBB defaultAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static int timer = 1800;
    public AxisAlignedBB forceFieldBounds;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tardis_id", this.tardisID);
        compound.func_74757_a("isDemat", this.isDemat);
        compound.func_74757_a("isRemat", this.isRemat);
        compound.func_74776_a("dematAmount", this.dematAmount);
        compound.func_74776_a("scale", this.scale);
        compound.func_74768_a("pulses", this.pulses);
        compound.func_74757_a("b1", this.b1);
        compound.func_74757_a("forceField", this.forceField);
        compound.func_74776_a("f_a", this.forcefieldalpha);
        compound.func_74768_a("health", this.health);
        compound.func_74757_a("cloaked", this.cloaked);
        compound.func_74768_a("door_ticks", this.door_open_ticks);
        if (this.tempTardisData != null && !this.field_145850_b.field_72995_K) {
            TardisSaveHandler.saveTardis(this.tempTardisData);
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tardisID = compound.func_74764_b("tardis_id") ? compound.func_74762_e("tardis_id") : 0;
        this.isDemat = compound.func_74764_b("isDemat") ? compound.func_74767_n("isDemat") : false;
        this.isRemat = compound.func_74764_b("isRemat") ? compound.func_74767_n("isRemat") : false;
        this.dematAmount = compound.func_74764_b("dematAmount") ? compound.func_74760_g("dematAmount") : 0.0f;
        this.scale = compound.func_74764_b("scale") ? compound.func_74760_g("scale") : 1.0f;
        this.pulses = compound.func_74764_b("pulses") ? compound.func_74762_e("pulses") : 0;
        this.b1 = compound.func_74764_b("b1") ? compound.func_74767_n("b1") : false;
        this.forceField = compound.func_74764_b("forceField") ? compound.func_74767_n("forceField") : false;
        this.forcefieldalpha = compound.func_74764_b("f_a") ? compound.func_74760_g("f_a") : 0.15f;
        this.health = compound.func_74764_b("health") ? compound.func_74762_e("health") : 1000;
        this.cloaked = compound.func_74764_b("cloaked") ? compound.func_74767_n("cloaked") : false;
        this.door_open_ticks = compound.func_74764_b("door_ticks") ? compound.func_74762_e("door_ticks") : 0;
    }

    public List<EntityWeepingAngel> getAngels() {
        return this.field_145850_b.func_72872_a(EntityWeepingAngel.class, this.getRenderBoundingBox().func_72314_b(10.0, 10.0, 10.0));
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null) {
            this.tempTardisData = DMTardis.getTardis(!this.field_145850_b.field_72995_K, this.tardisID);
        }
        this.sendUpdates();
    }

    @Override
    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void func_73660_a() {
        int i;
        boolean recharge;
        if (this.tempTardisData == null) {
            this.tempTardisData = DMTardis.getTardis(!this.field_145850_b.field_72995_K, this.tardisID);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !this.requestingData) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestTardisData(this.tardisID));
            this.requestingData = true;
        }
        if (this.tempTardisData != null) {
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                if (this.tempTardisData.getTardisID() == 0 && this.field_145850_b.func_82737_E() % 100L == 0L) {
                    this.requestingData = false;
                }
            } else if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.tempTardisData.getTardisID() == 0 && this.field_145850_b.func_82737_E() % 100L == 0L) {
                this.tempTardisData = DMTardis.getTardis(!this.field_145850_b.field_72995_K, this.tardisID);
            }
        }
        if (this.tempTardisData != null && !this.field_145850_b.field_72995_K) {
            List entities;
            ChameleonCircuitBase bases = this.getSkin(this.tempTardisData);
            if (DMConfig.tardis.isBotiEnabled && bases != null && bases.hasBoti()) {
                if ((this.botiticks >= 500 || this.botiUpdate) && this.tempTardisData.getDoorRotation() > 0.0f) {
                    WorldPortal.getWorldRender((World)((WorldServer)this.field_145850_b), this.customWorld, this.getPosToRender(), this.getDimension(), this.field_174879_c, this.tempTardisData.getSpawnFacing(), true);
                    if (this.botiUpdate) {
                        this.botiUpdate = false;
                    }
                    this.botiticks = 0;
                }
                if (this.botiticks < 500) {
                    ++this.botiticks;
                }
            }
            if (this.tempTardisData.isDoorOpen()) {
                ++this.door_open_ticks;
            } else if (this.door_open_ticks != 0) {
                this.door_open_ticks = 0;
            }
            if (this.door_open_ticks > 1800 && (entities = this.field_145850_b.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(10.0))).isEmpty()) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(this.field_174879_c, false), this.func_145831_w().field_73011_w.getDimension());
                this.tempTardisData.setDoorOpen(false);
                this.door_open_ticks = 0;
            }
        }
        if (this.tempTardisData == null) {
            return;
        }
        if (this.tempTardisData != null) {
            this.cloaked = this.tempTardisData.isCloak();
        }
        if (this.tempTardisData != null) {
            this.forceField = this.tempTardisData.areForcefieldsEnabled();
        }
        if (this.tardisID == 0) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
        if (!(this.tempTardisData == null || this.field_145850_b.field_72995_K || this.field_174879_c.func_177986_g() == WorldUtils.vec3ToBlockPos(this.tempTardisData.getCurrentTardisPosition()).func_177986_g() || this.isRemat || this.isDemat)) {
            if (DMConfig.debug.debug_game_output) {
                TheDalekMod.LOG.info("Removed dupe with id: " + this.tardisID);
            }
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.forcefieldalpha != 0.15f) {
                this.forcefieldalpha = 0.15f;
            } else {
                for (Entity e : this.func_145831_w().func_72872_a(Entity.class, this.getRenderBoundingBox().func_186662_g(5.0))) {
                    if (!(e.func_70011_f((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) > 3.0) || !(e.func_70011_f((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) < 5.0) || !(e instanceof IProjectile)) continue;
                    this.forcefieldalpha = 0.4f;
                }
            }
        }
        ++timer;
        if (this.tempTardisData != null) {
            this.health = this.tempTardisData.getTardisHealth();
        }
        boolean bl = recharge = timer >= 1800;
        if (this.func_145831_w().func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == DMBlocks.ZeitonBlock) {
            boolean bl2 = recharge = timer >= 800;
        }
        if (recharge && this.health < 1000) {
            ++this.health;
            if (this.health > 1000) {
                this.health = 1000;
            }
            timer = 0;
            if (this.tempTardisData != null) {
                this.tempTardisData.setTardisHealth(this.health);
            }
        }
        this.forceFieldBounds = this.forceField ? new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0) : new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0);
        boolean hads = this.tempTardisData.getHads();
        List laserList = this.field_145850_b.func_72872_a(Entity.class, this.forceFieldBounds);
        List mobList = this.field_145850_b.func_72872_a(EntityMob.class, this.forceFieldBounds);
        if (mobList.size() > 0 && this.forceField) {
            for (i = 0; i < mobList.size(); ++i) {
                EntityMob mob = (EntityMob)mobList.get(i);
                if (mob.field_70165_t > (double)this.field_174879_c.func_177958_n()) {
                    mob.func_70634_a(mob.field_70169_q + (double)0.05f, mob.field_70167_r, mob.field_70166_s);
                }
                if (mob.field_70165_t < (double)this.field_174879_c.func_177958_n()) {
                    mob.func_70634_a(mob.field_70169_q - (double)0.05f, mob.field_70167_r, mob.field_70166_s);
                }
                if (mob.field_70161_v > (double)this.field_174879_c.func_177952_p()) {
                    mob.func_70634_a(mob.field_70169_q, mob.field_70167_r, mob.field_70166_s + (double)0.05f);
                }
                if (!(mob.field_70161_v < (double)this.field_174879_c.func_177952_p())) continue;
                mob.func_70634_a(mob.field_70169_q, mob.field_70167_r, mob.field_70166_s - (double)0.05f);
            }
        }
        if (laserList.size() > 0) {
            for (i = 0; i < laserList.size(); ++i) {
                Entity entity = (Entity)laserList.get(i);
                if (entity instanceof EntityLaser) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
                    entity.func_70106_y();
                    laserList.remove(entity);
                    this.health = this.forceField ? (this.health -= 3) : (this.health -= 30);
                    if (hads) {
                        this.handleHads();
                    }
                }
                if (entity instanceof EntityArrow) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
                    entity.func_70106_y();
                    laserList.remove(entity);
                    this.health = this.forceField ? --this.health : (this.health -= 10);
                    if (hads) {
                        this.handleHads();
                    }
                }
                if (!(entity instanceof EntityTNTPrimed) || !this.forceField) continue;
                for (int j = 0; j < 40; ++j) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v - (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v - (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70163_u - (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 1.0, 1.0, 1.0, new int[0]);
                }
                entity.func_70106_y();
                laserList.remove(entity);
                this.health -= 10;
            }
        }
        if (this.tempTardisData != null) {
            if (this.health <= 0) {
                this.health = 1;
                this.tempTardisData.setTardisHealth(1);
                this.tempTardisData.setForcefieldsEnabled(false);
                if (!this.isDemat) {
                    this.setDemat(true);
                    this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), DMSounds.tardis_out_of_bounds, SoundCategory.MASTER, 1.0f, 1.0f, false);
                }
            }
            this.tempTardisData.setTardisHealth(this.health);
        }
        if (this.tempTardisData != null && this.tempTardisData.getTardisHealth() < 20) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)0.01f, (double)0.05f, (double)0.01f, new int[]{1, 1, 1});
        }
        if (this.tempTardisData != null) {
            ChameleonCircuitBase base = this.getSkin(this.tempTardisData);
            if (this.tempTardisData.isDoorOpen() && this.tempTardisData.getDoorRotation() < base.maxDoorRotation()) {
                this.tempTardisData.setDoorRotation(this.tempTardisData.getDoorRotation() + base.doorOpenSpeed());
                if (this.tempTardisData.getDoorRotation() > base.maxDoorRotation()) {
                    this.tempTardisData.setDoorRotation(base.maxDoorRotation());
                }
            } else {
                if (!this.tempTardisData.isDoorOpen() && this.tempTardisData.getDoorRotation() > 0.0f) {
                    this.tempTardisData.setDoorRotation(this.tempTardisData.getDoorRotation() - base.doorCloseSpeed());
                }
                if (this.tempTardisData.getDoorRotation() < 0.0f) {
                    this.tempTardisData.setDoorRotation(0.0f);
                }
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                AxisAlignedBB bounds = defaultAABB.func_186670_a(this.func_174877_v());
                List entities = this.field_145850_b.func_72872_a(Entity.class, bounds);
                if (!entities.isEmpty() && this.pulses == -1 && this.tempTardisData.isDoorOpen()) {
                    this.tempTardisData = DMTardis.getTardis(this.tardisID);
                    base.handleEnter(this.field_145850_b, this.field_174879_c, this, (Entity)entities.get(0));
                }
                if (!(this.tempTardisData.isDoorOpen() || entities.isEmpty() || this.pulses == -1 || this.isDemat)) {
                    this.tempTardisData = DMTardis.getTardis(this.tardisID);
                    if (entities.get(0) instanceof EntityPlayer && !(this.field_145850_b.field_73011_w instanceof WorldProviderTardis) && DMTardis.hasPermission(this.tempTardisData, (EntityPlayer)entities.get(0))) {
                        base.handleEnter(this.field_145850_b, this.field_174879_c, this, (Entity)entities.get(0));
                    }
                }
            }
        }
        if (this.isDemat || this.isRemat) {
            if (this.pulses == -1) {
                if (this.isRemat) {
                    this.b1 = true;
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.isDemat ? DMSounds.tardisDemat : DMSounds.tardisRemat, SoundCategory.MASTER, 1.0f, 1.0f, false);
                if (this.health <= 1) {
                    this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), DMSounds.CloisterBell, SoundCategory.MASTER, 1.0f, 1.0f, false);
                }
                this.pulses = 0;
            }
            if (!this.b1) {
                this.dematAmount -= 0.05f;
                if (this.dematAmount <= 0.2f) {
                    this.b1 = !this.b1;
                    ++this.pulses;
                }
            } else {
                this.dematAmount += 0.05f;
                if (this.dematAmount >= 1.0f) {
                    this.b1 = !this.b1;
                    ++this.pulses;
                }
            }
        }
        if (this.pulses >= 13) {
            if (this.isDemat) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
                this.isDemat = false;
                this.isRemat = false;
                this.pulses = -1;
                this.dematAmount = 0.0f;
            }
            if (this.isRemat) {
                this.finishRemat();
            }
        }
    }

    public void handleHads() {
        if (!(this.forceField || this.isRemat || this.isDemat || this.field_145850_b.field_72995_K)) {
            Random r = this.field_145850_b.field_73012_v;
            int X = this.func_174877_v().func_177958_n() + r.nextInt(30);
            int Z = this.func_174877_v().func_177952_p() + r.nextInt(30);
            this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), DMSounds.CloisterBell, SoundCategory.MASTER, 1.0f, 1.0f, false);
            BlockPos bpto = new BlockPos(X, this.field_145850_b.func_175672_r(new BlockPos(X, this.func_174877_v().func_177956_o(), Z)).func_177956_o(), Z);
            WorldUtils.summonTardisToPos(this.field_145850_b, DMTardis.getTardis(this.tardisID), bpto, this.tempTardisData.getTravelRotation());
        }
    }

    public void finishRemat() {
        if (this.tempTardisData != null) {
            this.tempTardisData.setInFlight(false);
            this.tempTardisData.setTardisCurrentDimensionLocation(this.field_145850_b.field_73011_w.getDimension());
            this.tempTardisData.setCurrentLocationName(this.field_145850_b.field_73011_w.func_186058_p().func_186065_b());
            if (!this.field_145850_b.field_72995_K) {
                TardisSaveHandler.saveTardis(this.tempTardisData);
            }
            this.isRemat = false;
            this.isDemat = false;
            this.pulses = -1;
            this.dematAmount = 1.0f;
        }
    }

    public ChameleonCircuitBase getSkin(TardisData data) {
        return DMTardis.getTardisSkin(data.getExteriorID());
    }

    public void setDemat(boolean isDemat) {
        this.isDemat = isDemat;
        if (this.tempTardisData != null && this.tempTardisData.isDoorOpen()) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(this.field_174879_c, false), this.func_145831_w().field_73011_w.getDimension());
            this.tempTardisData.setDoorOpen(false);
            this.sendUpdates();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 5), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public void setRemat(boolean isRemat) {
        this.isRemat = isRemat;
        this.sendUpdates();
    }

    public void setBotiUpdate(boolean botiUpdate) {
        this.botiUpdate = botiUpdate;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        DMTardis.removeTardis(this.tardisID);
        if (this.tempTardisData != null && this.tempTardisData.isDoorOpen() && !this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_TardisDoors(this.field_174879_c, false));
            this.tempTardisData.setDoorOpen(false);
        }
    }

    @Override
    public int getDimension() {
        return DMDimensions.DIM_TARDIS_ID;
    }

    @Override
    public BlockPos getPosToRender() {
        return this.tempTardisData != null ? WorldUtils.vec3ToBlockPos(this.tempTardisData.getTardisInteriorDoorLocation()) : this.field_174879_c;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WorldRender getWorldRender() {
        return this.customWorld;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setWorldRender(WorldRender worldRender) {
        this.customWorld = worldRender;
    }

    @Override
    public void requestRender() {
        if (this.field_145850_b.field_72995_K && this.tempTardisData != null && this.tempTardisData.isDoorOpen() && this.getWorldRender().getRenderPos().func_177986_g() == 0L) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestBoti(this.func_174877_v()));
        }
        if (!this.field_145850_b.field_72995_K && !this.botiUpdate) {
            this.botiUpdate = true;
        }
    }
}

