/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl;

import com.google.gson.Gson;
import com.swdteam.mdl.MDL;
import com.swdteam.mdl.MDLData;
import com.swdteam.mdl.obj.Model;
import com.swdteam.mdl.obj.OBJLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class MDLLoader {
    public static Gson GSON = new Gson();

    public static MDL loadMDL(String mod, String location) {
        try {
            return MDLLoader.loadMDL(new ResourceLocation(mod, location));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MDL loadMDL(ResourceLocation location) throws Exception {
        return MDLLoader.loadMDL(Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b());
    }

    public static MDL loadMDL(InputStream inputstream) throws Exception {
        BufferedReader reader = null;
        try {
            MDL model = new MDL();
            HashMap<String, Model> models = new HashMap<String, Model>();
            HashMap<String, BufferedImage> textures = new HashMap<String, BufferedImage>();
            ZipInputStream stream = new ZipInputStream(inputstream);
            ZipEntry e = null;
            MDLData mdld = null;
            while ((e = stream.getNextEntry()) != null) {
                BufferedImage image;
                if (e.getName().equalsIgnoreCase("data_mdl.json")) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    mdld = (MDLData)GSON.fromJson(sb.toString(), MDLData.class);
                    if (mdld == null) {
                        reader.close();
                        throw new Exception("MDL Data is missing...");
                    }
                }
                if (e.getName().toUpperCase().endsWith(".OBJ")) {
                    Model obj = OBJLoader.INSTANCE.loadModel(stream);
                    obj.objName = e.getName().substring(0, e.getName().length() - 4);
                    models.put(obj.objName, obj);
                }
                if (!e.getName().toUpperCase().startsWith("MDL_ICO") && e.getName().toUpperCase().endsWith(".PNG")) {
                    image = ImageIO.read(stream);
                    textures.put(e.getName().substring(0, e.getName().length() - 4), image);
                }
                if (!e.getName().toUpperCase().equals("MDL_ICO.PNG")) continue;
                model.modelIcon = image = ImageIO.read(stream);
            }
            if (mdld != null && mdld.object_data != null) {
                MDLData.ObjectData data;
                ArrayList<BufferedImage> img = new ArrayList<BufferedImage>();
                ArrayList<Model> mdls = new ArrayList<Model>();
                int i = 0;
                while (i < mdld.textures.length) {
                    if (textures.containsKey(mdld.textures[i])) {
                        img.add((BufferedImage)textures.get(mdld.textures[i]));
                    }
                    ++i;
                }
                i = 0;
                while (i < mdld.object_data.length) {
                    data = mdld.object_data[i];
                    if (models.containsKey(data.name)) {
                        Model obj = (Model)models.get(data.name);
                        if (data.name.equalsIgnoreCase(obj.objName)) {
                            obj.textureIndex = data.texture_index;
                            obj.xOffset = data.offset[0];
                            obj.yOffset = data.offset[1];
                            obj.zOffset = data.offset[2];
                            obj.xTransform = data.transform[0];
                            obj.yTransform = data.transform[1];
                            obj.zTransform = data.transform[2];
                            obj.xRotation = data.rotate[0];
                            obj.yRotation = data.rotate[1];
                            obj.zRotation = data.rotate[2];
                            obj.xScale = data.scale[0];
                            obj.yScale = data.scale[1];
                            obj.zScale = data.scale[2];
                            obj.xOrigin = data.origin[0];
                            obj.yOrigin = data.origin[1];
                            obj.zOrigin = data.origin[2];
                            obj.hidden = data.hidden;
                            obj.disable_shading = data.disable_shading;
                            obj.glow = data.glow;
                            mdls.add(obj);
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < mdld.object_data.length) {
                    data = mdld.object_data[i];
                    if (models.containsKey(data.name)) {
                        int j = 0;
                        while (j < data.children.length) {
                            if (models.containsKey(data.children[j])) {
                                ((Model)models.get((Object)data.name)).children.add((Model)models.get(data.children[j]));
                                ((Model)models.get((Object)data.children[j])).isChild = true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                model.setTextures(img.toArray(new BufferedImage[img.size()]));
                model.setModels(mdls.toArray(new Model[mdls.size()]));
                MDL mDL = model;
                return mDL;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputstream != null) {
                inputstream.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return null;
    }
}

