/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.mdl.obj;

import com.swdteam.mdl.MDLData;
import com.swdteam.mdl.obj.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class OBJLoader {
    public static OBJLoader INSTANCE = new OBJLoader();

    public static void main(String[] args) {
        MDLData data = new MDLData();
        data.textures = new String[]{"tex"};
        MDLData.ObjectData d = new MDLData.ObjectData();
        d.name = "model_test";
        d.texture_index = 0;
        data.object_data = new MDLData.ObjectData[]{d};
    }

    public int createDisplayList(Model model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        this.render(model);
        GL11.glEndList();
        return displayList;
    }

    public void render(Model model) {
        GlStateManager.func_179094_E();
        for (Model.Face face : model.getFaces()) {
            List<Vector3f> n = model.getNormals();
            List<Vector2f> t = model.getTextureCoordinates();
            List<Vector3f> v = model.getVertices();
            GL11.glBegin((int)4);
            int i = 0;
            while (i < face.getVertices().length - 2) {
                GL11.glNormal3f((float)n.get(face.getNormals()[0] - 1).getX(), (float)n.get(face.getNormals()[0] - 1).getY(), (float)n.get(face.getNormals()[0] - 1).getZ());
                GL11.glTexCoord2f((float)t.get(face.getTextureCoords()[0] - 1).getX(), (float)(1.0f - t.get(face.getTextureCoords()[0] - 1).getY()));
                GL11.glVertex3f((float)v.get(face.getVertices()[0] - 1).getX(), (float)v.get(face.getVertices()[0] - 1).getY(), (float)v.get(face.getVertices()[0] - 1).getZ());
                int j = 0;
                while (j < 2) {
                    GL11.glNormal3f((float)n.get(face.getNormals()[i + j + 1] - 1).getX(), (float)n.get(face.getNormals()[i + j + 1] - 1).getY(), (float)n.get(face.getNormals()[i + j + 1] - 1).getZ());
                    GL11.glTexCoord2f((float)t.get(face.getTextureCoords()[i + j + 1] - 1).getX(), (float)(1.0f - t.get(face.getTextureCoords()[i + j + 1] - 1).getY()));
                    GL11.glVertex3f((float)v.get(face.getVertices()[i + j + 1] - 1).getX(), (float)v.get(face.getVertices()[i + j + 1] - 1).getY(), (float)v.get(face.getVertices()[i + j + 1] - 1).getZ());
                    ++j;
                }
                ++i;
            }
            GL11.glEnd();
        }
        GlStateManager.func_179121_F();
    }

    public Model loadModel(File file) throws FileNotFoundException {
        Scanner s = new Scanner(file);
        Model obj = this.loadModel(s);
        return obj;
    }

    public Model loadModel(InputStream stream) {
        Scanner s = new Scanner(stream);
        Model obj = this.loadModel(s);
        return obj;
    }

    public Model loadModel(ResourceLocation resource) {
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b();
            Model obj = this.loadModel(stream);
            return obj;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Model loadModel(Scanner sc) {
        Model model = new Model();
        while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln == null || ln.equals("") || ln.startsWith("#")) continue;
            String[] split = ln.split(" ");
            switch (split[0]) {
                case "v": {
                    model.getVertices().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vn": {
                    model.getNormals().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vt": {
                    model.getTextureCoordinates().add(new Vector2f(Float.parseFloat(split[1]), Float.parseFloat(split[2])));
                    break;
                }
                case "f": {
                    if (split.length <= 2) break;
                    int[] v = new int[split.length - 1];
                    int[] t = new int[split.length - 1];
                    int[] n = new int[split.length - 1];
                    int i = 0;
                    while (i < split.length - 1) {
                        v[i] = this.parseInt(split[i + 1].split("/")[0]);
                        t[i] = this.parseInt(split[i + 1].split("/")[1]);
                        n[i] = this.parseInt(split[i + 1].split("/")[2]);
                        ++i;
                    }
                    model.getFaces().add(new Model.Face(v, t, n));
                    break;
                }
                case "s": {
                    model.setSmoothShadingEnabled(!ln.contains("off"));
                }
            }
        }
        return model;
    }

    public int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

