/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMMDLLoader;
import com.swdteam.client.model.entities.ModelClockworkDroid;
import com.swdteam.client.model.entities.ModelGelGuard;
import com.swdteam.client.model.entities.ModelIceWarrior;
import com.swdteam.client.model.entities.ModelOod;
import com.swdteam.client.model.entities.ModelSilence;
import com.swdteam.client.model.entities.ModelSontaran;
import com.swdteam.client.model.entities.ModelZygon;
import com.swdteam.client.model.entities.auton.ModelAuton;
import com.swdteam.client.model.entities.cybermen.ModelCyberVillager;
import com.swdteam.client.model.entities.cybermen.ModelCybermanEarthShock;
import com.swdteam.client.model.entities.cybermen.ModelCybermanModern;
import com.swdteam.client.model.entities.cybermen.ModelCybermenInvasion;
import com.swdteam.client.model.entities.cybermen.ModelTenthPlanetCyberman;
import com.swdteam.client.model.entities.cybermen.patients.Cyberman_Patient_V1;
import com.swdteam.client.model.entities.cybermen.patients.Cyberman_Patient_V2;
import com.swdteam.client.model.entities.cybermen.patients.Cyberman_Patient_V3;
import com.swdteam.client.model.entities.gasmask_zombies.ModelEmptyNPC;
import com.swdteam.client.model.entities.gasmask_zombies.ModelVilGm;
import com.swdteam.client.model.entities.k9.ModelK9;
import com.swdteam.client.model.entities.k9.ModelK9Australia;
import com.swdteam.client.model.entities.players.ModelAlex18;
import com.swdteam.client.model.entities.snowmen.ModelSnowman;
import com.swdteam.client.model.entities.timelords.ModelChancelleryGuard;
import com.swdteam.client.model.entities.timelords.ModelTimeLord;
import com.swdteam.client.skinpack.ModelSkinpackBase;
import com.swdteam.client.skinpack.Skin;
import com.swdteam.client.skinpack.SkinSession;
import com.swdteam.client.skinpack.Skinpack;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.DataManager;
import com.swdteam.utils.IOUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class DMSkinpacks {
    public static HashMap<String, ModelBase> internalModels = new HashMap();
    public static HashMap<String, ModelBase> externalModels = new HashMap();
    public static HashMap<String, BufferedImage> externalTextures = new HashMap();
    public static HashMap<Integer, Skinpack> skinPacks = new HashMap();
    public static HashMap<String, SkinSession> skinSessions = new HashMap();
    private static int packID = 0;

    public static int clearCache() {
        int i = 0;
        i += internalModels.size();
        i += externalModels.size();
        i += externalTextures.size();
        i += skinPacks.size();
        i += skinSessions.size();
        internalModels.clear();
        externalModels.clear();
        externalTextures.clear();
        skinPacks.clear();
        skinSessions.clear();
        DMSkinpacks.init();
        return i;
    }

    public static void addSession(String username, int pack, int skin) {
        SkinSession skinSession = new SkinSession(username, pack, skin);
        skinSessions.put(username, skinSession);
    }

    public static void deleteSession(String username) {
        skinSessions.remove(username);
    }

    public static SkinSession getSession(String username) {
        return skinSessions.get(username);
    }

    public static boolean sessionExists(String user) {
        return skinSessions.containsKey(user);
    }

    public static void init() {
        internalModels.put("CyberEarthShock", (ModelBase)new ModelCybermanEarthShock());
        internalModels.put("CyberModern", new ModelCybermanModern());
        internalModels.put("CyberInvasion", (ModelBase)new ModelCybermenInvasion());
        internalModels.put("CyberTenthPlanet", (ModelBase)new ModelTenthPlanetCyberman());
        internalModels.put("CyberVillager", new ModelCyberVillager());
        internalModels.put("Patient1", (ModelBase)new Cyberman_Patient_V1());
        internalModels.put("Patient2", (ModelBase)new Cyberman_Patient_V2());
        internalModels.put("Patient3", (ModelBase)new Cyberman_Patient_V3());
        internalModels.put("Silence", (ModelBase)new ModelSilence());
        internalModels.put("TimelordGuard", (ModelBase)new ModelChancelleryGuard());
        internalModels.put("Timelord", (ModelBase)new ModelTimeLord());
        internalModels.put("ood", (ModelBase)new ModelOod());
        internalModels.put("IceWarrior", (ModelBase)new ModelIceWarrior());
        internalModels.put("Cyberman", new ModelCybermanModern());
        internalModels.put("EmptyNPC", new ModelEmptyNPC());
        internalModels.put("Auton", new ModelAuton());
        internalModels.put("WeepingAngel", DMMDLLoader.loadModel("entity/angels/weeping_angel", true));
        internalModels.put("GMVillager", new ModelVilGm());
        internalModels.put("ClockworkDroid", new ModelClockworkDroid());
        internalModels.put("GelGuard", new ModelGelGuard());
        internalModels.put("K9", new ModelK9());
        internalModels.put("K9Regen", new ModelK9Australia());
        internalModels.put("Snowman", new ModelSnowman());
        internalModels.put("Sontaran", new ModelSontaran());
        internalModels.put("Zygon", (ModelBase)new ModelZygon());
        ModelBiped biped = new ModelBiped();
        biped.field_78091_s = false;
        internalModels.put("ModelBiped", (ModelBase)biped);
        ModelAlex18 alex = new ModelAlex18(0.0f, true);
        alex.field_78091_s = false;
        internalModels.put("ModelAlex", (ModelBase)alex);
        DMSkinpacks.searchForSkinPacks();
    }

    private static void searchForSkinPacks() {
        String downloadData;
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath();
        File f = new File(fileDir + "/mods/Dalek Mod/Skinpacks");
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((downloadData = DataManager.getPage("http://sub.swdteam.com/minecraft/SWD/getSkinPacks.php")) != null && downloadData.length() > 0 && !downloadData.startsWith("<")) {
            String[] packsToDownload;
            String[] stringArray = packsToDownload = downloadData.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String aPacksToDownload = stringArray[i];
                if (!new File(f.getAbsolutePath() + "/" + aPacksToDownload + ".sp").exists()) {
                    IOUtils.tryDownloadFile("http://sub.swdteam.com/minecraft/SWD/skinpacks/" + aPacksToDownload + ".sp", f.getAbsolutePath() + "/" + aPacksToDownload + ".sp");
                    continue;
                }
                URL skinUrl = null;
                try {
                    skinUrl = new URL("http://sub.swdteam.com/minecraft/SWD/skinpacks/" + aPacksToDownload + ".sp");
                }
                catch (MalformedURLException e) {
                    TheDalekMod.LOG.error((Object)e);
                }
                File skinPath = new File(f.getAbsolutePath() + "/" + aPacksToDownload + ".sp");
                if (skinUrl == null || (long)IOUtils.getFileSizeURL(skinUrl) == skinPath.length()) continue;
                System.out.println("Skinpack " + aPacksToDownload + " corrupted.");
                try {
                    IOUtils.tryDownloadFile("http://sub.swdteam.com/minecraft/SWD/skinpacks/" + aPacksToDownload + ".sp", f.getAbsolutePath() + "/" + aPacksToDownload + ".sp");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        for (File dirFile : f.listFiles()) {
            if (!dirFile.getName().endsWith(".sp")) continue;
            ZipFile fis1 = null;
            try {
                fis1 = new ZipFile(dirFile.getAbsoluteFile());
                if (fis1.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis1.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entryZip = e.nextElement();
                        if (!entryZip.getName().endsWith(".png")) continue;
                        InputStream input = fis1.getInputStream(entryZip);
                        externalTextures.put(entryZip.getName().substring(0, entryZip.getName().length() - 4), ImageIO.read(input));
                        input.close();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ZipFile fis2 = null;
            try {
                fis2 = new ZipFile(dirFile.getAbsoluteFile());
                if (fis2.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis2.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entryZip = e.nextElement();
                        if (!entryZip.getName().endsWith(".scn")) continue;
                        InputStream input = fis2.getInputStream(entryZip);
                        externalModels.put(entryZip.getName().substring(0, entryZip.getName().length() - 4), new ModelSkinpackBase(input));
                        input.close();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ZipFile fis = null;
            try {
                fis = new ZipFile(dirFile.getAbsoluteFile());
                if (fis.size() > 0) {
                    Enumeration<? extends ZipEntry> e = fis.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (!entry.getName().equals("pack.data")) continue;
                        InputStream in = fis.getInputStream(entry);
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        Skinpack pack = new Skinpack(Integer.parseInt(DMSkinpacks.getValue(r.readLine())));
                        pack.setSkinpackName(DMSkinpacks.getValue(r.readLine()));
                        pack.setSkinpackCreator(DMSkinpacks.getValue(r.readLine()));
                        pack.setSkinpackDate(DMSkinpacks.getValue(r.readLine()));
                        ArrayList<Skin> skins = new ArrayList<Skin>();
                        String line = r.readLine();
                        if (line.contains("PackContents")) {
                            String lineData;
                            while (!(lineData = r.readLine()).endsWith("}")) {
                                Skin skin = new Skin();
                                String data = lineData.substring(2, lineData.length() - 2);
                                String[] skinData = data.split("\\.");
                                skin.setSkinName(skinData[0]);
                                skin.setModelName(skinData[1]);
                                skin.setModelLocation(skinData[2].toLowerCase().startsWith("i") ? Skin.FileLocation.INTERNAL : Skin.FileLocation.EXTERNAL);
                                skin.setTextureDir(skinData[3]);
                                skin.setTextureLocation(skinData[4].toLowerCase().startsWith("i") ? Skin.FileLocation.INTERNAL : Skin.FileLocation.EXTERNAL);
                                skin.setup();
                                skins.add(skin);
                            }
                        }
                        r.close();
                        DMSkinpacks.addCustomSkins(dirFile, skins);
                        Skin[] skinArray = new Skin[skins.size()];
                        skinArray = skins.toArray(skinArray);
                        pack.setSkins(skinArray);
                        skinPacks.put(packID++, pack);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fis == null) continue;
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addCustomSkins(File dirFile, ArrayList<Skin> skins) {
        if (dirFile.getName().equalsIgnoreCase("doctors_khotarri.sp")) {
            DMSkinpacks.setupSkinInternal("Thirteenth Doctor", "ModelAlex", "Doctors/13thdr", skins);
        }
        if (dirFile.getName().equalsIgnoreCase("misc.sp")) {
            DMSkinpacks.setupSkinInternal("Sontaran", "Sontaran", "textures/entity/sontaran.png", skins);
            DMSkinpacks.setupSkinInternal("Gel Gaurd", "GelGuard", "textures/entity/gel.png", skins);
            DMSkinpacks.setupSkinInternal("K9", "K9", "drmobs/k9_new", skins);
            DMSkinpacks.setupSkinInternal("K9 Regen", "K9Regen", "drmobs/k9_aussie", skins);
            DMSkinpacks.setupSkinInternal("Ice Warrior", "IceWarrior", "drmobs/ice_warrior", skins);
            DMSkinpacks.setupSkinInternal("Silence", "Silence", "drmobs/silence", skins);
        }
    }

    public static void setupSkinInternal(String name, String ModelName, String textureDir, ArrayList<Skin> skins) {
        Skin skin = new Skin();
        skin.setSkinName(name);
        skin.setModelName(ModelName);
        skin.setModelLocation(Skin.FileLocation.INTERNAL);
        skin.setTextureDir(textureDir);
        skin.setTextureLocation(Skin.FileLocation.INTERNAL);
        skin.setup();
        skins.add(skin);
    }

    private static String getValue(String s) {
        return s.substring(s.indexOf(":") + 1);
    }
}

