/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block.actions;

import com.swdteam.common.block.BlockDMLeaves;
import com.swdteam.common.block.tardis.BlockTardis;
import com.swdteam.common.capability.CapabilityTardis;
import com.swdteam.common.capability.interfaces.ITardisCapability;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.TileEntityNitro9;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.TeleportUtils;
import com.swdteam.utils.Vector3;
import com.swdteam.utils.WorldUtils;
import com.swdteam.utils.math.MathUtils;
import com.swdteam.utils.math.Vector2f;
import com.swdteam.utils.math.Vector3d;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ActionList {
    public static boolean tardisDoorExit(World worldIn, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            ITardisCapability capa = (ITardisCapability)playerIn.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null);
            if (worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                int tardisID = capa.getTARDISID();
                TardisData data = DMTardis.getTardis(tardisID);
                if (data != null) {
                    BlockPos exterior = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition());
                    if (DimensionManager.isDimensionRegistered((int)data.getTardisCurrentdimension())) {
                        WorldServer w = worldIn.func_73046_m().func_71218_a(data.getTardisCurrentdimension());
                        if (!data.isLocked()) {
                            TileEntityTardis TARDIS2;
                            if (data.isInFlight()) {
                                if (w.func_175625_s(exterior) != null) {
                                    TileEntity te = w.func_175625_s(exterior);
                                    if (te instanceof TileEntityTardis) {
                                        if (((TileEntityTardis)te).isRemat) {
                                            ((TileEntityTardis)te).finishRemat();
                                        }
                                    } else {
                                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                                        return false;
                                    }
                                    if (((TileEntityTardis)te).isDemat) {
                                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                                        return false;
                                    }
                                } else {
                                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                                    return false;
                                }
                            }
                            if (w.func_180495_p(exterior).func_177230_c() != DMBlocks.TARDIS) {
                                w.func_175656_a(exterior, DMBlocks.TARDIS.func_176223_P());
                                TARDIS2 = (TileEntityTardis)w.func_175625_s(exterior);
                                TARDIS2.rotation = data.getTravelRotation();
                                TARDIS2.tardisID = data.getTardisID();
                                TARDIS2.tempTardisData = data;
                            }
                            if (w.func_180495_p(exterior).func_177230_c() == DMBlocks.TARDIS) {
                                TARDIS2 = (TileEntityTardis)w.func_175625_s(exterior);
                                Vector3d look = Vector3d.fromPitchYawVector(new Vector2f(45.0f, TARDIS2.rotation + 180.0f));
                                float distance = 2.5f;
                                double dx = (double)data.getCurrentTardisPosition().getX() + look.x * (double)distance;
                                double dy = data.getCurrentTardisPosition().getY();
                                double dz = (double)data.getCurrentTardisPosition().getZ() + look.z * (double)distance;
                                TeleportUtils.teleportToDimension((EntityPlayerMP)playerIn, data.getTardisCurrentdimension(), dx, dy, dz, TARDIS2.rotation + 180.0f, 0.0f);
                                TARDIS2.finishRemat();
                            }
                        } else {
                            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst it's locked!"));
                        }
                    }
                } else {
                    ActionList.forceTardisOverWorld(data);
                }
            }
        }
        return true;
    }

    public static boolean tardisDoorExit(World worldIn, Entity playerIn, int tardisID) {
        if (!worldIn.field_72995_K && worldIn.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
            TardisData data = DMTardis.getTardis(tardisID);
            if (data != null) {
                BlockPos exterior = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition());
                if (DimensionManager.isDimensionRegistered((int)data.getTardisCurrentdimension())) {
                    WorldServer w = worldIn.func_73046_m().func_71218_a(data.getTardisCurrentdimension());
                    if (!data.isLocked()) {
                        TileEntityTardis TARDIS2;
                        if (data.isInFlight()) {
                            if (w.func_175625_s(exterior) != null) {
                                TileEntity te = w.func_175625_s(exterior);
                                if (te instanceof TileEntityTardis) {
                                    if (((TileEntityTardis)te).isRemat) {
                                        ((TileEntityTardis)te).finishRemat();
                                    }
                                } else {
                                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                                    return false;
                                }
                                if (((TileEntityTardis)te).isDemat) {
                                    playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                                    return false;
                                }
                            } else {
                                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst in flight!"));
                                return false;
                            }
                        }
                        if (w.func_180495_p(exterior).func_177230_c() != DMBlocks.TARDIS) {
                            w.func_175656_a(exterior, DMBlocks.TARDIS.func_176223_P());
                            TARDIS2 = (TileEntityTardis)w.func_175625_s(exterior);
                            TARDIS2.rotation = data.getTravelRotation();
                            TARDIS2.tardisID = data.getTardisID();
                            TARDIS2.tempTardisData = data;
                        }
                        if (w.func_180495_p(exterior).func_177230_c() == DMBlocks.TARDIS) {
                            TARDIS2 = (TileEntityTardis)w.func_175625_s(exterior);
                            Vector3d look = Vector3d.fromPitchYawVector(new Vector2f(45.0f, TARDIS2.rotation + 180.0f));
                            float distance = 2.5f;
                            double dx = (double)data.getCurrentTardisPosition().getX() + look.x * (double)distance;
                            double dy = data.getCurrentTardisPosition().getY();
                            double dz = (double)data.getCurrentTardisPosition().getZ() + look.z * (double)distance;
                            TeleportUtils.teleportToDimension(playerIn, data.getTardisCurrentdimension(), dx, dy, dz, TARDIS2.rotation + 180.0f, 0.0f);
                            TARDIS2.finishRemat();
                        }
                    } else {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot leave your TARDIS whilst it's locked!"));
                    }
                }
            } else {
                ActionList.forceTardisOverWorld(data);
            }
        }
        return true;
    }

    public static void calculateLanding(EntityPlayer playerIn, TardisData data, World world, World world2) {
        playerIn.func_145747_a(new TextComponentTranslation("message.tardis.remat", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        BlockPos pos = WorldUtils.vec3ToBlockPos(data.getCurrentTardisPosition());
        if (data.getTravelToLocation() != null) {
            if (WorldUtils.isInWorldBounds(data.getTravelToLocation()) && WorldUtils.isInWorldBorderBounds(data.getTravelToLocation(), world)) {
                pos = WorldUtils.vec3ToBlockPos(data.getTravelToLocation());
            } else {
                playerIn.func_145747_a(new TextComponentTranslation("message.tardis.outofbounds", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                DMSounds.playSound(playerIn, DMSounds.tardis_out_of_bounds, SoundCategory.BLOCKS, playerIn.func_180425_c(), 1.0f, 1.0f);
            }
        }
        int getcount = 0;
        int bound = 250;
        if (world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177977_b()).func_177230_c() == Blocks.field_150350_a && world.field_73011_w.getDimension() == 1) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.tardis.calculating", new Object[0]), true);
            for (BlockPos posa : BlockPos.func_191532_a((int)(pos.func_177958_n() - bound), (int)(pos.func_177956_o() - 30), (int)(pos.func_177952_p() - bound), (int)(pos.func_177958_n() + bound), (int)(pos.func_177956_o() + 30), (int)(pos.func_177952_p() + bound))) {
                if (world.func_180495_p(posa).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(posa.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                pos = new BlockPos(posa.func_177958_n(), posa.func_177956_o() + 1, posa.func_177952_p());
                if (world.func_180495_p(new BlockPos(posa.func_177958_n() + 1, pos.func_177956_o(), posa.func_177952_p() + 1)).func_177230_c() != Blocks.field_150350_a || ++getcount != 50) continue;
                break;
            }
        }
        int startNum = data.getTravelToLocation() == null ? 255 : data.getTravelToLocation().y;
        int timesLooped = 0;
        for (int i = startNum; i >= 0; --i) {
            BlockPos p = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (world.func_180495_p(p).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(p.func_177982_a(0, -1, 0)).func_177230_c() != Blocks.field_150350_a) {
                pos = p;
                break;
            }
            if (i != 0 || timesLooped != 0) continue;
            i = 255;
            ++timesLooped;
        }
        data.setTardisCurrentDimensionLocation(data.getTardisDestinationDimension());
        data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos));
        world.func_175656_a(pos, DMBlocks.TARDIS.func_176223_P());
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTardis) {
            TileEntityTardis tet = (TileEntityTardis)te;
            tet.tardisID = data.getTardisID();
            tet.rotation = data.getTravelRotation();
            if ((double)tet.rotation == 0.0) {
                tet.rotation = 360.0f;
            }
            data.setActualLandRotation(tet.rotation);
            if (world.func_175726_f(pos).func_150802_k()) {
                tet.setRemat(true);
                tet.func_73660_a();
                tet.func_70296_d();
                WorldUtils.markBlockForUpdate(world, pos);
            }
            data.setInFlight(false);
            if (world2.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
                ChameleonCircuitBase base = DMTardis.getTardisSkin(data.getExteriorID());
                world2.func_184133_a(null, playerIn.func_180425_c(), base.travelSound(false), SoundCategory.MASTER, 1.0f, 1.0f);
            }
            tet.tempTardisData = data;
        }
        TardisSaveHandler.saveTardis(data);
    }

    public static boolean tardisDematRemat(World worldIn, BlockPos pos, EntityPlayer playerIn, boolean isRegen) {
        TardisData data;
        ITardisCapability capa;
        int TardisID;
        if (!worldIn.field_72995_K && DMTardis.doesTardisExist(TardisID = (capa = (ITardisCapability)playerIn.getCapability(CapabilityTardis.FLIGHTMODE_CAP, null)).getTARDISID()) && (data = DMTardis.getTardis(TardisID)) != null) {
            int dimensionToGoTo = data.getTardisDestinationDimension();
            if (!DimensionManager.isDimensionRegistered((int)dimensionToGoTo)) {
                dimensionToGoTo = 0;
                data.setTardisDestinationDimension(0);
                PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "Dimension does not exist or is not enabled on this server.");
                PlayerUtils.Messaging.sendMessageToPlayer(playerIn, TextFormatting.RED + "Dimension changed to OVERWORLD");
            }
            ChameleonCircuitBase base = DMTardis.getTardisSkin(data.getExteriorID());
            if (DMTardis.hasPermission(data, playerIn)) {
                int DimID = data.getTardisCurrentdimension();
                if (!DimensionManager.isDimensionRegistered((int)DimID)) {
                    ActionList.forceTardisOverWorld(data);
                    return false;
                }
                BlockPos p = new BlockPos(data.getCurrentTardisPosition().x, data.getCurrentTardisPosition().y, data.getCurrentTardisPosition().z);
                WorldServer world = playerIn.func_184102_h().func_71218_a(DimID);
                TileEntity te = world.func_175625_s(p);
                if (te == null) {
                    world = playerIn.func_184102_h().func_71218_a(dimensionToGoTo);
                    ActionList.lowHealthActions(data, playerIn);
                    ActionList.calculateLanding(playerIn, data, (World)world, worldIn);
                    worldIn.func_184133_a(null, p, base.travelSound(false), SoundCategory.MASTER, 1.0f, 1.0f);
                } else {
                    if (world.func_175726_f(p).func_150802_k()) {
                        if (((TileEntityTardis)te).isDemat) {
                            data.setInFlight(true);
                            world.func_175698_g(p);
                            TardisSaveHandler.saveTardis(data);
                            world = playerIn.func_184102_h().func_71218_a(dimensionToGoTo);
                            ActionList.lowHealthActions(data, playerIn);
                            ActionList.calculateLanding(playerIn, data, (World)world, worldIn);
                            world.func_184133_a(null, playerIn.func_180425_c(), base.travelSound(true), SoundCategory.MASTER, 1.0f, 1.0f);
                            return true;
                        }
                        data.setInFlight(true);
                        ((TileEntityTardis)te).setDemat(true);
                        ((TileEntityTardis)te).sendUpdates();
                        TardisSaveHandler.saveTardis(data);
                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Your Tardis has dematerialised"));
                        worldIn.func_184133_a(null, pos, base.travelSound(true), SoundCategory.MASTER, 1.0f, 1.0f);
                    } else {
                        data.setInFlight(true);
                        world.func_175698_g(p);
                        TardisSaveHandler.saveTardis(data);
                        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Your Tardis has dematerialised"));
                        worldIn.func_184133_a(null, pos, base.travelSound(true), SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                    ((TileEntityTardis)te).tempTardisData = data;
                }
            }
        }
        return true;
    }

    public static void hadsRelocation(int tardisId) {
    }

    public static void forceTardisOverWorld(TardisData data) {
        if (data != null) {
            data.setTardisCurrentDimensionLocation(0);
            data.setTardisDestinationDimension(0);
            TardisSaveHandler.saveTardis(data);
        }
    }

    public static void lowHealthActions(TardisData data, EntityPlayer p) {
        if (data.getTardisHealth() <= 20 && data.getTravelToLocation() != null) {
            Random r = new Random();
            Vector3 v = data.getTravelToLocation();
            data.setTravelToLocation(new Vector3(v.x + r.nextInt(20), v.y + r.nextInt(20), v.z + r.nextInt(20)));
            p.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "" + TextFormatting.BOLD + "The tardis has drifted!"), true);
        }
    }

    public static boolean isInsideTardisForceField(EntityPlayer player) {
        for (BlockPos pos : BlockPos.func_191532_a((int)((int)player.field_70165_t - 4), (int)((int)player.field_70163_u - 4), (int)((int)player.field_70161_v - 4), (int)((int)player.field_70165_t + 4), (int)((int)player.field_70163_u + 4), (int)((int)player.field_70161_v + 4))) {
            if (!(player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockTardis) || player.field_70170_p.func_175625_s(pos) == null || !(player.field_70170_p.func_175625_s(pos) instanceof TileEntityTardis) || !((TileEntityTardis)player.field_70170_p.func_175625_s((BlockPos)pos)).forceField || !(player.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 3.25)) continue;
            return true;
        }
        return false;
    }

    public static EnumActionResult sonicInteraction(World worldIn, EntityPlayer playerIn, BlockPos pos, float pitch, SoundEvent useSound) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        boolean canGrief = DMConfig.serverSide.SONIC_GRIEFING;
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            if (block == Blocks.field_150335_W) {
                if (canGrief) {
                    DMUtils.setBlock(worldIn, posX, posY, posZ, Blocks.field_150350_a);
                    EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldIn, (double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), (EntityLivingBase)playerIn);
                    worldIn.func_72838_d((Entity)entitytntprimed);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.MASTER, 1.0f, 1.0f);
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has soniced TNT and created a explosion at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (block instanceof BlockLeaves && canGrief || block instanceof BlockDMLeaves && canGrief) {
                if (canGrief) {
                    DMUtils.setBlock(worldIn, posX, posY, posZ, (Block)Blocks.field_150480_ab);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.MASTER, 1.0f, 1.0f);
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has burned leaves at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (block == Blocks.field_150354_m) {
                if (canGrief) {
                    DMUtils.setBlock(worldIn, posX, posY, posZ, Blocks.field_150359_w);
                    DMUtils.setBlock(worldIn, posX, posY - 1, posZ, (Block)Blocks.field_150480_ab);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187904_gd, SoundCategory.MASTER, 1.0f, 1.0f);
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has converted sand to class at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (block == Blocks.field_150379_bu) {
                DMUtils.setBlock(worldIn, posX, posY, posZ, DMBlocks.redstoneLampOn);
                worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                return EnumActionResult.SUCCESS;
            }
            if (block == DMBlocks.bTeNitroNine) {
                if (canGrief) {
                    TileEntityNitro9 tenn = (TileEntityNitro9)worldIn.func_175625_s(pos);
                    tenn.lit = !tenn.lit;
                    tenn.activated = (EntityPlayerMP)playerIn;
                    worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                    TheDalekMod.LOG.info("[Server-Logging] " + playerIn.func_70005_c_() + " has soniced Nitro9 and created a explosion at: " + pos);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (block == DMBlocks.redstoneLampOn) {
                DMUtils.setBlock(worldIn, posX, posY, posZ, Blocks.field_150379_bu);
                worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                return EnumActionResult.SUCCESS;
            }
            if (block instanceof BlockOre) {
                if (block == Blocks.field_150366_p) {
                    DMUtils.setBlock(worldIn, posX, posY, posZ, Blocks.field_150350_a);
                    playerIn.func_145779_a(Items.field_151042_j, 1);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187557_bK, SoundCategory.MASTER, 1.0f, pitch);
                }
                if (block == Blocks.field_150352_o) {
                    DMUtils.setBlock(worldIn, posX, posY, posZ, Blocks.field_150350_a);
                    playerIn.func_145779_a(Items.field_151043_k, 1);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187557_bK, SoundCategory.MASTER, 1.0f, pitch);
                }
                if (block == Blocks.field_150425_aM) {
                    DMUtils.setBlock(worldIn, posX, posY, posZ, Blocks.field_150350_a);
                    playerIn.func_145779_a(Items.field_151103_aS, 3);
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_189105_bM, SoundCategory.MASTER, 1.0f, pitch);
                }
                worldIn.func_175704_b(pos, pos);
                worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
                worldIn.func_180497_b(pos, block, 0, 0);
            }
            if (block instanceof BlockDoor) {
                BlockDoor door = (BlockDoor)block;
                boolean open = (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176519_b);
                if (worldIn.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150454_av) {
                    open = (Boolean)worldIn.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177229_b((IProperty)BlockDoor.field_176519_b);
                    door.func_176512_a(worldIn, pos.func_177982_a(0, -1, 0), !open);
                } else {
                    door.func_176512_a(worldIn, pos, !open);
                }
                WorldUtils.markBlockForUpdate(worldIn, pos);
                worldIn.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
                return EnumActionResult.SUCCESS;
            }
            if (block instanceof BlockTrapDoor) {
                worldIn.func_180501_a(pos, worldIn.func_180495_p(pos).func_177231_a((IProperty)BlockTrapDoor.field_176283_b), 2);
                WorldUtils.markBlockForUpdate(worldIn, pos);
                worldIn.func_175704_b(pos, pos);
                worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
                worldIn.func_180497_b(pos, block, 0, 0);
                return EnumActionResult.SUCCESS;
            }
            playerIn.field_70170_p.func_184133_a(playerIn, pos, useSound, SoundCategory.MASTER, 1.0f, pitch);
        }
        return EnumActionResult.FAIL;
    }
}

