/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block.tardis;

import com.swdteam.common.block.BlockDMTileEntityBase;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.init.DMTardisSkinReg;
import com.swdteam.common.item.ItemTardisKey;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.math.MathUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTardis
extends BlockDMTileEntityBase {
    private static AxisAlignedBB TARDIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockTardis(Supplier<TileEntity> tClass) {
        super(tClass);
        this.func_149711_c(50.0f);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), DMSounds.CloisterBell, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        super.func_180652_a(world, pos, explosionIn);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 15;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (!DMConfig.serverSide.DROP_TARDIS_ITEM) {
            return null;
        }
        return Item.func_150898_a((Block)this);
    }

    public static ChameleonCircuitBase getSkin(World w, BlockPos p) {
        TileEntityTardis te = (TileEntityTardis)w.func_175625_s(p);
        TardisData data = te.tempTardisData;
        if (data == null) {
            return DMTardisSkinReg.SKIN_DEFAULT;
        }
        return DMTardis.getTardisSkin(data.getExteriorID());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        boolean b = false;
        if (player.func_184614_ca().func_77973_b() != Items.field_190931_a && (player.func_184614_ca().func_77973_b() instanceof ItemTardisKey || player.func_184614_ca().func_77973_b() == DMItems.iStatRemote)) {
            return false;
        }
        if (world.field_73011_w.getDimension() == DMDimensions.DIM_TARDIS_ID) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Are you mad?"));
        }
        if ((te = world.func_175625_s(pos)) instanceof TileEntityTardis) {
            TileEntityTardis tardis = (TileEntityTardis)te;
            TardisData data = tardis.tempTardisData;
            if (tardis.pulses != -1) {
                PlayerUtils.Messaging.sendStatusMessageToPlayer(player, TextFormatting.BOLD + "Materialising...", true);
                return false;
            }
            if (!world.field_72995_K) {
                data.setCurrentTardisPosition(MathUtils.blockPosToVec3(pos));
                if (data != null) {
                    if (data.isInFlight()) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You cannot enter the Tardis during materialization, Please wait."));
                        return true;
                    }
                    if (data.isLocked()) {
                        DMSounds.playSound(player, DMSounds.DoorLocked, SoundCategory.BLOCKS, pos, 1.0f, 1.0f);
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + data.getOwner() + "'s Tardis is locked."));
                        return true;
                    }
                }
                BlockTardis.getSkin(world, pos).onRightClick(world, player, pos, tardis, false, false);
            }
        }
        return !b;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return super.func_176209_a(state, hitIfLiquid);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TARDIS_AABB;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return TARDIS_AABB;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(pos);
        if (tardis != null && tardis.tempTardisData != null && !tardis.tempTardisData.isDoorOpen()) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, p_185477_7_);
        }
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int damage = 1;
        TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(pos);
        if (tardis != null && tardis.tempTardisData != null) {
            damage = tardis.tempTardisData.getExteriorID();
        }
        ItemStack stack = new ItemStack(DMItems.iTardis, 1, damage);
        return stack;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileEntityTardis tardis = (TileEntityTardis)world.func_175625_s(pos);
        if (tardis != null && tardis.tempTardisData != null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return super.func_180640_a(state, world, pos);
    }
}

